/*
 * Decompiled with CFR 0.152.
 */
package com.redcraft86.simplecloudscompat.mixin;

import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> loadedMods = new HashSet<String>();

    public boolean shouldApplyMixin(String targetClass, String mixinClass) {
        boolean hasDependency = true;
        if (mixinClass.contains(".cyclic.")) {
            hasDependency = MixinPlugin.isModIncluded("cyclic");
        }
        if (mixinClass.contains(".supplementaries.")) {
            hasDependency = MixinPlugin.isModIncluded("supplementaries");
        }
        LOGGER.info("[Simple Clouds Compat] {} Mixin: {}", (Object)(hasDependency ? "Loading" : "Skipping"), (Object)mixinClass);
        return hasDependency;
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    private static boolean isModIncluded(String modID) {
        if (loadedMods.contains(modID)) {
            return true;
        }
        if (FMLLoader.getLoadingModList().getModFileById(modID) != null) {
            loadedMods.add(modID);
            return true;
        }
        return false;
    }
}

