/*
 * Decompiled with CFR 0.152.
 */
package com.redcraft86.simplecloudscompat;

import dev.nonamecrackers2.simpleclouds.common.cloud.CloudType;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="simplecloudscompat")
public class SCCompat {
    public static final String MOD_ID = "simplecloudscompat";

    public SCCompat(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean isRaining(Level level, BlockPos pos, boolean checkSides) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos checkPos = pos.m_7494_();
            if (level.m_46859_(checkPos)) {
                return serverLevel.m_46758_(checkPos);
            }
            if (!checkSides) {
                return false;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                checkPos = pos.m_121945_(direction);
                if (!level.m_46859_(checkPos)) continue;
                return serverLevel.m_46758_(checkPos);
            }
        }
        return false;
    }

    public static boolean isSnowing(Level level, BlockPos pos, boolean checkSides) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CloudManager manager = CloudManager.get((Level)serverLevel);
            BlockPos checkPos = pos.m_7494_();
            if (manager.shouldUseVanillaWeather()) {
                return serverLevel.m_46758_(checkPos);
            }
            if (level.m_46859_(checkPos)) {
                return manager.isSnowingAt(checkPos);
            }
            if (!checkSides) {
                return false;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                checkPos = pos.m_121945_(direction);
                if (!level.m_46859_(checkPos)) continue;
                return manager.isSnowingAt(checkPos);
            }
        }
        return false;
    }

    public static boolean isThundering(Level level, BlockPos pos, boolean checkSides) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CloudManager manager = CloudManager.get((Level)serverLevel);
            if (manager.shouldUseVanillaWeather()) {
                return serverLevel.m_46470_();
            }
            if (!SCCompat.isRaining(level, pos, checkSides)) {
                return false;
            }
            return ((CloudType)manager.getCloudTypeAtPosition((float)pos.m_123341_(), (float)pos.m_123343_()).getLeft()).weatherType().includesThunder();
        }
        return false;
    }
}

