/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.command;

import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.TreeMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.resource.OneTimeLoader;

public class ExportShapesCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"shapes").executes(ctx -> ExportShapesCommand.exportShapes((CommandSourceStack)ctx.getSource())));
    }

    private static int exportShapes(CommandSourceStack source) {
        TreeMap data = Maps.newTreeMap();
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get("exported_shapes.json", new String[0]), new OpenOption[0]);){
            BlockFundamentals fundamentals = BlockFundamentals.reload(CustomizationHooks.collectKiwiPacks(), new OneTimeLoader.Context(), false);
            fundamentals.shapes().forEach((key, value) -> {
                if (value.getClass() != ShapeGenerator.Unit.class) {
                    return;
                }
                String string = key.toString();
                if ("minecraft:empty".equals(string) || "minecraft:block".equals(string)) {
                    return;
                }
                data.put(string, UnbakedShapeCodec.encodeVoxelShape(ShapeGenerator.Unit.unboxOrThrow(value)));
            });
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)data, (Appendable)writer);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)e.getMessage()));
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Shapes exported"), false);
        return 1;
    }
}

