/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.mutable.MutableObject;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.GroupSetting;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.ModContext;
import snownee.kiwi.NamedEntry;
import snownee.kiwi.block.IKiwiBlock;
import snownee.kiwi.item.ItemCategoryFiller;
import snownee.kiwi.item.ModBlockItem;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.loader.event.ServerInitEvent;

public class ModuleInfo {
    public final AbstractModule module;
    public final ModContext context;
    public GroupSetting groupSetting;
    final RegistryHolder registries = new RegistryHolder();
    final Map<Block, Item.Properties> blockItemBuilders = Maps.newHashMap();
    final Set<Object> noCategories = Sets.newHashSet();
    final Set<Block> noItems = Sets.newHashSet();

    public ModuleInfo(ResourceLocation rl, AbstractModule module, ModContext context) {
        this.module = module;
        this.context = context;
        module.uid = rl;
        if (DatagenModLoader.isRunningDataGen() && context.modContainer instanceof FMLModContainer) {
            ((FMLModContainer)context.modContainer).getEventBus().addListener(module::gatherData);
        }
    }

    public void register(Object object, ResourceLocation name, Object registry, @Nullable Field field) {
        KiwiModule.Category group;
        NamedEntry<Object> entry = new NamedEntry<Object>(name, object, registry, field);
        this.registries.put(entry);
        if (field != null && (group = field.getAnnotation(KiwiModule.Category.class)) != null) {
            entry.groupSetting = GroupSetting.of(group, this.groupSetting);
        }
    }

    public void handleRegister(Object registry) {
        this.context.setActiveContainer();
        Collection<NamedEntry<?>> entries = this.registries.get(registry);
        BiConsumer<ModuleInfo, Object> decorator = this.module.decorators.getOrDefault(registry, (a, b) -> {});
        if (registry == ForgeRegistries.ITEMS) {
            this.handleRegister(BuiltInRegistries.f_279662_);
            this.registries.get(ForgeRegistries.BLOCKS).forEach(e -> {
                if (this.noItems.contains(e.entry)) {
                    return;
                }
                Item.Properties builder = this.blockItemBuilders.get(e.entry);
                if (builder == null) {
                    builder = new Item.Properties();
                }
                Object item = e.entry instanceof IKiwiBlock ? ((IKiwiBlock)e.entry).createItem(builder) : new ModBlockItem((Block)e.entry, builder);
                if (this.noCategories.contains(e.entry)) {
                    this.noCategories.add(item);
                }
                NamedEntry<BlockItem> itemEntry = new NamedEntry<BlockItem>(e.name, (BlockItem)item, registry, null);
                itemEntry.groupSetting = e.groupSetting;
                entries.add(itemEntry);
            });
            LinkedHashSet groupSettings = Sets.newLinkedHashSet();
            MutableObject prevSetting = new MutableObject();
            if (this.groupSetting != null) {
                prevSetting.setValue((Object)this.groupSetting);
                groupSettings.add(this.groupSetting);
            }
            entries.forEach(e -> {
                Item item = (Item)e.entry;
                if (this.noCategories.contains(item)) {
                    prevSetting.setValue((Object)this.groupSetting);
                    return;
                }
                ItemCategoryFiller filler = item instanceof ItemCategoryFiller ? (ItemCategoryFiller)item : (tab, flags, hasPermissions, items) -> items.add(new ItemStack((ItemLike)item));
                if (e.groupSetting != null) {
                    e.groupSetting.apply(filler);
                    groupSettings.add(e.groupSetting);
                    prevSetting.setValue((Object)e.groupSetting);
                } else if (prevSetting.getValue() != null) {
                    ((GroupSetting)prevSetting.getValue()).apply(filler);
                }
            });
            groupSettings.forEach(GroupSetting::postApply);
        }
        entries.forEach(e -> {
            decorator.accept(this, e.entry);
            if (registry instanceof Registry) {
                Registry.m_122965_((Registry)((Registry)registry), (ResourceLocation)e.name, e.entry);
            } else if (registry instanceof IForgeRegistry) {
                ((IForgeRegistry)registry).register(e.name, e.entry);
            } else {
                throw new RuntimeException("registry is invalid");
            }
        });
        if (registry == ForgeRegistries.BLOCKS && Platform.isPhysicalClient() && !Platform.isDataGen()) {
            RenderType solid = RenderType.m_110451_();
            HashMap cache = Maps.newHashMap();
            entries.stream().forEach(e -> {
                RenderType type;
                KiwiModule.RenderLayer layer;
                Block block = (Block)e.entry;
                if (e.field != null && (layer = e.field.getAnnotation(KiwiModule.RenderLayer.class)) != null && (type = (RenderType)layer.value().value) != solid && type != null) {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
                    return;
                }
                Class<?> klass = block.getClass();
                type = cache.computeIfAbsent(klass, k -> {
                    while (k != Block.class) {
                        KiwiModule.RenderLayer layer = k.getDeclaredAnnotation(KiwiModule.RenderLayer.class);
                        if (layer != null) {
                            return (RenderType)layer.value().value;
                        }
                        k = k.getSuperclass();
                    }
                    return solid;
                });
                if (type != solid && type != null) {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
                }
            });
        }
    }

    public void preInit() {
        this.context.setActiveContainer();
        this.module.preInit();
        KiwiModules.ALL_USED_REGISTRIES.addAll(this.registries.registries.keySet());
    }

    public void init(InitEvent event) {
        this.context.setActiveContainer();
        this.module.init(event);
    }

    public void clientInit(ClientInitEvent event) {
        this.context.setActiveContainer();
        this.module.clientInit(event);
    }

    public void serverInit(ServerInitEvent event) {
        this.context.setActiveContainer();
        this.module.serverInit(event);
    }

    public void postInit(PostInitEvent event) {
        this.context.setActiveContainer();
        this.module.postInit(event);
    }

    public <T> List<T> getRegistries(Object registry) {
        return this.registries.get(registry).stream().map($ -> $.entry).collect(Collectors.toList());
    }

    public <T> Stream<NamedEntry<T>> getRegistryEntries(Object registry) {
        return this.registries.get(registry).stream().map($ -> $);
    }

    public static final class RegistryHolder {
        final Multimap<Object, NamedEntry<?>> registries = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().linkedListValues().build();

        void put(NamedEntry<?> entry) {
            this.registries.put(entry.registry, entry);
        }

        Collection<NamedEntry<?>> get(Object registry) {
            return this.registries.get(registry);
        }
    }
}

