/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.util;

import dev.doctor4t.trainmurdermystery.TMM;
import dev.doctor4t.trainmurdermystery.block_entity.TrimmedBedBlockEntity;
import dev.doctor4t.trainmurdermystery.cca.PlayerPoisonComponent;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class PoisonUtils {
    public static float getFovMultiplier(float tickDelta, PlayerPoisonComponent poisonComponent) {
        if (!poisonComponent.pulsing) {
            return 1.0f;
        }
        poisonComponent.pulseProgress += tickDelta * 0.1f;
        if (poisonComponent.pulseProgress >= 1.0f) {
            poisonComponent.pulsing = false;
            poisonComponent.pulseProgress = 0.0f;
            return 1.0f;
        }
        float maxAmplitude = 0.1f;
        float minAmplitude = 0.025f;
        float result = PoisonUtils.getResult(poisonComponent, minAmplitude, maxAmplitude);
        return result;
    }

    private static float getResult(PlayerPoisonComponent poisonComponent, float minAmplitude, float maxAmplitude) {
        float amplitude = minAmplitude + (maxAmplitude - minAmplitude) * (1.0f - (float)poisonComponent.poisonTicks / 1200.0f);
        float result = poisonComponent.pulseProgress < 0.25f ? 1.0f - amplitude * (float)Math.sin(Math.PI * (double)(poisonComponent.pulseProgress / 0.25f)) : (poisonComponent.pulseProgress < 0.5f ? 1.0f - amplitude * (float)Math.sin(Math.PI * (double)((poisonComponent.pulseProgress - 0.25f) / 0.25f)) : 1.0f);
        return result;
    }

    public static void bedPoison(class_3222 player) {
        class_2338 bedPos;
        class_1937 world = player.method_5770();
        TrimmedBedBlockEntity blockEntity = PoisonUtils.findHeadInBoxWithObstacles(world, bedPos = player.method_24515());
        if (blockEntity == null) {
            return;
        }
        if (!world.field_9236) {
            blockEntity.setHasScorpion(false, null);
            int poisonTicks = ((PlayerPoisonComponent)PlayerPoisonComponent.KEY.get((Object)player)).poisonTicks;
            UUID poisoner = blockEntity.getPoisoner();
            if (poisonTicks == -1) {
                ((PlayerPoisonComponent)PlayerPoisonComponent.KEY.get((Object)player)).setPoisonTicks(world.method_8409().method_39332(((Integer)PlayerPoisonComponent.clampTime.method_15442()).intValue(), ((Integer)PlayerPoisonComponent.clampTime.method_15441()).intValue()), poisoner);
            } else {
                ((PlayerPoisonComponent)PlayerPoisonComponent.KEY.get((Object)player)).setPoisonTicks(class_3532.method_15340((int)(poisonTicks - world.method_8409().method_39332(100, 300)), (int)0, (int)((Integer)PlayerPoisonComponent.clampTime.method_15441())), poisoner);
            }
            ServerPlayNetworking.send((class_3222)player, (class_8710)new PoisonOverlayPayload("game.player.stung"));
        }
    }

    private static TrimmedBedBlockEntity findHeadInBoxWithObstacles(class_1937 world, class_2338 centerPos) {
        int radius = 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 pos = centerPos.method_10069(dx, dy, dz);
                    TrimmedBedBlockEntity entity = PoisonUtils.resolveHead(world, pos);
                    if (entity == null || !entity.hasScorpion() || !PoisonUtils.isLineClear(world, centerPos, pos)) continue;
                    return entity;
                }
            }
        }
        return null;
    }

    private static boolean isLineClear(class_1937 world, class_2338 start, class_2338 end) {
        int x0 = start.method_10263();
        int y0 = start.method_10264();
        int z0 = start.method_10260();
        int x1 = end.method_10263();
        int y1 = end.method_10264();
        int z1 = end.method_10260();
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int dz = Math.abs(z1 - z0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int sz = z0 < z1 ? 1 : -1;
        int ax = 2 * dx;
        int ay = 2 * dy;
        int az = 2 * dz;
        if (dx >= dy && dx >= dz) {
            int err1 = ay - dx;
            int err2 = az - dx;
            while (x0 != x1) {
                x0 += sx;
                if (err1 > 0) {
                    y0 += sy;
                    err1 -= 2 * dx;
                }
                if (err2 > 0) {
                    z0 += sz;
                    err2 -= 2 * dx;
                }
                err1 += ay;
                err2 += az;
                if (!PoisonUtils.isBlocking(world, new class_2338(x0, y0, z0))) continue;
                return false;
            }
        } else if (dy >= dx && dy >= dz) {
            int err1 = ax - dy;
            int err2 = az - dy;
            while (y0 != y1) {
                y0 += sy;
                if (err1 > 0) {
                    x0 += sx;
                    err1 -= 2 * dy;
                }
                if (err2 > 0) {
                    z0 += sz;
                    err2 -= 2 * dy;
                }
                err1 += ax;
                err2 += az;
                if (!PoisonUtils.isBlocking(world, new class_2338(x0, y0, z0))) continue;
                return false;
            }
        } else {
            int err1 = ay - dz;
            int err2 = ax - dz;
            while (z0 != z1) {
                z0 += sz;
                if (err1 > 0) {
                    y0 += sy;
                    err1 -= 2 * dz;
                }
                if (err2 > 0) {
                    x0 += sx;
                    err2 -= 2 * dz;
                }
                err1 += ay;
                err2 += ax;
                if (!PoisonUtils.isBlocking(world, new class_2338(x0, y0, z0))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isBlocking(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return !(state.method_26204() instanceof class_2244);
    }

    private static TrimmedBedBlockEntity resolveHead(class_1937 world, class_2338 pos) {
        class_2338 headPos;
        class_2586 class_25862;
        class_2586 class_25863 = world.method_8321(pos);
        if (!(class_25863 instanceof TrimmedBedBlockEntity)) {
            return null;
        }
        TrimmedBedBlockEntity entity = (TrimmedBedBlockEntity)class_25863;
        class_2742 part = (class_2742)world.method_8320(pos).method_11654((class_2769)class_2244.field_9967);
        class_2350 facing = (class_2350)world.method_8320(pos).method_11654((class_2769)class_2383.field_11177);
        if (part == class_2742.field_12560) {
            return entity;
        }
        if (part == class_2742.field_12557 && (class_25862 = world.method_8321(headPos = pos.method_10093(facing))) instanceof TrimmedBedBlockEntity) {
            TrimmedBedBlockEntity headEntity = (TrimmedBedBlockEntity)class_25862;
            if (world.method_8320(headPos).method_11654((class_2769)class_2244.field_9967) == class_2742.field_12560) {
                return headEntity;
            }
        }
        return null;
    }

    public record PoisonOverlayPayload(String translationKey) implements class_8710
    {
        public static final class_8710.class_9154<PoisonOverlayPayload> ID = new class_8710.class_9154(TMM.id("poisoned_text"));
        public static final class_9139<class_9129, PoisonOverlayPayload> CODEC = class_9139.method_56438(PoisonOverlayPayload::write, PoisonOverlayPayload::read);

        private void write(class_9129 buf) {
            buf.method_10814(this.translationKey);
        }

        private static PoisonOverlayPayload read(class_9129 buf) {
            return new PoisonOverlayPayload(buf.method_19772());
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }

        public static class Receiver
        implements ClientPlayNetworking.PlayPayloadHandler<PoisonOverlayPayload> {
            public void receive(@NotNull PoisonOverlayPayload payload, // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull ClientPlayNetworking.Context context) {
                class_310 client = class_310.method_1551();
                client.execute(() -> client.field_1705.method_1758((class_2561)class_2561.method_43471((String)payload.translationKey()), false));
            }
        }
    }
}

