/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.mixin.client;

import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.sugar.Local;
import dev.doctor4t.trainmurdermystery.client.TMMClient;
import dev.doctor4t.trainmurdermystery.client.render.entity.PlayerBodyEntityRenderer;
import dev.doctor4t.trainmurdermystery.entity.PlayerBodyEntity;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_3300;
import net.minecraft.class_5617;
import net.minecraft.class_640;
import net.minecraft.class_8685;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_898.class})
public class EntityRendererDispatchMixin {
    @Unique
    private static final Map<class_8685.class_7920, class_5617<PlayerBodyEntity>> PLAYER_BODY_RENDERER_FACTORIES = Map.of(class_8685.class_7920.field_41123, context -> new PlayerBodyEntityRenderer(context, false), class_8685.class_7920.field_41122, context -> new PlayerBodyEntityRenderer(context, true));
    @Unique
    private Map<class_8685.class_7920, class_897<? extends PlayerBodyEntity>> bodyModelRenderers = Map.of();

    @Inject(method={"method_14491(Lnet/minecraft/class_3300;)V"}, at={@At(value="TAIL")})
    public void reload(class_3300 manager, CallbackInfo ci, @Local class_5617.class_5618 context) {
        this.bodyModelRenderers = EntityRendererDispatchMixin.reloadPlayerBodyRenderers(context);
    }

    @Inject(method={"method_3953(Lnet/minecraft/class_1297;)Lnet/minecraft/class_897;"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends class_1297> void tmm$addPlayerBodyRenderer(T entity, CallbackInfoReturnable<class_897<? super T>> cir) {
        if (entity instanceof PlayerBodyEntity) {
            PlayerBodyEntity body = (PlayerBodyEntity)entity;
            class_640 playerListEntry = TMMClient.PLAYER_ENTRIES_CACHE.get(body.getPlayerUuid());
            if (playerListEntry == null) {
                cir.setReturnValue(this.bodyModelRenderers.get(class_8685.class_7920.field_41123));
            } else {
                class_8685.class_7920 model = playerListEntry.method_52810().comp_1629();
                class_897<? extends PlayerBodyEntity> entityRenderer = this.bodyModelRenderers.get(model);
                cir.setReturnValue(entityRenderer != null ? entityRenderer : this.bodyModelRenderers.get(class_8685.class_7920.field_41123));
            }
        }
    }

    @Unique
    private static Map<class_8685.class_7920, class_897<? extends PlayerBodyEntity>> reloadPlayerBodyRenderers(class_5617.class_5618 ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PLAYER_BODY_RENDERER_FACTORIES.forEach((model, factory) -> {
            try {
                builder.put(model, (Object)factory.create(ctx));
            }
            catch (Exception var5) {
                throw new IllegalArgumentException("Failed to create player body model for " + String.valueOf(model), var5);
            }
        });
        return builder.build();
    }
}

