/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.trainmurdermystery.client.render.entity;

import dev.doctor4t.ratatouille.client.lib.render.helpers.Easing;
import dev.doctor4t.trainmurdermystery.TMM;
import dev.doctor4t.trainmurdermystery.client.TMMClient;
import dev.doctor4t.trainmurdermystery.client.model.TMMModelLayers;
import dev.doctor4t.trainmurdermystery.client.model.entity.PlayerSkeletonEntityModel;
import dev.doctor4t.trainmurdermystery.entity.PlayerBodyEntity;
import dev.doctor4t.trainmurdermystery.game.GameConstants;
import java.awt.Color;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_640;
import net.minecraft.class_7833;
import net.minecraft.class_922;

public class PlayerBodyEntityRenderer<T extends class_1309, M extends class_583<T>>
extends class_922<PlayerBodyEntity, class_591<PlayerBodyEntity>> {
    public static final class_2960 DEFAULT_TEXTURE = TMM.id("textures/entity/player_body_default.png");
    private static final class_2960 SKELETON_TEXTURE = TMM.id("textures/entity/player_skeleton.png");
    protected PlayerSkeletonEntityModel<PlayerBodyEntity> skeletonModel;

    public PlayerBodyEntityRenderer(class_5617.class_5618 ctx, boolean slim) {
        super(ctx, (class_583)new class_591(ctx.method_32167(slim ? TMMModelLayers.PLAYER_BODY_SLIM : TMMModelLayers.PLAYER_BODY), slim), 0.0f);
        this.skeletonModel = new PlayerSkeletonEntityModel(ctx.method_32167(TMMModelLayers.PLAYER_SKELETON));
    }

    public void render(PlayerBodyEntity playerBodyEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        this.setModelPose();
        matrixStack.method_22903();
        float clamp = class_3532.method_15363((float)((float)(playerBodyEntity.field_6012 - GameConstants.TIME_TO_DECOMPOSITION) / (float)GameConstants.DECOMPOSING_TIME), (float)0.0f, (float)(GameConstants.TIME_TO_DECOMPOSITION + GameConstants.DECOMPOSING_TIME));
        float ease = Easing.CUBIC_IN.ease(clamp, 0.0f, -1.0f, 1.0f);
        if (ease > -1.0f) {
            matrixStack.method_46416(0.0f, ease, 0.0f);
            float alpha = TMMClient.moodComponent.isLowerThanDepressed() ? class_3532.method_16439((float)class_3532.method_15363((float)Easing.SINE_IN.ease(Math.min(1.0f, (float)playerBodyEntity.field_6012 / 100.0f), 0.0f, 1.0f, 1.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)0.0f) : 1.0f;
            this.renderBody(playerBodyEntity, f, g, matrixStack, vertexConsumerProvider, light, alpha);
        }
        matrixStack.method_22909();
        this.renderSkeleton(playerBodyEntity, f, g, matrixStack, vertexConsumerProvider, light, TMMClient.moodComponent.isLowerThanDepressed() ? 0.0f : 1.0f);
    }

    public void renderBody(PlayerBodyEntity livingEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, float alpha) {
        boolean bl = this.method_4056(livingEntity);
        class_310 client = class_310.method_1551();
        boolean bl2 = !bl && !livingEntity.method_5756((class_1657)client.field_1724);
        boolean bl3 = client.method_27022((class_1297)livingEntity);
        class_1921 bodyRenderLayer = this.method_24302(livingEntity, bl, bl2, bl3);
        this.render(livingEntity, f, g, matrixStack, vertexConsumerProvider, light, (class_572<PlayerBodyEntity>)((class_572)this.field_4737), bodyRenderLayer, 1.0f, alpha);
    }

    public void renderSkeleton(PlayerBodyEntity livingEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, float alpha) {
        this.render(livingEntity, f, g, matrixStack, vertexConsumerProvider, light, this.skeletonModel, this.getSkeletonRenderLayer(), 0.95f, alpha);
    }

    public void render(PlayerBodyEntity livingEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, class_572<PlayerBodyEntity> model, class_1921 renderLayer, float scale, float alpha) {
        if (alpha > 0.0f) {
            boolean bl2;
            matrixStack.method_22903();
            ((class_591)this.field_4737).field_3447 = this.getHandSwingProgress(livingEntity, g);
            ((class_591)this.field_4737).field_3449 = livingEntity.method_5765();
            ((class_591)this.field_4737).field_3448 = livingEntity.method_6109();
            float h = class_3532.method_17821((float)g, (float)livingEntity.field_6220, (float)livingEntity.field_6283);
            float j = class_3532.method_17821((float)g, (float)livingEntity.field_6259, (float)livingEntity.field_6241);
            float k = j - h;
            float m = class_3532.method_16439((float)g, (float)livingEntity.field_6004, (float)livingEntity.method_36455());
            if (PlayerBodyEntityRenderer.method_38563((class_1309)livingEntity)) {
                m *= -1.0f;
                k *= -1.0f;
            }
            float lx = livingEntity.method_55693();
            matrixStack.method_22905(lx, lx, lx);
            float n = this.getAnimationProgress(livingEntity, g);
            this.setupTransforms(livingEntity, matrixStack, n, h, g, lx);
            matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
            this.scale(livingEntity, matrixStack, g);
            matrixStack.method_46416(0.0f, -1.501f, 0.0f);
            float o = 0.0f;
            float p = 0.0f;
            if (!livingEntity.method_5765() && livingEntity.method_5805()) {
                o = livingEntity.field_42108.method_48570(g);
                p = livingEntity.field_42108.method_48572(g);
                if (livingEntity.method_6109()) {
                    p *= 3.0f;
                }
                if (o > 1.0f) {
                    o = 1.0f;
                }
            }
            model.method_17086((class_1309)livingEntity, p, o, g);
            model.method_17087((class_1309)livingEntity, p, o, n, k, m);
            class_310 minecraftClient = class_310.method_1551();
            boolean bl = this.method_4056(livingEntity);
            boolean bl3 = bl2 = !bl && !livingEntity.method_5756((class_1657)minecraftClient.field_1724);
            if (renderLayer != null) {
                class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(renderLayer);
                int q = PlayerBodyEntityRenderer.method_23622((class_1309)livingEntity, (float)this.method_23185(livingEntity, g));
                matrixStack.method_22903();
                matrixStack.method_22905(scale, scale, scale);
                Color color = new Color(1.0f, 1.0f, 1.0f, alpha);
                model.method_2828(matrixStack, vertexConsumer, light, q, bl2 ? 0x26FFFFFF : color.getRGB());
                matrixStack.method_22909();
            }
            matrixStack.method_22909();
        }
    }

    private class_1921 getSkeletonRenderLayer() {
        return ((class_591)this.field_4737).method_23500(SKELETON_TEXTURE);
    }

    private void setModelPose() {
        class_591 playerEntityModel = (class_591)this.method_4038();
        playerEntityModel.method_2805(false);
        playerEntityModel.field_3398.field_3665 = true;
        playerEntityModel.field_3394.field_3665 = true;
        playerEntityModel.method_2805(true);
        playerEntityModel.field_3394.field_3665 = true;
        playerEntityModel.field_3483.field_3665 = true;
        playerEntityModel.field_3482.field_3665 = true;
        playerEntityModel.field_3479.field_3665 = true;
        playerEntityModel.field_3484.field_3665 = true;
        playerEntityModel.field_3486.field_3665 = true;
        this.skeletonModel.method_2805(true);
        this.skeletonModel.field_3448 = false;
    }

    public class_2960 getTexture(PlayerBodyEntity playerBodyEntity) {
        class_640 playerListEntry = TMMClient.PLAYER_ENTRIES_CACHE.get(playerBodyEntity.getPlayerUuid());
        if (playerListEntry != null) {
            return playerListEntry.method_52810().comp_1626();
        }
        return DEFAULT_TEXTURE;
    }

    protected void renderLabelIfPresent(PlayerBodyEntity entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light, float tickDelta) {
    }

    protected void setupTransforms(PlayerBodyEntity entity, class_4587 matrices, float animationProgress, float bodyYaw, float tickDelta, float scale) {
        int animTickEnd = 20;
        float t = Math.min((float)entity.field_6012 + tickDelta, (float)animTickEnd) / (float)animTickEnd;
        float animProgress = Easing.BOUNCE_OUT.ease(t, 0.0f, 1.0f, 1.0f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f - bodyYaw));
        matrices.method_46416(1.0f, 0.0f, 0.0f);
        matrices.method_46416(0.0f, animProgress * 0.15f, 0.0f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(animProgress * this.method_4039(entity)));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
    }

    protected void scale(PlayerBodyEntity entity, class_4587 matrices, float amount) {
        float g = 0.9375f;
        matrices.method_22905(g, g, g);
    }

    protected float getHandSwingProgress(PlayerBodyEntity entity, float tickDelta) {
        return 0.0f;
    }

    protected float getAnimationProgress(PlayerBodyEntity entity, float tickDelta) {
        return 0.1f;
    }
}

