/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.core.ModrinthApi;
import com.koteinik.chunksfadein.platform.Services;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class UpdateNotifier {
    public static void checkAndNotify() {
        new Thread(() -> {
            try {
                List<ModrinthApi.ModrinthVersion> newVersions = ModrinthApi.getLatestVersions().stream().takeWhile(UpdateNotifier::isNewerVersion).toList();
                if (!newVersions.isEmpty()) {
                    ModrinthApi.ModrinthVersion latestVersion = newVersions.get(0);
                    ArrayList<MutableComponent> textList = new ArrayList<MutableComponent>();
                    textList.add(Component.m_237113_((String)"\u00a77New version of \u00a72Chunks Fade In \u00a77is available!"));
                    String versions = newVersions.size() == 1 ? "\u00a76v" + String.valueOf(latestVersion.version) : "\u00a76v%s\u00a77-\u00a76v%s".formatted(newVersions.get((int)(newVersions.size() - 1)).version, latestVersion.version);
                    textList.add(Component.m_237113_((String)(versions + "\u00a7r\u00a77 changelog:")));
                    String changelogs = String.join((CharSequence)"\n", newVersions.stream().map(v -> v.changelog).toList()).replace("\r", "");
                    textList.add(Component.m_237113_((String)("\u00a77" + changelogs)));
                    Style issuesLink = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/kerudion/chunksfadein/issues"));
                    textList.addAll(Component.m_237113_((String)"\u00a7cIMPORTANT: Report bugs to Github \u00a7n(click)\u00a7r\u00a7c!").m_178405_(issuesLink));
                    Style downloadLink = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, latestVersion.downloadUrl));
                    textList.addAll(Component.m_237113_((String)"\u00a77\u00a7nClick to download").m_178405_(downloadLink));
                    Minecraft minecraft = Minecraft.m_91087_();
                    LocalPlayer player = minecraft.f_91074_;
                    if (player == null) {
                        return;
                    }
                    for (Component component : textList) {
                        Minecraft.m_91087_().execute(() -> player.m_5661_(text, false));
                    }
                }
            }
            catch (Exception e) {
                Logger.warn("Failed to get latest mod version!");
                e.printStackTrace();
            }
        }).start();
    }

    private static boolean isNewerVersion(ModrinthApi.ModrinthVersion modrinthVersion) {
        if (modrinthVersion == null) {
            return false;
        }
        return Services.PLATFORM.getModVersion().compareTo(modrinthVersion.version) < 0;
    }
}

