/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.BaseWeapons;

import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface SporeArmorData {
    public static final String BASE_TAG = "agent";
    public static final String PROTECTION_TAG = "mutant_protection";
    public static final String TOUGHNESS_TAG = "mutant_toughness";
    public static final String MAX_DURABILITY = "mutant_max_durability";
    public static final String EXTRA_DURABILITY = "mutant_extra_durability";
    public static final String ENCHANTING = "mutant_enchanting";
    public static final String MUTATION = "mutation";

    default public boolean tooHurt(ItemStack stack) {
        return stack.m_41773_() < stack.m_41776_() - 10;
    }

    default public double calculateTrueDefense(ItemStack stack, double defense) {
        double value = this.getAdditionalProtection(stack) * 0.01;
        if (value > 0.0) {
            return defense + defense * value;
        }
        return defense;
    }

    default public void setAdditionalProtection(double value, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128347_(PROTECTION_TAG, value);
    }

    default public double getAdditionalProtection(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41698_(BASE_TAG);
        return tag.m_128459_(PROTECTION_TAG);
    }

    default public double calculateTrueToughness(ItemStack stack, double defense) {
        double value = this.getAdditionalProtection(stack) * 0.01;
        if (value > 0.0) {
            return defense + defense * value;
        }
        return defense;
    }

    default public void setAdditionalToughness(double value, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128347_(TOUGHNESS_TAG, value);
    }

    default public double getAdditionalToughness(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41698_(BASE_TAG);
        return tag.m_128459_(TOUGHNESS_TAG);
    }

    default public void setLuck(int value, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128347_(ENCHANTING, (double)value);
    }

    default public int getLuck(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41698_(BASE_TAG);
        return tag.m_128451_(ENCHANTING);
    }

    default public SporeArmorMutations getVariant(ItemStack stack) {
        return SporeArmorMutations.byId(this.getTypeVariant(stack) & 0xFF);
    }

    default public int getTypeVariant(ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        return tag.m_128451_(MUTATION);
    }

    default public void setVariant(SporeArmorMutations variant, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128405_(MUTATION, variant.getId() & 0xFF);
    }

    default public void healTool(ItemStack stack, int value) {
        if (stack.m_41773_() < stack.m_41776_()) {
            stack.m_41721_(stack.m_41773_() - value);
        }
        if (this.getMaxTrueAdditionalDurability(stack) > this.getAdditionalDurability(stack)) {
            this.setAdditionalDurability(this.getAdditionalDurability(stack) + value, stack);
        }
    }

    default public int getMaxTrueAdditionalDurability(ItemStack stack) {
        return (int)((double)stack.m_41776_() * ((double)this.getMaxAdditionalDurability(stack) * 0.01));
    }

    default public int getMaxAdditionalDurability(ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        return tag.m_128451_(MAX_DURABILITY);
    }

    default public void setMaxAdditionalDurability(int value, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128405_(MAX_DURABILITY, value);
    }

    default public int getAdditionalDurability(ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        return tag.m_128451_(EXTRA_DURABILITY);
    }

    default public void setAdditionalDurability(int value, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128405_(EXTRA_DURABILITY, value);
    }

    default public void hurtExtraDurability(ItemStack stack, int value, @Nullable LivingEntity living) {
        this.setAdditionalDurability(this.getAdditionalDurability(stack) - value, stack);
    }
}

