/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class ScentEntity
extends UtilityEntity {
    private static final EntityDataAccessor<Boolean> OVERCHARGED = SynchedEntityData.m_135353_(ScentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DISSIPATE = SynchedEntityData.m_135353_(ScentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SUMMON = SynchedEntityData.m_135353_(ScentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public List<String> idList = new ArrayList<String>();

    public ScentEntity(EntityType<? extends PathfinderMob> mob, Level level) {
        super(mob, level);
    }

    public boolean m_20147_() {
        return true;
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            if (this.getDissipate() == 1) {
                this.addToTheList((Entity)this);
            }
            this.setDissipate(this.getDissipate() + 1);
            if (this.getDissipate() >= (Integer)SConfig.SERVER.scent_life.get()) {
                this.m_146870_();
            }
            if (((Boolean)SConfig.SERVER.scent_summon.get()).booleanValue()) {
                this.setSummon(this.getSummon() + 1);
                if (this.getSummon() >= (Integer)SConfig.SERVER.scent_summon_cooldown.get() && !this.m_9236_().f_46443_ && (this.getOvercharged() || this.checkForNonInfected((Entity)this))) {
                    this.Summon((LivingEntity)this);
                    this.setSummon(0);
                }
            }
        }
        super.m_8119_();
    }

    boolean checkForNonInfected(Entity entity) {
        AABB boundingBox = entity.m_20191_().m_82400_(16.0);
        List entities = entity.m_9236_().m_6249_(entity, boundingBox, EntitySelector.f_20406_);
        for (Entity en : entities) {
            LivingEntity livingEntity;
            if (!(en instanceof LivingEntity) || !this.TARGET_SELECTOR.test(livingEntity = (LivingEntity)en)) continue;
            return true;
        }
        return false;
    }

    void addToTheList(Entity entity) {
        AABB boundingBox = entity.m_20191_().m_82400_(100.0);
        List entities = entity.m_9236_().m_6249_(entity, boundingBox, EntitySelector.f_20406_);
        for (Entity en : entities) {
            for (String entry : (List)SConfig.SERVER.inf_human_conv.get()) {
                String[] parts = entry.split("\\|");
                if (parts.length < 2 || !Objects.equals(en.m_20078_(), parts[0])) continue;
                this.idList.add(parts[1]);
            }
        }
    }

    public boolean getOvercharged() {
        return (Boolean)this.f_19804_.m_135370_(OVERCHARGED);
    }

    public void setOvercharged(boolean b) {
        this.f_19804_.m_135381_(OVERCHARGED, (Object)b);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("overcharged", ((Boolean)this.f_19804_.m_135370_(OVERCHARGED)).booleanValue());
        tag.m_128405_("summon", ((Integer)this.f_19804_.m_135370_(SUMMON)).intValue());
        tag.m_128405_("dissipate", ((Integer)this.f_19804_.m_135370_(DISSIPATE)).intValue());
        ListTag teamTag = new ListTag();
        for (String member : this.idList) {
            teamTag.add((Object)StringTag.m_129297_((String)member));
        }
        tag.m_128365_("entities", (Tag)teamTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(OVERCHARGED, (Object)tag.m_128471_("overcharged"));
        this.f_19804_.m_135381_(SUMMON, (Object)tag.m_128451_("summon"));
        this.f_19804_.m_135381_(DISSIPATE, (Object)tag.m_128451_("dissipate"));
        this.idList.clear();
        ListTag teamTag = tag.m_128437_("entities", 8);
        for (int l = 0; l < teamTag.size(); ++l) {
            this.idList.add(teamTag.m_128778_(l));
        }
    }

    public void setSummon(int val) {
        this.f_19804_.m_135381_(SUMMON, (Object)val);
    }

    public void setDissipate(int val) {
        this.f_19804_.m_135381_(DISSIPATE, (Object)val);
    }

    public int getSummon() {
        return (Integer)this.f_19804_.m_135370_(SUMMON);
    }

    public int getDissipate() {
        return (Integer)this.f_19804_.m_135370_(DISSIPATE);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OVERCHARGED, (Object)false);
        this.f_19804_.m_135372_(SUMMON, (Object)0);
        this.f_19804_.m_135372_(DISSIPATE, (Object)0);
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_()) {
            this.m_20184_().m_82520_(0.0, -0.01, 0.0);
        }
        if (((Boolean)SConfig.SERVER.scent_particles.get()).booleanValue()) {
            int i = Mth.m_14107_((double)this.m_20185_());
            int j = Mth.m_14107_((double)this.m_20186_());
            int k = Mth.m_14107_((double)this.m_20189_());
            Level world = this.m_9236_();
            RandomSource randomSource = this.f_19796_;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int l = 0; l < 14; ++l) {
                blockpos$mutableblockpos.m_122178_(i + Mth.m_216271_((RandomSource)randomSource, (int)-6, (int)6), j + Mth.m_216271_((RandomSource)randomSource, (int)-6, (int)6), k + Mth.m_216271_((RandomSource)randomSource, (int)-6, (int)6));
                BlockState blockstate = world.m_8055_((BlockPos)blockpos$mutableblockpos);
                if (blockstate.m_60804_((BlockGetter)world, (BlockPos)blockpos$mutableblockpos)) continue;
                world.m_7106_((ParticleOptions)Sparticles.SPORE_PARTICLE.get(), (double)blockpos$mutableblockpos.m_123341_() + randomSource.m_188500_(), (double)blockpos$mutableblockpos.m_123342_() + randomSource.m_188500_(), (double)blockpos$mutableblockpos.m_123343_() + randomSource.m_188500_(), 0.0, 0.1, 0.0);
                if (!this.getOvercharged()) continue;
                world.m_7106_((ParticleOptions)Sparticles.BLOOD_PARTICLE.get(), (double)blockpos$mutableblockpos.m_123341_() + randomSource.m_188500_(), (double)blockpos$mutableblockpos.m_123342_() + randomSource.m_188500_(), (double)blockpos$mutableblockpos.m_123343_() + randomSource.m_188500_(), 0.0, 0.1, 0.0);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public void Summon(LivingEntity entity) {
        boolean bigger;
        ServerLevelAccessor world = (ServerLevelAccessor)entity.m_9236_();
        Level level = entity.m_9236_();
        Random rand = new Random();
        int d = this.f_19796_.m_216339_(0, 3);
        int r = this.f_19796_.m_216339_(-12, 12);
        int c = this.f_19796_.m_216339_(-12, 12);
        List ev = (List)SConfig.SERVER.inf_summon.get();
        boolean bl = bigger = this.idList.size() > ev.size();
        if (world.m_46859_(new BlockPos((int)this.m_20185_() + r, (int)this.m_20186_() + d, (int)this.m_20189_() + c))) {
            for (int i = 0; i < 1; ++i) {
                int randomIndex = rand.nextInt(bigger ? this.idList.size() : ev.size());
                ResourceLocation randomElement1 = new ResourceLocation(bigger ? this.idList.get(randomIndex) : (String)ev.get(randomIndex));
                EntityType randomElement = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(randomElement1);
                Mob waveentity = (Mob)randomElement.m_20615_(level);
                assert (waveentity != null);
                waveentity.m_6034_(entity.m_20185_() + (double)r, entity.m_20186_() + 0.5 + (double)d, entity.m_20189_() + (double)c);
                waveentity.m_6518_(world, level.m_6436_(new BlockPos((int)entity.m_20185_(), (int)entity.m_20186_(), (int)entity.m_20189_())), MobSpawnType.NATURAL, null, null);
                if (this.getOvercharged()) {
                    List buffer = (List)SConfig.SERVER.scent_effects_buff.get();
                    int randomInt = this.f_19796_.m_188503_(buffer.size());
                    if (waveentity instanceof Infected) {
                        Infected infected = (Infected)waveentity;
                        int k = (Integer)SConfig.SERVER.scent_kills.get();
                        infected.setKills(this.f_19796_.m_216339_(k, k + 3));
                        infected.setEvoPoints(this.f_19796_.m_216339_(k, k + 3));
                        infected.setEvolution((Integer)SConfig.SERVER.evolution_age_human.get() / 2);
                        infected.setLinked(true);
                    }
                    ResourceLocation randomElement2 = new ResourceLocation((String)buffer.get(randomInt));
                    MobEffect randomElement3 = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(randomElement2);
                    assert (randomElement3 != null);
                    waveentity.m_7292_(new MobEffectInstance(randomElement3, 3600, 0));
                }
                level.m_7967_((Entity)waveentity);
            }
        }
    }

    public boolean m_147207_(MobEffectInstance p_182397_, @Nullable Entity p_182398_) {
        return false;
    }
}

