/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Projectile.ThrownBlockProjectile;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class InfestedConstruct
extends UtilityEntity
implements RangedAttackMob,
Enemy {
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(InfestedConstruct.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DISPENSER = SynchedEntityData.m_135353_(InfestedConstruct.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> MACHINE_HEALTH = SynchedEntityData.m_135353_(InfestedConstruct.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> METAL_RESERVE = SynchedEntityData.m_135353_(InfestedConstruct.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Double maXmachineHp = (Double)SConfig.SERVER.inf_machine_hp.get();
    public final Map<Item, Integer> metalAndValues;
    @Nullable
    private BlockPos Targetpos;
    private int attackAnimationTick;

    public InfestedConstruct(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21344_ = new WallClimberNavigation((Mob)this, this.m_9236_());
        this.m_274367_(1.0f);
        this.metalAndValues = this.getValues();
    }

    @Override
    public List<? extends String> getDropList() {
        return this.isActive() ? (List)SConfig.DATAGEN.construct_loot.get() : null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.inf_cons_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.inf_cons_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.inf_cons_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 2.0);
    }

    public boolean m_6785_(double value) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SporeSavedData data = SporeSavedData.getDataLocation(serverLevel);
            return data != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get() && value > 256.0;
        }
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        entity.f_19864_ = true;
        entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.8, 0.0));
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600, 0));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 600, 0));
        }
        return super.m_7327_(entity);
    }

    public void m_7822_(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        } else {
            super.m_7822_(value);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    private boolean canRangeAttack() {
        LivingEntity livingEntity = this.m_5448_();
        return this.isActive() && livingEntity != null && livingEntity.m_20186_() - 2.0 > this.m_20186_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTIVE, (Object)true);
        this.f_19804_.m_135372_(DISPENSER, (Object)false);
        this.f_19804_.m_135372_(METAL_RESERVE, (Object)0);
        this.f_19804_.m_135372_(MACHINE_HEALTH, (Object)Float.valueOf((float)(maXmachineHp * 1.0)));
    }

    public void setActive(boolean value) {
        this.f_19804_.m_135381_(ACTIVE, (Object)value);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void setDispenser(boolean value) {
        this.f_19804_.m_135381_(DISPENSER, (Object)value);
    }

    public boolean isDispenser() {
        return (Boolean)this.f_19804_.m_135370_(DISPENSER);
    }

    public void setMachineHealth(float value) {
        this.f_19804_.m_135381_(MACHINE_HEALTH, (Object)Float.valueOf(value));
    }

    public float getMachineHealth() {
        return ((Float)this.f_19804_.m_135370_(MACHINE_HEALTH)).floatValue();
    }

    public void setMetalReserve(int value) {
        this.f_19804_.m_135381_(METAL_RESERVE, (Object)value);
    }

    public int getMetalReserve() {
        return (Integer)this.f_19804_.m_135370_(METAL_RESERVE);
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.Targetpos;
    }

    public void setTargetPos(@Nullable BlockPos pos) {
        this.Targetpos = pos;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setActive(tag.m_128471_("active"));
        this.setMachineHealth(tag.m_128457_("machine_hp"));
        this.f_19804_.m_135381_(DISPENSER, (Object)tag.m_128471_("dispenser"));
        this.f_19804_.m_135381_(METAL_RESERVE, (Object)tag.m_128451_("metal"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("active", this.isActive());
        tag.m_128350_("machine_hp", this.getMachineHealth());
        tag.m_128379_("dispenser", ((Boolean)this.f_19804_.m_135370_(DISPENSER)).booleanValue());
        tag.m_128405_("metal", ((Integer)this.f_19804_.m_135370_(METAL_RESERVE)).intValue());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.addTargettingGoals();
        this.f_21345_.m_25352_(3, (Goal)new AOEMeleeAttackGoal(this, 1.2, false, 1.5, 2.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 6.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new SearchAroundGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public boolean m_21525_() {
        return super.m_21525_() || !this.isActive();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    private List<DamageSource> resistentSources() {
        ArrayList<DamageSource> resistentSources = new ArrayList<DamageSource>();
        resistentSources.add(this.m_9236_().m_269111_().m_269549_());
        resistentSources.add(this.m_9236_().m_269111_().m_269387_());
        resistentSources.add(this.m_9236_().m_269111_().m_269233_());
        resistentSources.add(this.m_9236_().m_269111_().m_269047_());
        return resistentSources;
    }

    public boolean m_6469_(DamageSource source, float value) {
        if (this.f_19802_ == 0) {
            float f = value = this.resistentSources().contains(source) ? value / 2.0f : value;
            if (!(this.getMachineHealth() > 0.0f)) {
                return super.m_6469_(source, value);
            }
            float damage = this.m_21161_(source, value);
            this.setMachineHealth(damage > this.getMachineHealth() ? 0.0f : this.getMachineHealth() - damage);
            this.f_19802_ = 10;
            this.f_20916_ = 10;
            this.m_6677_(source);
            return true;
        }
        return false;
    }

    public boolean hasLineOfSightBlocks(BlockPos pos) {
        BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockPos position = raytraceresult.m_82425_();
        return pos.equals((Object)position) || this.m_9236_().m_46859_(pos) || this.m_9236_().m_7702_(pos) == this.m_9236_().m_7702_(position);
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    public void m_5993_(Entity p_19953_, int p_19954_, DamageSource p_19955_) {
        super.m_5993_(p_19953_, p_19954_, p_19955_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 0));
    }

    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (effectInstance.m_19544_().m_19486_() || effectInstance.m_19544_() == Seffects.CORROSION.get()) {
            return super.m_147207_(effectInstance, entity);
        }
        return false;
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        BlockState state = this.getBlock();
        if (!this.m_9236_().f_46443_ && state != null) {
            ThrownBlockProjectile thrownBlockProjectile = new ThrownBlockProjectile(this.m_9236_(), (LivingEntity)this, Float.valueOf(10.0f), state, this.TARGET_SELECTOR);
            double dx = livingEntity.m_20185_() - this.m_20185_();
            double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_() - 1.0;
            double dz = livingEntity.m_20189_() - this.m_20189_();
            thrownBlockProjectile.m_6027_(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_());
            thrownBlockProjectile.m_6686_(dx, dy - thrownBlockProjectile.m_20186_() + Math.hypot(dx, dz) * (double)0.05f, dz, 1.0f, 6.0f);
            this.m_9236_().m_7967_((Entity)thrownBlockProjectile);
        }
    }

    public BlockState getBlock() {
        AABB aabb = this.m_20191_().m_82400_(0.2);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) < 5.0f) || !(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) >= 0.0f) || blockstate.m_60795_()) continue;
            this.m_9236_().m_46961_(blockpos, false);
            return blockstate;
        }
        return null;
    }

    public Map<Item, Integer> getValues() {
        HashMap<Item, Integer> values = new HashMap<Item, Integer>();
        for (String string : (List)SConfig.SERVER.cons_blocks.get()) {
            String[] strings = string.split("\\|");
            int value = Integer.parseInt(strings[1]);
            Item stack = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(strings[0]));
            if (stack == null || value <= 0) continue;
            values.put(stack, value);
        }
        return values;
    }

    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (this.f_19797_ % 40 == 0) {
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && this.f_19862_) {
                this.griefBlocks();
            }
            if ((double)this.getMachineHealth() < maXmachineHp && (Integer)this.f_19804_.m_135370_(METAL_RESERVE) > 0) {
                this.setMachineHealth(this.getMachineHealth() + 1.0f);
                this.f_19804_.m_135381_(METAL_RESERVE, (Object)((Integer)this.f_19804_.m_135370_(METAL_RESERVE) - 1));
            }
            if (this.m_21023_((MobEffect)Seffects.CORROSION.get())) {
                this.setMachineHealth(this.getMachineHealth() - 2.0f);
            }
        }
        if (this.f_19797_ % 200 == 0) {
            if (!this.isActive()) {
                this.callUponInfected();
            }
            this.searchBlocks();
        }
        if (this.f_19797_ % 100 == 0 && this.isDispenser() && this.isActive() && (target = this.m_5448_()) != null && this.m_142582_((Entity)target)) {
            this.performDispenserShot(target);
        }
        if (this.f_19797_ % 60 == 0 && this.canRangeAttack() && (target = this.m_5448_()) != null && this.m_142582_((Entity)target)) {
            this.m_6504_(target, 0.0f);
        }
    }

    private void griefBlocks() {
        AABB aabb = this.m_20191_().m_82377_(0.5, 0.0, 0.5).m_82386_(0.0, 1.0, 0.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!this.blockBreakingParameter(blockstate, blockpos)) continue;
            this.interactBlock(blockpos, this.m_9236_());
        }
    }

    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        float value = blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos);
        return this.f_19797_ % 20 == 0 && value > 0.0f && value <= (float)this.getBreaking();
    }

    public int getBreaking() {
        return (Integer)SConfig.SERVER.hyper_bd.get();
    }

    public boolean interactBlock(BlockPos blockPos, Level level) {
        BlockState state = level.m_8055_(blockPos);
        if (state.m_204336_(Utilities.biomass)) {
            return level.m_7731_(blockPos, ((Block)Sblocks.MEMBRANE_BLOCK.get()).m_49966_(), 3);
        }
        return level.m_46953_(blockPos, false, (Entity)this);
    }

    protected SoundEvent m_7515_() {
        return this.isActive() ? (SoundEvent)Ssounds.CONSTRUCT_AMBIENT.get() : null;
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return this.getMachineHealth() > 0.0f || !this.isActive() ? SoundEvents.f_12008_ : (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12010_;
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (dataAccessor.equals(ACTIVE)) {
            this.m_6210_();
            if (this.isActive()) {
                this.setMachineHealth((float)(maXmachineHp * 1.0));
                this.m_21153_(this.m_21233_());
            }
        }
    }

    public void searchBlocks() {
        AABB aabb = this.m_20191_().m_82377_(32.0, 4.0, 32.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState block = this.m_9236_().m_8055_(blockpos);
            if (!this.metalAndValues.containsKey(block.m_60734_().m_5456_()) || !this.hasLineOfSightBlocks(blockpos) || !(this.f_19796_.m_188501_() < 0.5f)) continue;
            this.setTargetPos(blockpos);
            break;
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isActive()) {
            return super.m_6972_(pose);
        }
        return super.m_6972_(pose).m_20390_(1.0f, 0.4f);
    }

    public void callUponInfected() {
        AABB aabb = this.m_20191_().m_82400_(8.0);
        List infected = this.m_9236_().m_6249_((Entity)this, aabb, entity -> entity instanceof Infected && !(entity instanceof Hyper));
        for (Entity entity2 : infected) {
            if (!(entity2 instanceof Infected)) continue;
            Infected infected1 = (Infected)entity2;
            infected1.setSearchPos(this.m_20097_());
            if (!(infected1.m_20280_((Entity)this) < 30.0)) continue;
            this.setActive(true);
            infected1.m_146870_();
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) break;
            ServerLevel serverLevel = (ServerLevel)level;
            double x0 = this.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
            double y0 = this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.25) * 0.15 * 5.0;
            double z0 = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            break;
        }
    }

    public boolean m_142066_() {
        return super.m_142066_() && this.isActive();
    }

    public void performDispenserShot(LivingEntity entity) {
        Arrow abstractarrow = new Arrow(this.m_9236_(), (LivingEntity)this);
        double d0 = entity.m_20185_() - this.m_20185_();
        double d1 = entity.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = entity.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_36870_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600));
        if (Math.random() < (double)0.4f) {
            abstractarrow.m_20254_(8);
        }
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11798_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        this.dropIron();
    }

    private void dropIron() {
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42416_, this.f_19796_.m_216339_(1, 5)));
        this.m_9236_().m_7967_((Entity)itemEntity);
    }

    public static class SearchAroundGoal
    extends Goal {
        private final InfestedConstruct construct;
        public int tryTicks;

        public SearchAroundGoal(InfestedConstruct construct) {
            this.construct = construct;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.construct.getTargetPos() != null && this.construct.m_5448_() == null;
        }

        protected void moveToBlock(BlockPos pos) {
            if (pos != null) {
                this.construct.f_21344_.m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 1.0);
            }
        }

        public void m_8056_() {
            this.moveToBlock(this.construct.getTargetPos());
            this.tryTicks = 0;
            super.m_8056_();
        }

        public boolean m_8045_() {
            return this.construct.m_5448_() == null;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.tryTicks;
            BlockPos pos = this.construct.getTargetPos();
            if (pos != null && this.shouldRecalculatePath()) {
                this.moveToBlock(pos);
            }
            if (pos != null && pos.m_203195_((Position)this.construct.m_20182_(), 3.5)) {
                this.assimilateMetal(pos, this.construct.m_9236_());
                this.construct.setTargetPos(null);
                this.construct.searchBlocks();
            }
        }

        public void assimilateMetal(BlockPos pos, Level level) {
            Item item = level.m_8055_(pos).m_60734_().m_5456_();
            try {
                this.construct.setMetalReserve(this.construct.getMetalReserve() + this.construct.metalAndValues.get(item));
            }
            catch (Exception exception) {
                // empty catch block
            }
            level.m_46953_(pos, false, (Entity)this.construct);
            this.construct.m_216990_(SoundEvents.f_12009_);
            if (item == Items.f_41855_) {
                this.construct.setDispenser(true);
            }
        }
    }
}

