/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Busser;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sentities.Signal;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.VigilVariants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Vigil
extends Organoid
implements TraceableEntity,
VariantKeeper {
    private static final EntityDataAccessor<Integer> TRIGGER = SynchedEntityData.m_135353_(Vigil.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WAVE_SIZE = SynchedEntityData.m_135353_(Vigil.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.m_135353_(Vigil.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Busser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int summon_counter;
    @javax.annotation.Nullable
    private Mob proto;

    public Vigil(EntityType<? extends UtilityEntity> type, Level level) {
        super(type, level);
        this.m_21530_();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.vigil_loot.get();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WAVE_SIZE, (Object)0);
        this.f_19804_.m_135372_(TIMER, (Object)0);
        this.f_19804_.m_135372_(TRIGGER, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public int getEmerge_tick() {
        return this.isStalker() ? 90 : 180;
    }

    @Override
    public int getBorrow_tick() {
        return this.isStalker() ? 100 : 200;
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.f_19804_.m_135370_(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            burrowing = -1;
            if (this.isStalker() && this.m_5448_() != null) {
                this.ReEmerge();
            } else {
                Level level;
                if (this.getVariant() == VigilVariants.TROLL && (level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.m_271686_() instanceof Player || this.m_5448_() instanceof Player) {
                        this.pickAndPlaceMessage(serverLevel, this.m_20097_().m_7494_());
                    }
                }
                this.m_146870_();
                this.TimeToLeave();
            }
        }
        this.f_19804_.m_135381_(BORROW, (Object)(burrowing + 1));
    }

    public boolean isStalker() {
        return this.getVariant() == VigilVariants.STALKER;
    }

    public int getTrigger() {
        return (Integer)this.f_19804_.m_135370_(TRIGGER);
    }

    public void setTrigger(int i) {
        this.f_19804_.m_135381_(TRIGGER, (Object)i);
    }

    public int getWaveSize() {
        return (Integer)this.f_19804_.m_135370_(WAVE_SIZE);
    }

    public void setWaveSize(int i) {
        this.f_19804_.m_135381_(WAVE_SIZE, (Object)i);
    }

    public int getTimer() {
        return (Integer)this.f_19804_.m_135370_(TIMER);
    }

    @javax.annotation.Nullable
    public void setProto(Mob entity) {
        this.proto = entity;
    }

    public boolean m_21525_() {
        return this.isBurrowing() || this.isEmerging();
    }

    @Override
    public void m_8119_() {
        if (this.m_5448_() == null && (Integer)this.f_19804_.m_135370_(TIMER) < 6000) {
            if ((Integer)this.f_19804_.m_135370_(TIMER) % 300 == 0) {
                this.setTrigger(0);
                this.setWaveSize(0);
            }
            this.f_19804_.m_135381_(TIMER, (Object)((Integer)this.f_19804_.m_135370_(TIMER) + 1));
        } else if ((Integer)this.f_19804_.m_135370_(TIMER) >= 6000) {
            this.escape();
        }
        if (this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) < 300.0 || this.getTrigger() >= 4) {
            this.setTrigger(this.getTrigger() <= 0 ? 1 : this.getTrigger());
            this.escape();
        }
        super.m_8119_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("trigger", ((Integer)this.f_19804_.m_135370_(TRIGGER)).intValue());
        tag.m_128405_("timer", ((Integer)this.f_19804_.m_135370_(TIMER)).intValue());
        tag.m_128405_("wave_size", ((Integer)this.f_19804_.m_135370_(WAVE_SIZE)).intValue());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(TRIGGER, (Object)tag.m_128451_("trigger"));
        this.f_19804_.m_135381_(TIMER, (Object)tag.m_128451_("timer"));
        this.f_19804_.m_135381_(WAVE_SIZE, (Object)tag.m_128451_("wave_size"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    public void ReEmerge() {
        this.f_19804_.m_135381_(TIMER, (Object)0);
        this.m_20984_(this.m_20185_() + (double)this.f_19796_.m_216339_(-30, 30), this.m_20186_(), this.m_20189_() + (double)this.f_19796_.m_216339_(-30, 30), false);
        this.f_19804_.m_135381_(EMERGE, (Object)-1);
        this.tickEmerging();
    }

    @Override
    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (this.isEmerging()) {
            return false;
        }
        this.escape();
        return super.m_6469_(p_21016_, p_21017_);
    }

    public void escape() {
        if (this.m_20096_()) {
            this.tickBurrowing();
        }
    }

    boolean checkForScents() {
        AABB aabb = this.m_20191_().m_82400_(16.0);
        List entities = this.m_9236_().m_45976_(ScentEntity.class, aabb);
        return entities.size() < (Integer)SConfig.SERVER.scent_cap.get();
    }

    public void TimeToLeave() {
        int i = (Integer)this.f_19804_.m_135370_(TRIGGER);
        if (i == 1) {
            this.SummonScent((Entity)this, this.m_9236_(), false);
        } else if (i == 2) {
            this.SummonScent((Entity)this, this.m_9236_(), true);
        } else if (i >= 3) {
            AABB searchbox = this.m_20191_().m_82400_((double)((Integer)SConfig.SERVER.proto_range.get()).intValue());
            List entities = this.m_9236_().m_6249_((Entity)this, searchbox, EntitySelector.f_20406_);
            for (Entity en : entities) {
                if (!(en instanceof Proto)) continue;
                Proto proto = (Proto)en;
                proto.setSignal(new Signal(true, new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_())));
                break;
            }
        }
        this.punishHivemind();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.VIGIL_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    private void SummonScent(Entity entity, Level level, boolean value) {
        if (this.checkForScents()) {
            ScentEntity scent = new ScentEntity((EntityType<? extends PathfinderMob>)((EntityType)Sentities.SCENT.get()), level);
            scent.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            scent.setOvercharged(value);
            level.m_7967_((Entity)scent);
        }
    }

    @Nullable
    public Entity m_19749_() {
        return this.proto;
    }

    public VigilVariants getVariant() {
        return VigilVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        if (i > VigilVariants.values().length || i < 0) {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)0);
        } else {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
        }
    }

    @Override
    public int amountOfMutations() {
        return VigilVariants.values().length;
    }

    public void pickAndPlaceMessage(ServerLevel serverLevel, BlockPos pos) {
        if (pos.equals((Object)BlockPos.f_121853_) || !serverLevel.m_8055_(pos).m_60795_() && !(serverLevel.m_8055_(pos).m_60734_() instanceof BushBlock)) {
            return;
        }
        String key = "spore.proto.message." + this.f_19796_.m_188503_(10);
        MutableComponent translated = Component.m_237115_((String)key);
        String[] words = translated.getString().split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 <= 15) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            lines.add(currentLine.toString());
            currentLine = new StringBuilder(word);
            if (lines.size() == 4) break;
        }
        if (lines.size() < 4 && currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        while (lines.size() < 4) {
            lines.add("");
        }
        this.placeSignWithText(serverLevel, pos, lines.toArray(new String[0]));
    }

    public void placeSignWithText(ServerLevel world, BlockPos pos, String[] lines) {
        BlockState signState = Blocks.f_50095_.m_49966_();
        world.m_46597_(pos, signState);
        BlockEntity be = world.m_7702_(pos);
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        SignText newText = sign.m_277142_();
        int v = Math.min(lines.length, 4);
        for (int i = 0; i < v; ++i) {
            String centered = this.centerLine(lines[i], 15);
            MutableComponent line = Component.m_237113_((String)centered);
            newText = newText.m_276948_(i, (Component)line, (Component)line);
        }
        sign.m_276956_(newText, true);
        sign.m_6596_();
    }

    private String centerLine(String text, int width) {
        if (text.length() >= width) {
            return text.substring(0, width);
        }
        int pad = (width - text.length()) / 2;
        return " ".repeat(pad) + text;
    }

    private void setVariant(VigilVariants variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void SummonInfected() {
        Level level;
        int l = this.getTrigger();
        List summons = l <= 1 ? (List)SConfig.SERVER.vigil_base_wave.get() : (l == 2 ? (List)SConfig.SERVER.vigil_middle_wave.get() : (List)SConfig.SERVER.vigil_max_wave.get());
        this.awardHivemind();
        LivingEntity target = this.m_5448_();
        if (target != null && this.getTrigger() > 0 && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor world = (ServerLevelAccessor)level;
            RandomSource rand = RandomSource.m_216327_();
            int randomIndex = rand.m_188503_(summons.size());
            ResourceLocation randomElement1 = new ResourceLocation((String)summons.get(randomIndex));
            EntityType randomElement = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(randomElement1);
            Mob waveentity = (Mob)randomElement.m_20615_(this.m_9236_());
            assert (waveentity != null);
            waveentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            waveentity.m_6518_(world, this.m_9236_().m_6436_(new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_())), MobSpawnType.NATURAL, null, null);
            if (waveentity.m_5448_() == null && target.m_6084_() && !target.m_20147_()) {
                waveentity.m_6710_(target);
            }
            this.m_9236_().m_7967_((Entity)waveentity);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.vigil_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.vigil_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.getWaveSize() > 0 && this.summon_counter <= 20) {
            ++this.summon_counter;
        } else if (this.getWaveSize() > 0 && this.summon_counter >= 20) {
            this.summon_counter = 0;
            this.SummonInfected();
            this.setWaveSize(this.getWaveSize() - 1);
        }
        if (this.getWaveSize() > 0) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            RandomSource randomsource = this.m_217043_();
            for (int l = 0; l < 3; ++l) {
                int i = randomsource.m_216339_(-3, 3);
                int i1 = randomsource.m_216339_(-3, 3);
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)Sparticles.SPORE_PARTICLE.get()), x + (double)i, y + this.f_19796_.m_188500_(), z + (double)i1, 1, 0.0, 0.3, 0.0, (double)0.15f);
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
        }
        return super.m_6071_(player, interactionHand);
    }

    protected void m_8099_() {
        this.addTargettingGoals();
        this.f_21345_.m_25352_(2, (Goal)new WatchTargetGoat(this));
        this.f_21345_.m_25352_(2, (Goal)new WatcherMobSummon(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    public int getNumberOfParticles() {
        return 4;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isStalker() ? super.m_6972_(pose).m_20388_(1.2f) : super.m_6972_(pose);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @javax.annotation.Nullable SpawnGroupData p_146749_, @javax.annotation.Nullable CompoundTag p_146750_) {
        VigilVariants variant = (VigilVariants)((Object)Util.m_214670_((Object[])VigilVariants.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }

    private static class WatchTargetGoat
    extends Goal {
        private final Vigil vigil;

        public WatchTargetGoat(Vigil vigil1) {
            this.vigil = vigil1;
        }

        public boolean m_8036_() {
            return this.vigil.m_5448_() != null;
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity target = this.vigil.m_5448_();
            if (target != null && this.vigil.m_142582_((Entity)target)) {
                this.vigil.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                if (target instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)target;
                    if (!player.m_21023_((MobEffect)Seffects.UNEASY.get())) {
                        player.m_7292_(new MobEffectInstance((MobEffect)Seffects.UNEASY.get(), 6000, 0));
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"vigil.message"), true);
                }
            }
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.vigil.m_5448_() != null && this.vigil.proto != null && this.vigil.proto.m_5448_() == null) {
                this.vigil.proto.m_6710_(this.vigil.m_5448_());
            }
        }
    }

    private static class WatcherMobSummon
    extends Goal {
        private final Vigil vigil;

        private WatcherMobSummon(Vigil vigil) {
            this.vigil = vigil;
        }

        public boolean m_8036_() {
            if (this.vigil.getWaveSize() > 0) {
                return false;
            }
            return this.vigil.f_19796_.m_188503_(100) == 0 && this.vigil.m_5448_() != null && this.checkForInfected((Entity)this.vigil.m_5448_());
        }

        boolean checkForInfected(Entity entity) {
            AABB boundingBox = entity.m_20191_().m_82400_(16.0);
            List entities = entity.m_9236_().m_6249_(entity, boundingBox, EntitySelector.f_20406_);
            for (Entity en : entities) {
                if (!(en instanceof Infected)) continue;
                return false;
            }
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.vigil.m_5448_() != null && this.vigil.getWaveSize() <= 0) {
                LivingEntity target = this.vigil.m_5448_();
                int l = (Integer)SConfig.SERVER.vigil_wave_size.get();
                int e = target.m_21233_() > (float)(l * 5) ? l : (int)(target.m_21233_() / 5.0f) + target.m_21230_() / 4;
                this.vigil.setWaveSize(e);
                this.vigil.setTrigger(this.vigil.getTrigger() + 1);
            }
        }
    }
}

