/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.ArmedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.Utility.Illusion;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.DelusionerVariants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Delusionare
extends Organoid
implements VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Delusionare.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPELL_TIME = SynchedEntityData.m_135353_(Delusionare.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPELL_ID = SynchedEntityData.m_135353_(Delusionare.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final List<Enchantment> protectionEnchants = List.of(Enchantments.f_44965_, Enchantments.f_44969_, Enchantments.f_44968_, Enchantments.f_44966_);
    private static final List<Enchantment> speed = List.of(Enchantments.f_44974_, Enchantments.f_44967_, Enchantments.f_44973_);

    public Delusionare(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public int getEmerge_tick() {
        return 100;
    }

    @Override
    public int getBorrow_tick() {
        return 100;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("spell_timer", ((Integer)this.f_19804_.m_135370_(SPELL_TIME)).intValue());
        tag.m_128405_("spell_id", ((Integer)this.f_19804_.m_135370_(SPELL_ID)).intValue());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(SPELL_TIME, (Object)tag.m_128451_("spell_timer"));
        this.f_19804_.m_135381_(SPELL_ID, (Object)tag.m_128451_("spell_id"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_TIME, (Object)0);
        this.f_19804_.m_135372_(SPELL_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public int getSpellById() {
        return (Integer)this.f_19804_.m_135370_(SPELL_ID);
    }

    public boolean isCasting() {
        return (Integer)this.f_19804_.m_135370_(SPELL_TIME) > 0;
    }

    public void setSpellTime(int value) {
        this.f_19804_.m_135381_(SPELL_TIME, (Object)value);
    }

    public void setSpellId(int value) {
        this.f_19804_.m_135381_(SPELL_ID, (Object)value);
    }

    protected void tickSpell() {
        this.f_19804_.m_135381_(SPELL_TIME, (Object)((Integer)this.f_19804_.m_135370_(SPELL_TIME) + 1));
        if ((Integer)this.f_19804_.m_135370_(SPELL_TIME) == 40) {
            this.m_216990_((SoundEvent)Ssounds.DELUSIONER_CASTING.get());
        }
        if ((Integer)this.f_19804_.m_135370_(SPELL_TIME) > 80) {
            this.castSpell(this.getSpellById());
            this.f_19804_.m_135381_(SPELL_TIME, (Object)0);
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.delusioner_loot.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if ((Integer)this.f_19804_.m_135370_(SPELL_TIME) > 0) {
            this.tickSpell();
        }
        if (this.f_19797_ % 1200 == 0 && this.m_5448_() == null) {
            this.tickBurrowing();
        }
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.f_19804_.m_135370_(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            this.m_146870_();
            burrowing = -1;
        }
        this.f_19804_.m_135381_(BORROW, (Object)(burrowing + 1));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.delusioner_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.delusioner_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.addTargettingGoals();
        this.f_21345_.m_25352_(4, (Goal)new CastMagicGoal(this));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.DELUSIONER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    public void castSpell(int value) {
        LivingEntity entity = this.m_5448_();
        if (entity == null) {
            return;
        }
        if (this.getVariant() == DelusionerVariants.DEFAULT) {
            int i;
            if (value == Spells.SUMMON_ILLUSION.getId()) {
                for (i = 0; i < this.f_19796_.m_216339_(2, 5); ++i) {
                    Illusion illusion = new Illusion((EntityType<? extends PathfinderMob>)((EntityType)Sentities.ILLUSION.get()), this.m_9236_());
                    illusion.setSeeAble(true);
                    illusion.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        illusion.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
                    }
                    illusion.m_6710_(entity);
                    this.m_9236_().m_7967_((Entity)illusion);
                }
            }
            if (value == Spells.CAST_ARROWS.getId() && this.m_142582_((Entity)entity)) {
                for (i = 0; i < this.f_19796_.m_216339_(3, 7); ++i) {
                    int randomX = this.f_19796_.m_216339_(-4, 4);
                    int randomZ = this.f_19796_.m_216339_(-4, 4);
                    Arrow arrow = new Arrow(EntityType.f_20548_, this.m_9236_());
                    arrow.m_6027_(entity.m_20185_() + (double)randomX, entity.m_20186_() + 3.0, entity.m_20189_() + (double)randomZ);
                    arrow.m_5602_((Entity)this);
                    if (Math.random() < 0.3) {
                        arrow.m_20254_(4);
                    }
                    double d0 = entity.m_20185_() - arrow.m_20185_();
                    double d1 = entity.m_20227_(0.3333333333333333) - arrow.m_20186_();
                    double d2 = entity.m_20189_() - arrow.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    arrow.m_36870_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600));
                    arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
                    this.m_9236_().m_7967_((Entity)arrow);
                }
            }
            if (value == Spells.CAST_INVISIBILITY.getId()) {
                AABB aabb = this.m_20191_().m_82400_(32.0);
                List entities = this.m_9236_().m_45933_((Entity)this, aabb);
                for (Entity entity1 : entities) {
                    if (!(entity1 instanceof Infected)) continue;
                    Infected infected = (Infected)entity1;
                    infected.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 600));
                }
            }
            if (value == Spells.CAST_TELEPORTATION.getId()) {
                AABB aabb = this.m_20191_().m_82400_(32.0);
                List entities = this.m_9236_().m_45933_((Entity)this, aabb);
                for (Entity entity1 : entities) {
                    double randomX = entity.m_20185_() + (double)this.f_19796_.m_216339_(-4, 4);
                    double randomZ = entity.m_20189_() + (double)this.f_19796_.m_216339_(-4, 4);
                    if (!(entity1 instanceof Infected)) continue;
                    Infected infected = (Infected)entity1;
                    infected.m_20984_(randomX, entity.m_20186_(), randomZ, true);
                    infected.m_216990_(SoundEvents.f_11852_);
                }
            }
        } else {
            LivingEntity living;
            if (value == Spells.CAST_FIREBALL.getId()) {
                int amount = this.f_19796_.m_216339_(1, 4);
                for (int i = 0; i < amount; ++i) {
                    Vec3 look = this.m_20154_();
                    Vec3 spawnPos = this.m_20182_().m_82549_(look.m_82490_(0.5)).m_82520_(0.0, 1.2, 0.0);
                    SmallFireball fireball = new SmallFireball(this.m_9236_(), (LivingEntity)this, 0.0, 0.0, 0.0);
                    fireball.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
                    double dx = entity.m_20185_() - spawnPos.f_82479_;
                    double dy = entity.m_20227_(0.33) - spawnPos.f_82480_;
                    double dz = entity.m_20189_() - spawnPos.f_82481_;
                    float accuracy = 14 - this.m_9236_().m_46791_().m_19028_() * 4;
                    fireball.m_6686_(dx += this.f_19796_.m_188583_() * 0.15, dy += this.f_19796_.m_188583_() * 0.15, dz += this.f_19796_.m_188583_() * 0.15, 1.6f, accuracy);
                    this.m_9236_().m_7967_((Entity)fireball);
                }
            }
            if (value == Spells.CAST_LIGHTING.getId()) {
                if (!this.m_142582_((Entity)entity)) {
                    return;
                }
                LightningBolt bolt = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                AABB aabb = entity.m_20191_().m_82400_(8.0);
                List entities = this.m_9236_().m_6249_((Entity)entity, aabb, e -> {
                    PowerableMob powerableMob;
                    return e instanceof PowerableMob && !(powerableMob = (PowerableMob)e).m_7090_();
                });
                if (entities.isEmpty()) {
                    double randomX = (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 4.0;
                    double randomZ = (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 4.0;
                    Vec3 vec3 = entity.m_20182_().m_82520_(randomX, 0.0, randomZ);
                    bolt.m_20219_(vec3);
                } else {
                    Entity powerMob = (Entity)entities.get(this.f_19796_.m_188503_(entities.size()));
                    bolt.m_20219_(powerMob.m_20182_());
                }
                this.m_9236_().m_7967_((Entity)bolt);
            }
            if (value == Spells.CAST_PROTECTION.getId()) {
                AABB aabb = this.m_20191_().m_82400_(8.0);
                List entities = this.m_9236_().m_45933_((Entity)this, aabb);
                for (Entity mob : entities) {
                    if (!(mob instanceof LivingEntity) || !((living = (LivingEntity)mob) instanceof Infected)) continue;
                    if (living instanceof ArmedInfected) {
                        for (EquipmentSlot slot : EquipmentSlot.values()) {
                            Enchantment enchantment = protectionEnchants.get(this.f_19796_.m_188503_(protectionEnchants.size()));
                            ItemStack stack = living.m_6844_(slot);
                            if (!(stack.m_41720_() instanceof ArmorItem)) continue;
                            Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
                            enchants.put(enchantment, enchantment.m_6586_());
                            EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)stack);
                        }
                        continue;
                    }
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 12000, this.f_19796_.m_216339_(0, 2), false, false, false));
                }
            }
            if (value == Spells.CAST_ENDURANCE.getId()) {
                AABB aabb = this.m_20191_().m_82400_(8.0);
                List entities = this.m_9236_().m_45933_((Entity)this, aabb);
                for (Entity mob : entities) {
                    if (!(mob instanceof LivingEntity) || !((living = (LivingEntity)mob) instanceof Infected)) continue;
                    if (living instanceof ArmedInfected) {
                        Enchantment enchantment = speed.get(this.f_19796_.m_188503_(speed.size()));
                        ItemStack stack = living.m_6844_(EquipmentSlot.FEET);
                        if (!(stack.m_41720_() instanceof ArmorItem)) continue;
                        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
                        enchants.put(enchantment, enchantment.m_6586_());
                        EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)stack);
                        continue;
                    }
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 6000, this.f_19796_.m_216339_(0, 3), false, false, false));
                }
            }
        }
        this.awardHivemind();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_ && this.isCasting()) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (this.isEmerging()) {
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33282_, DifficultyInstance p_33283_, MobSpawnType p_33284_, @Nullable SpawnGroupData p_33285_, @Nullable CompoundTag p_33286_) {
        DelusionerVariants variant = (DelusionerVariants)((Object)Util.m_214670_((Object[])DelusionerVariants.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(p_33282_, p_33283_, p_33284_, p_33285_, p_33286_);
    }

    public DelusionerVariants getVariant() {
        return DelusionerVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(i > DelusionerVariants.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return DelusionerVariants.values().length;
    }

    private void setVariant(DelusionerVariants variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }

    public static class CastMagicGoal
    extends Goal {
        Delusionare delusionare;

        public CastMagicGoal(Delusionare delusionare) {
            this.delusionare = delusionare;
        }

        public boolean m_8036_() {
            if (this.delusionare.isCasting()) {
                return false;
            }
            return this.delusionare.m_5448_() != null;
        }

        private boolean hasAlliesAround() {
            AABB aabb = this.delusionare.m_20191_().m_82400_(8.0);
            List possible_allies = this.delusionare.m_9236_().m_45933_((Entity)this.delusionare, aabb);
            ArrayList<Infected> allies = new ArrayList<Infected>();
            for (Entity entity : possible_allies) {
                if (!(entity instanceof Infected)) continue;
                Infected infected = (Infected)entity;
                allies.add(infected);
            }
            return allies.size() > 2;
        }

        private boolean isFar() {
            LivingEntity entity = this.delusionare.m_5448_();
            if (entity == null) {
                return false;
            }
            return this.delusionare.m_20280_((Entity)entity) > 140.0;
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.hasAlliesAround() && this.isFar()) {
                this.delusionare.setSpellId(3);
            }
            if (this.hasAlliesAround() && !this.isFar()) {
                this.delusionare.setSpellId(2);
            }
            if (!this.hasAlliesAround() && this.isFar()) {
                this.delusionare.setSpellId(1);
            }
            if (!this.hasAlliesAround() && !this.isFar()) {
                this.delusionare.setSpellId(0);
            }
            this.delusionare.setSpellTime(1);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static enum Spells {
        SUMMON_ILLUSION(0),
        CAST_ARROWS(1),
        CAST_INVISIBILITY(2),
        CAST_TELEPORTATION(3),
        CAST_FIREBALL(0),
        CAST_LIGHTING(1),
        CAST_PROTECTION(2),
        CAST_ENDURANCE(3);

        private final int id;

        private Spells(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

