/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Damage.SdamageTypes;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.PullGoal;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.SlasherVariants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class Slasher
extends EvolvedInfected
implements ArmorPersentageBypass,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Slasher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Slasher(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.sla_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.sla_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.sla_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22282_, 0.0);
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (this.getVariant() == SlasherVariants.PIERCER) {
            return SdamageTypes.slasher_piercing_damage(entity);
        }
        if (Math.random() < 0.3) {
            return SdamageTypes.slasher_damage((LivingEntity)this);
        }
        return super.getCustomDamage(entity);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_slasher_loot.get();
    }

    public boolean m_213824_() {
        if (this.getVariant() == SlasherVariants.PIERCER) {
            return true;
        }
        return super.m_213824_();
    }

    public double getRanges() {
        return this.getVariant() == SlasherVariants.GRABBER ? 1.5 : 1.0;
    }

    public boolean pull() {
        if (this.getVariant() == SlasherVariants.PIERCER || this.getVariant() == SlasherVariants.SMASHER) {
            return false;
        }
        LivingEntity living = this.m_5448_();
        return living != null && this.m_20280_((Entity)living) < 32.0 * this.getRanges() && this.m_20280_((Entity)living) > 16.0 * this.getRanges() && this.m_142582_((Entity)living);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new AOEMeleeAttackGoal((PathfinderMob)this, 1.2, true, 1.2, 3.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.f_21345_.m_25352_(1, (Goal)new PullGoal((Mob)this, 32.0, 16.0){

            @Override
            public boolean m_8036_() {
                return Slasher.this.pull();
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                this.mob.m_216990_((SoundEvent)Ssounds.SLASHER_PULL.get());
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    public boolean m_7327_(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (this.getVariant() == SlasherVariants.PIERCER && !player.m_21254_()) {
                player.m_150109_().m_150072_(SdamageTypes.slasher_piercing_damage((LivingEntity)this), 35.0f, Inventory.f_150068_);
            }
        }
        if (this.getVariant() == SlasherVariants.SMASHER && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            livingEntity.f_19864_ = true;
            livingEntity.m_147240_(4.0, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
        }
        if (this.getVariant() == SlasherVariants.GRABBER && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            if (!this.m_9236_().f_46443_ && Math.random() < 0.15) {
                if (Math.random() < 0.5) {
                    this.dropItems(livingEntity, InteractionHand.MAIN_HAND, livingEntity.m_20097_());
                } else {
                    this.dropItems(livingEntity, InteractionHand.OFF_HAND, livingEntity.m_20097_());
                }
            }
        }
        this.m_216990_((SoundEvent)Ssounds.SLASHER_STAB.get());
        return super.m_7327_(entity);
    }

    private void dropItems(LivingEntity living, InteractionHand hand, BlockPos pos) {
        ItemStack stack = living.m_21120_(hand);
        if (stack == ItemStack.f_41583_) {
            return;
        }
        ItemEntity entity = new ItemEntity(this.m_9236_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
        this.m_9236_().m_7967_((Entity)entity);
        living.m_21008_(hand, ItemStack.f_41583_);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.INF_VILLAGER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_VILLAGER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        SlasherVariants variant = (SlasherVariants)((Object)Util.m_214670_((Object[])SlasherVariants.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public SlasherVariants getVariant() {
        return SlasherVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        if (i > SlasherVariants.values().length || i < 0) {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)0);
        } else {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
        }
    }

    @Override
    public int amountOfMutations() {
        return SlasherVariants.values().length;
    }

    private void setVariant(SlasherVariants variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public float amountOfDamage(float value) {
        return this.getVariant() == SlasherVariants.PIERCER ? (float)((Double)SConfig.SERVER.sla_damage.get() * (Double)SConfig.SERVER.global_damage.get() / 2.0) : 0.0f;
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }
}

