/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Damage.SdamageTypes;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.HurtTargetGoal;
import com.Harbinger.Spore.Sentities.AI.HybridPathNavigation;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.NaiadVariants;
import com.Harbinger.Spore.Sentities.WaterInfected;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Naiad
extends EvolvedInfected
implements WaterInfected,
VariantKeeper {
    public static final EntityDataAccessor<BlockPos> TERRITORY = SynchedEntityData.m_135353_(Naiad.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Naiad.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TRIDENT_CHARGE = SynchedEntityData.m_135353_(Naiad.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHARGE_TICKS = SynchedEntityData.m_135353_(Naiad.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int aggroTicks;
    private Vec3 chargeTarget;

    public Naiad(EntityType<? extends EvolvedInfected> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_21342_ = new NaiadSwimControl((Mob)this);
        this.f_21344_ = new HybridPathNavigation((Mob)this, this.m_9236_());
        this.m_274367_(1.0f);
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(1, (Goal)new NaiadChargeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BreakBoatsGoal(this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.0, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 5.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FindWaterTerritoryGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            @Nullable
            protected Vec3 m_7037_() {
                return Utilities.generatePositionAway(this.f_25725_.m_20182_(), 16.0);
            }
        });
    }

    public boolean m_20068_() {
        return this.m_20069_();
    }

    @Override
    protected void addTargettingGoals() {
        this.f_21345_.m_25352_(2, (Goal)new HurtTargetGoal((PathfinderMob)this, livingEntity -> this.TARGET_SELECTOR.test(livingEntity), Infected.class).setAlertOthers(Infected.class));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, true, livingEntity -> livingEntity instanceof Player || ((List)SConfig.SERVER.whitelist.get()).contains(livingEntity.m_20078_())){

            protected AABB m_7255_(double targetDistance) {
                return this.f_26135_.m_20191_().m_82400_(targetDistance);
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, true, livingEntity -> (Boolean)SConfig.SERVER.at_mob.get() != false && this.TARGET_SELECTOR.test(livingEntity)){

            protected AABB m_7255_(double targetDistance) {
                return this.f_26135_.m_20191_().m_82400_(targetDistance);
            }
        });
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TERRITORY, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(TRIDENT_CHARGE, (Object)0);
        this.f_19804_.m_135372_(CHARGE_TICKS, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("TerritoryX", ((BlockPos)this.f_19804_.m_135370_(TERRITORY)).m_123341_());
        tag.m_128405_("TerritoryY", ((BlockPos)this.f_19804_.m_135370_(TERRITORY)).m_123342_());
        tag.m_128405_("TerritoryZ", ((BlockPos)this.f_19804_.m_135370_(TERRITORY)).m_123343_());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        int tX = tag.m_128451_("TerritoryX");
        int tY = tag.m_128451_("TerritoryY");
        int tZ = tag.m_128451_("TerritoryZ");
        this.f_19804_.m_135381_(TERRITORY, (Object)new BlockPos(tX, tY, tZ));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    public BlockPos getTerritory() {
        return (BlockPos)this.f_19804_.m_135370_(TERRITORY);
    }

    public void setTerritory(BlockPos pos) {
        this.f_19804_.m_135381_(TERRITORY, (Object)pos);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Override
    public void m_7023_(Vec3 input) {
        if (this.isCharging()) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            return;
        }
        if (this.m_21515_() && this.isInFluidType()) {
            this.m_19920_(0.1f, input);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(this.getVariant() == NaiadVariants.TRITON ? 0.75 : 0.85));
        } else {
            super.m_7023_(input);
        }
    }

    public int getTridentCharge() {
        return (Integer)this.f_19804_.m_135370_(TRIDENT_CHARGE);
    }

    public void setTridentCharge(int value) {
        this.f_19804_.m_135381_(TRIDENT_CHARGE, (Object)value);
    }

    public void tickCharge() {
        this.f_19804_.m_135381_(TRIDENT_CHARGE, (Object)((Integer)this.f_19804_.m_135370_(TRIDENT_CHARGE) + 1));
    }

    public boolean isCharging() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_TICKS) > 0;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.naiad_loot.get();
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.3) {
            return SdamageTypes.knight_damage((LivingEntity)this);
        }
        return super.getCustomDamage(entity);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.naiad_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.naiad_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.naiad_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 48.0);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DATA_ID_TYPE_VARIANT.equals(dataAccessor)) {
            this.updateAttributes();
        }
        super.m_7350_(dataAccessor);
    }

    private void updateAttributes() {
        double val = this.getVariant() == NaiadVariants.TRITON ? 1.2 : 1.0;
        double health = (Double)SConfig.SERVER.naiad_hp.get() * val * (Double)SConfig.SERVER.global_health.get();
        double armor = (Double)SConfig.SERVER.naiad_armor.get() * val * (Double)SConfig.SERVER.global_armor.get();
        AttributeInstance healthAttr = this.m_21051_(Attributes.f_22276_);
        AttributeInstance armorAttr = this.m_21051_(Attributes.f_22284_);
        if (healthAttr != null) {
            healthAttr.m_22100_(health);
        }
        if (armorAttr != null) {
            armorAttr.m_22100_(armor);
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (entity.isInFluidType()) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_147207_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600, 0), (Entity)this);
                living.m_7292_(new MobEffectInstance((MobEffect)Seffects.MARKER.get(), 200, 1));
            }
            entity.m_20256_(this.m_20184_().m_82520_(0.0, -1.0, 0.0));
        }
        return super.m_7327_(entity);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.DROWNED_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_11875_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        NaiadVariants variant = (NaiadVariants)((Object)Util.m_214670_((Object[])NaiadVariants.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(serverLevelAccessor, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public NaiadVariants getVariant() {
        return NaiadVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(i > NaiadVariants.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return NaiadVariants.values().length;
    }

    private void setVariant(NaiadVariants variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }

    @Override
    public boolean m_142582_(Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_20069_() && living.m_21223_() < living.m_21233_()) {
            return true;
        }
        AttributeInstance instance = this.m_21051_(Attributes.f_22277_);
        if (instance != null) {
            double value = instance.m_22135_() / 2.0;
            if ((double)entity.m_20270_((Entity)this) > value) {
                return false;
            }
        }
        return super.m_142582_(entity);
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.aggroTicks = 300;
        } else if (this.aggroTicks > 0) {
            --this.aggroTicks;
        }
        if (!this.isCharging() && this.getTridentCharge() < 200 && this.getVariant() == NaiadVariants.TRITON) {
            this.tickCharge();
        }
        if (this.m_20069_()) {
            Vec3 vec3;
            if (this.isCharging() && this.chargeTarget != null) {
                this.performChargeMovement();
            }
            Vec3 vec32 = vec3 = target == null ? this.m_20184_() : target.m_20182_();
            if (vec3.m_165925_() > (double)2.5E-7f) {
                double dx = vec3.f_82479_;
                double dy = vec3.f_82480_;
                double dz = vec3.f_82481_;
                double horizontal = Math.sqrt(dx * dx + dz * dz);
                float yaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                float pitch = (float)(Mth.m_14136_((double)dy, (double)horizontal) * 57.29577951308232);
                this.m_146922_(yaw);
                this.m_146926_(pitch);
                this.f_20883_ = Naiad.lerpRotation(this.f_19859_, this.m_146908_());
            }
        }
    }

    protected static float lerpRotation(float currentRotation, float targetRotation) {
        while (targetRotation - currentRotation < -180.0f) {
            currentRotation -= 360.0f;
        }
        while (targetRotation - currentRotation >= 180.0f) {
            currentRotation += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)currentRotation, (float)targetRotation);
    }

    private void performChargeMovement() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.chargeTarget == null || !this.isCharging()) {
            this.stopCharge();
            return;
        }
        Vec3 currentPos = this.m_20182_();
        Vec3 direction = this.chargeTarget.m_82546_(currentPos);
        if (direction.m_82556_() < 1.0E-7) {
            this.stopCharge();
            return;
        }
        direction = direction.m_82541_();
        Vec3 currentMotion = this.m_20184_();
        Vec3 boost = direction.m_82490_(1.5).m_82549_(currentMotion.m_82490_(0.25));
        this.m_20256_(boost);
        if (this.f_19797_ % 2 == 0) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 0.3, 0.3, 0.3, 0.02);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123772_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.01);
        }
        List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(1.5));
        for (Entity entity : entities) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || !Utilities.TARGET_SELECTOR.Test(living = (LivingEntity)entity)) continue;
            float damage = (float)this.m_21133_(Attributes.f_22281_) + 4.0f;
            entity.m_6469_(this.m_9236_().m_269111_().m_269525_((Entity)this, (Entity)this), damage);
            entity.m_20256_(direction.m_82490_(1.5));
        }
        int t = (Integer)this.f_19804_.m_135370_(CHARGE_TICKS) - 1;
        this.f_19804_.m_135381_(CHARGE_TICKS, (Object)t);
        if (t <= 0) {
            this.stopCharge();
        }
    }

    public void startCharge() {
        LivingEntity target = this.m_5448_();
        if (target != null && this.m_20069_()) {
            this.f_19804_.m_135381_(CHARGE_TICKS, (Object)40);
            this.chargeTarget = target.m_20182_();
            this.m_5496_(SoundEvents.f_12519_, 1.0f, 1.0f);
            Vec3 direction = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
            this.m_20256_(direction.m_82490_(1.2));
            this.setTridentCharge(0);
        }
    }

    public void stopCharge() {
        this.f_19804_.m_135381_(CHARGE_TICKS, (Object)0);
        this.chargeTarget = null;
        Vec3 reduced = this.m_20184_().m_82490_(0.3);
        this.m_20256_(reduced);
    }

    private static class NaiadSwimControl
    extends MoveControl {
        public NaiadSwimControl(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (!this.f_24974_.m_20069_()) {
                super.m_8126_();
                return;
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                double dx = this.f_24975_ - this.f_24974_.m_20185_();
                double dy = this.f_24976_ - this.f_24974_.m_20186_();
                double dz = this.f_24977_ - this.f_24974_.m_20189_();
                float targetYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 180.0 / Math.PI) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), -targetYaw, 10.0f));
                double speed = this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_);
                this.f_24974_.m_21564_((float)speed);
                if (Math.abs(dy) > 1.0E-4) {
                    this.f_24974_.m_21567_(dy > 0.0 ? (float)speed : (float)(-speed));
                }
            }
        }
    }

    private static class NaiadChargeGoal
    extends Goal {
        private final Naiad naiad;
        private int cooldown;

        private NaiadChargeGoal(Naiad naiad) {
            this.naiad = naiad;
            this.cooldown = 0;
        }

        public boolean m_8036_() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            LivingEntity target = this.naiad.m_5448_();
            return this.naiad.getVariant() == NaiadVariants.TRITON && this.naiad.getTridentCharge() >= 200 && target != null && target.m_6084_() && this.naiad.m_20069_() && this.naiad.m_20280_((Entity)target) > 4.0 && this.naiad.m_20280_((Entity)target) < 256.0 && this.naiad.m_142582_((Entity)target);
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.naiad.startCharge();
            this.cooldown = 100;
        }

        public boolean m_183429_() {
            return false;
        }
    }

    public static class BreakBoatsGoal
    extends Goal {
        private final Naiad naiad;
        private Boat targetBoat;
        private int breakTime;
        private final double speedModifier;

        public BreakBoatsGoal(Naiad naiad, double speedModifier) {
            this.naiad = naiad;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            List boats = this.naiad.m_9236_().m_6443_(Boat.class, this.naiad.m_20191_().m_82377_(16.0, 32.0, 16.0), boat -> boat != null && !boat.m_213877_());
            if (boats.isEmpty()) {
                return false;
            }
            Boat closestBoat = null;
            double closestDistance = Double.MAX_VALUE;
            for (Boat boat2 : boats) {
                double distance = this.naiad.m_20280_((Entity)boat2);
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closestBoat = boat2;
            }
            if (closestBoat != null) {
                this.targetBoat = closestBoat;
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.breakTime = 0;
            if (this.targetBoat != null && this.naiad.f_19797_ % 20 == 0) {
                this.naiad.m_21573_().m_5624_((Entity)this.targetBoat, this.speedModifier);
            }
        }

        public boolean m_8045_() {
            return this.targetBoat != null && !this.targetBoat.m_213877_() && this.naiad.m_20280_((Entity)this.targetBoat) <= 256.0;
        }

        public void m_8037_() {
            if (this.targetBoat == null || this.targetBoat.m_213877_()) {
                return;
            }
            if (this.naiad.isEyeInFluidType(this.naiad.getEyeInFluidType())) {
                Vec3 vec3 = this.naiad.m_20184_();
                Vec3 vec31 = new Vec3(this.targetBoat.m_20185_() - this.naiad.m_20185_(), this.targetBoat.m_20186_() - this.naiad.m_20186_(), this.targetBoat.m_20189_() - this.naiad.m_20189_());
                if (vec31.m_82556_() > 1.0E-7) {
                    vec31 = vec31.m_82541_().m_82490_(0.25).m_82549_(vec3.m_82490_(0.01));
                }
                this.naiad.m_20334_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
            }
            this.naiad.m_21563_().m_24960_((Entity)this.targetBoat, 30.0f, 30.0f);
            double distance = this.naiad.m_20280_((Entity)this.targetBoat);
            if (this.naiad.f_19797_ % 20 == 0) {
                this.naiad.m_21573_().m_5624_((Entity)this.targetBoat, this.speedModifier);
            }
            if (distance < 9.0) {
                this.naiad.m_21563_().m_24960_((Entity)this.targetBoat, 30.0f, 30.0f);
                ++this.breakTime;
                if (this.breakTime >= 20) {
                    this.breakBoat();
                }
            }
        }

        public void m_8041_() {
            this.targetBoat = null;
            this.breakTime = 0;
            this.naiad.m_21573_().m_26573_();
        }

        private void breakBoat() {
            if (this.targetBoat != null && !this.targetBoat.m_213877_()) {
                Level level = this.naiad.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.targetBoat.m_20185_(), this.targetBoat.m_20186_() + 0.5, this.targetBoat.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
                    serverLevel.m_5594_(null, this.targetBoat.m_20183_(), SoundEvents.f_12630_, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                if (!this.targetBoat.m_8077_() && this.naiad.m_217043_().m_188501_() < 0.8f) {
                    this.targetBoat.m_19983_(new ItemStack((ItemLike)Items.f_42398_));
                }
                this.targetBoat.m_146870_();
                this.m_8041_();
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class FindWaterTerritoryGoal
    extends Goal {
        private final Naiad naiad;
        private BlockPos targetPos;
        public int tryTicks;

        public FindWaterTerritoryGoal(Naiad naiad) {
            this.naiad = naiad;
        }

        public boolean m_8036_() {
            if (this.naiad.aggroTicks > 0 || this.naiad.m_5448_() != null) {
                return false;
            }
            BlockPos territory = this.naiad.getTerritory();
            return territory.equals((Object)BlockPos.f_121853_) || territory.m_203193_((Position)this.naiad.m_20182_()) > 400.0;
        }

        public void m_8056_() {
            Level level = this.naiad.m_9236_();
            BlockPos currentTerritory = this.naiad.getTerritory();
            this.tryTicks = 0;
            if (currentTerritory.equals((Object)BlockPos.f_121853_)) {
                this.targetPos = this.findNearestWaterBiome(level, this.naiad.m_20183_());
                if (this.targetPos != null) {
                    this.naiad.setTerritory(this.targetPos);
                }
            } else {
                this.targetPos = currentTerritory;
            }
            if (this.targetPos != null) {
                this.moveToBlock();
            }
        }

        public void moveToBlock() {
            this.naiad.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 1.0);
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.tryTicks;
            if (this.naiad.m_20069_()) {
                Vec3 motion = this.naiad.m_20184_();
                BlockPos pos = this.naiad.getTerritory();
                Vec3 target = new Vec3((double)pos.m_123341_() - this.naiad.m_20185_(), (double)pos.m_123342_() - this.naiad.m_20186_(), (double)pos.m_123343_() - this.naiad.m_20189_());
                if (target.m_82556_() > 1.0E-7) {
                    target = target.m_82541_().m_82490_(0.1).m_82549_(motion.m_82490_(0.45));
                }
                this.naiad.m_20256_(target);
                this.naiad.m_21563_().m_24950_(target.f_82479_, target.f_82480_, target.f_82481_, 30.0f, 30.0f);
            } else if (this.naiad.getTerritory() != BlockPos.f_121853_ && this.targetPos != null && this.shouldRecalculatePath()) {
                this.moveToBlock();
            }
        }

        public boolean m_8045_() {
            return this.targetPos != null && this.naiad.aggroTicks <= 0 && this.naiad.m_5448_() == null && this.targetPos.m_203193_((Position)this.naiad.m_20182_()) > 9.0;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean m_183429_() {
            return true;
        }

        private BlockPos findNearestWaterBiome(Level level, BlockPos origin) {
            int range = 128;
            int step = 4;
            for (int r = 4; r <= range; r += step) {
                for (int i = 0; i < r * 2; i += step) {
                    BlockPos[] positions;
                    BlockPos pos1 = origin.m_7918_(r, 0, i - r);
                    BlockPos pos2 = origin.m_7918_(-r, 0, i - r);
                    BlockPos pos3 = origin.m_7918_(i - r, 0, r);
                    BlockPos pos4 = origin.m_7918_(i - r, 0, -r);
                    for (BlockPos pos : positions = new BlockPos[]{pos1, pos2, pos3, pos4}) {
                        Holder biome;
                        if (!level.m_46749_(pos) || !(biome = level.m_204166_(pos)).m_203656_(BiomeTags.f_207603_) && !biome.m_203656_(BiomeTags.f_207602_) && !biome.m_203656_(BiomeTags.f_207605_)) continue;
                        BlockPos surfacePos = this.findWaterSurface(level, pos);
                        return surfacePos != null ? surfacePos : pos;
                    }
                }
            }
            return null;
        }

        private BlockPos findWaterSurface(Level level, BlockPos pos) {
            for (int y = level.m_5736_(); y > level.m_141937_(); --y) {
                BlockPos checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                if (level.m_6425_(checkPos).m_76178_() || !level.m_8055_(checkPos.m_7494_()).m_60795_()) continue;
                return checkPos;
            }
            return null;
        }
    }
}

