/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Damage.SdamageTypes;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class Chemist
extends EvolvedInfected {
    private int attackAnimationTick;
    private static final EntityDataAccessor<Integer> BLOW_TIME = SynchedEntityData.m_135353_(Chemist.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Chemist(EntityType<? extends EvolvedInfected> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.chemist_loot.get();
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.3) {
            return SdamageTypes.knight_damage((LivingEntity)this);
        }
        return super.getCustomDamage(entity);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.chemist_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.chemist_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.chemist_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 32.0);
    }

    public void m_7822_(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
            if (this.m_9236_().f_46443_) {
                Vec3 forward = this.m_20154_().m_82541_().m_82490_(1.0);
                double px = this.m_20185_() + forward.f_82479_;
                double py = this.m_20188_() - 0.25;
                double pz = this.m_20189_() + forward.f_82481_;
                for (int i = 0; i < 8; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, px + this.f_19796_.m_188500_() - this.f_19796_.m_188500_(), py, pz + this.f_19796_.m_188500_() - this.f_19796_.m_188500_(), 0.0, 0.05, 0.0);
                }
            }
        } else {
            super.m_7822_(value);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BLOW_TIME, (Object)0);
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        entity.m_7311_(200);
        return super.m_7327_(entity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getBlowTime() > 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.1, 0.0);
            this.tickExplosion();
        }
        if (this.getBlowTime() > 60) {
            this.explodeChemist();
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public void explodeChemist() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Level.ExplosionInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && (Boolean)SConfig.SERVER.chemist_explosion_on.get() != false ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
            serverLevel.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)((Double)SConfig.SERVER.chemist_explosion.get() * 1.0), explosion$blockinteraction);
            Utilities.convertBlocks(serverLevel, (Entity)this, this.m_20097_(), 7.0, Blocks.f_50083_.m_49966_());
            this.m_146870_();
        }
    }

    @Override
    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (effectInstance.m_19544_().m_19486_()) {
            return super.m_147207_(effectInstance, entity);
        }
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && Math.random() < 0.2) {
            this.tickExplosion();
        }
        return super.m_6469_(source, amount);
    }

    public void setBlowTime(int i) {
        this.f_19804_.m_135381_(BLOW_TIME, (Object)i);
    }

    public int getBlowTime() {
        return (Integer)this.f_19804_.m_135370_(BLOW_TIME);
    }

    private void tickExplosion() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.setBlowTime(this.getBlowTime() + 1);
        if (this.getBlowTime() == 1) {
            this.m_216990_((SoundEvent)Ssounds.CHEMIST_FUSE.get());
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.SCIENTIST_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }
}

