/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Damage.SdamageTypes;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.BraionmilSwellGoal;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.Hyper.Brot;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class Braionmil
extends EvolvedInfected
implements EvolvingInfected {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(Braionmil.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int swell;
    private final int maxSwell = 40;

    public Braionmil(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_braio_loot.get();
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
    }

    @Override
    public void m_7380_(CompoundTag data) {
        super.m_7380_(data);
        data.m_128376_("Fuse", (short)this.maxSwell);
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i = this.getSwellDir();
            if (i > 0 && this.swell == 0) {
                this.m_5496_((SoundEvent)Ssounds.BRAIOMIL_ATTACK.get(), 1.0f, 0.5f);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.setSwellDir(-1);
                this.chemAttack((LivingEntity)this);
            }
        }
        super.m_8119_();
        this.tickHyperEvolution(this);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    private void chemAttack(LivingEntity pLivingEntity) {
        AABB boundingBox = pLivingEntity.m_20191_().m_82400_(8.0);
        List entities = pLivingEntity.m_9236_().m_45933_((Entity)pLivingEntity, boundingBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (Utilities.helmetList().contains(livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_()) || !this.TARGET_SELECTOR.test(livingEntity)) continue;
            for (String str : (List)SConfig.SERVER.braio_effects.get()) {
                String[] string = str.split("\\|");
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(string[0]));
                if (effect == null || livingEntity.m_21023_(effect)) continue;
                livingEntity.m_7292_(new MobEffectInstance(effect, Integer.parseUnsignedInt(string[1]), Integer.parseUnsignedInt(string[2])));
            }
        }
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.3) {
            return SdamageTypes.braiomil_damage((LivingEntity)this);
        }
        return super.getCustomDamage(entity);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.m_9236_();
        if (this.swell >= 25) {
            for (int i = 0; i < 360; ++i) {
                if (i % 20 != 0) continue;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y + 1.2, z, Math.cos(i) * 0.15, Math.sin(i) * Math.cos(i) * 0.15, Math.sin(i) * 0.15);
            }
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0f + entity.m_20205_() * entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new BraionmilSwellGoal(this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.braio_melee_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.braio_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.braio_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 28.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.INF_GROWL.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public void HyperEvolve(LivingEntity living) {
        Brot brot = new Brot((EntityType<? extends Monster>)((EntityType)Sentities.BROTKATZE.get()), this.m_9236_());
        Collection collection = this.m_21220_();
        for (MobEffectInstance mobeffectinstance : collection) {
            brot.m_7292_(new MobEffectInstance(mobeffectinstance));
        }
        brot.setKills(this.getKills());
        brot.setEvoPoints(this.getEvoPoints() - (Integer)SConfig.SERVER.min_kills_hyper.get());
        brot.m_6593_(this.m_7770_());
        brot.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            brot.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20097_()), MobSpawnType.CONVERSION, null, null);
        }
        this.m_9236_().m_7967_((Entity)brot);
        this.m_146870_();
        EvolvingInfected.super.HyperEvolve(living);
    }
}

