/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.Core.SAttributes;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.BaseEntities.HohlMultipart;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.MovementControls.UndergroundMovementControl;
import com.Harbinger.Spore.Sentities.MovementControls.UndergroundPathNavigation;
import com.Harbinger.Spore.Sentities.Projectile.ThrownTumor;
import com.Harbinger.Spore.Sentities.Projectile.VomitHohlBall;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.Sentities.Utility.CorpseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

public class Hohlfresser
extends Calamity
implements TrueCalamity,
RangedAttackMob {
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CHILD_ID = SynchedEntityData.m_135353_(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VULNERABLE = SynchedEntityData.m_135353_(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> ADAPTED = SynchedEntityData.m_135353_(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> UNDERGROUND = SynchedEntityData.m_135353_(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> WORM_ANGLE = SynchedEntityData.m_135353_(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ORES = SynchedEntityData.m_135353_(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float spin = 0.0f;
    private HohlMultipart[] parts = null;
    public final float[] ringBuffer = new float[64];
    public int ringBufferIndex = -1;
    public float prevWormAngle;
    private int ticksUnder;
    private static final Map<BlockState, Integer> cache = new WeakHashMap<BlockState, Integer>();
    public static final TagKey<Block> ORE_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("forge:ores"));
    public static final int FLAG_MINEABLE = 1;
    public static final int FLAG_HARD = 2;
    public static final int FLAG_WRONG = 4;
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.HOHL_JAW, HitboxesForParts.HOHL_HEAD);
    private final List<HitboxesForParts> tailHitboxes = List.of(HitboxesForParts.HOHL_SEG1, HitboxesForParts.HOHL_SEG2, HitboxesForParts.HOHL_SEG3, HitboxesForParts.HOHL_TAIL);

    public Hohlfresser(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(2.0f);
        this.f_21342_ = new UndergroundMovementControl((Mob)this);
        this.f_21344_ = new UndergroundPathNavigation(this, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ADAPTED, (Object)false);
        this.f_19804_.m_135372_(UNDERGROUND, (Object)false);
        this.f_19804_.m_135372_(VULNERABLE, (Object)0);
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHILD_ID, (Object)-1);
        this.f_19804_.m_135372_(WORM_ANGLE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ORES, (Object)Float.valueOf(0.0f));
    }

    public float getSpin() {
        float speed = (float)Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_);
        this.spin += speed * 2.5E-4f * (float)this.f_19797_;
        return this.spin;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.hohl_loot.get();
    }

    @Override
    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean canGoUnderground() {
        return (Boolean)this.f_19804_.m_135370_(UNDERGROUND) == false && (Integer)this.f_19804_.m_135370_(VULNERABLE) <= 0;
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.hohl_dpsr.get();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("adaptation", ((Boolean)this.f_19804_.m_135370_(ADAPTED)).booleanValue());
        tag.m_128379_("underground", ((Boolean)this.f_19804_.m_135370_(UNDERGROUND)).booleanValue());
        tag.m_128405_("vulnerable", ((Integer)this.f_19804_.m_135370_(VULNERABLE)).intValue());
        tag.m_128350_("ores", ((Float)this.f_19804_.m_135370_(ORES)).floatValue());
        if (this.getChildId() != null) {
            tag.m_128362_("ChildUUID", this.getChildId());
        }
    }

    public boolean isInWall(LivingEntity mob) {
        float f = mob.m_20205_() * 0.8f;
        AABB aabb = AABB.m_165882_((Vec3)mob.m_146892_().m_82520_(0.0, -0.05, 0.0), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.m_121921_((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = mob.m_9236_().m_8055_(p_201942_);
            return !blockstate.m_60795_() && blockstate.m_60828_((BlockGetter)mob.m_9236_(), p_201942_) && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)mob.m_9236_(), p_201942_).m_83216_((double)p_201942_.m_123341_(), (double)p_201942_.m_123342_(), (double)p_201942_.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(ADAPTED, (Object)tag.m_128471_("adaptation"));
        this.f_19804_.m_135381_(UNDERGROUND, (Object)tag.m_128471_("underground"));
        this.f_19804_.m_135381_(VULNERABLE, (Object)tag.m_128451_("vulnerable"));
        this.f_19804_.m_135381_(ORES, (Object)Float.valueOf(tag.m_128457_("ores")));
        if (tag.m_128403_("ChildUUID")) {
            this.setChildId(tag.m_128342_("ChildUUID"));
        }
    }

    @Override
    public void setDefaultAdaptation(ServerLevelAccessor level) {
        super.setDefaultAdaptation(level);
        this.f_19804_.m_135381_(ADAPTED, (Object)true);
    }

    @Override
    protected void grief(AABB aabb) {
        if (!this.isUnderground() && this.f_19797_ % 20 == 0) {
            AABB box;
            DamageSource source = this.m_21225_();
            AABB aABB = box = source == null ? aabb : aabb.m_82383_(new Vec3(0.0, 1.0, 0.0));
            if (Math.random() < (double)0.2f) {
                this.handleDigIn();
            }
            super.grief(box);
        }
    }

    public boolean isUnderground() {
        return (Boolean)this.f_19804_.m_135370_(UNDERGROUND);
    }

    public void setUnderground(boolean val) {
        if (val) {
            this.m_216990_((SoundEvent)Ssounds.WORM_DIGGING.get());
            this.ticksUnder = 40;
        } else {
            this.f_19804_.m_135381_(VULNERABLE, (Object)200);
        }
        this.f_19804_.m_135381_(UNDERGROUND, (Object)val);
        this.f_19794_ = val;
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        return this.m_6469_(source, value);
    }

    public void setWormAngle(float angle) {
        this.f_19804_.m_135381_(WORM_ANGLE, (Object)Float.valueOf(angle));
    }

    public float getWormAngle() {
        return ((Float)this.f_19804_.m_135370_(WORM_ANGLE)).floatValue();
    }

    @Override
    public int chemicalRange() {
        return 16;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.hohl_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.hohl_debuffs.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.hohl_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.hohl_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.hohl_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_((Attribute)SAttributes.TOXICITY.get(), 0.0).m_22268_((Attribute)SAttributes.REJUVENATION.get(), 0.0).m_22268_((Attribute)SAttributes.LOCALIZATION.get(), 0.0).m_22268_((Attribute)SAttributes.LACERATION.get(), 0.0).m_22268_((Attribute)SAttributes.CORROSIVES.get(), 0.0).m_22268_((Attribute)SAttributes.BALLISTIC.get(), 0.0).m_22268_((Attribute)SAttributes.GRINDING.get(), 0.0);
    }

    public HohlMultipart[] getHolfParts() {
        return this.parts;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    private int getSegments() {
        return 5;
    }

    private boolean shouldReplaceParts() {
        if (this.parts == null || this.parts[0] == null) {
            return true;
        }
        for (int i = 0; i < this.getSegments(); ++i) {
            if (this.parts[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevWormAngle = this.getWormAngle();
        if (this.f_19859_ - this.m_146908_() > 0.05f) {
            this.setWormAngle(this.getWormAngle() + 15.0f);
        } else if (this.f_19859_ - this.m_146908_() < -0.05f) {
            this.setWormAngle(this.getWormAngle() - 15.0f);
        } else if (this.getWormAngle() > 0.0f) {
            this.setWormAngle(Math.max(this.getWormAngle() - 20.0f, 0.0f));
        } else if (this.getWormAngle() < 0.0f) {
            this.setWormAngle(Math.min(this.getWormAngle() + 20.0f, 0.0f));
        }
        if ((Integer)this.f_19804_.m_135370_(VULNERABLE) > 0) {
            this.f_19804_.m_135381_(VULNERABLE, (Object)((Integer)this.f_19804_.m_135370_(VULNERABLE) - 1));
        }
        if (!this.m_9236_().f_46443_) {
            int i;
            Entity child = this.getChild();
            if (child == null) {
                float size = 1.0f;
                TrueCalamity partParent = this;
                this.parts = new HohlMultipart[this.getSegments()];
                for (i = 0; i < this.getSegments(); ++i) {
                    HohlMultipart part = new HohlMultipart((EntityType<? extends LivingEntity>)((EntityType)Sentities.HOHLFRESSER_SEG.get()), this.m_9236_());
                    part.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    part.setParent((Entity)partParent);
                    part.setSize(size -= 0.1f);
                    part.setColor(this.getMutationColor());
                    part.setVariant();
                    part.setIsTail(i == this.getSegments() - 1);
                    if (partParent == this) {
                        this.setChildId(part.m_20148_());
                        this.f_19804_.m_135381_(CHILD_ID, (Object)part.m_19879_());
                    }
                    if (partParent instanceof HohlMultipart) {
                        HohlMultipart partIndex = (HohlMultipart)partParent;
                        partIndex.setChildId(part.m_20148_());
                    }
                    partParent = part;
                    this.m_9236_().m_7967_((Entity)part);
                    this.parts[i] = part;
                }
            }
            if (this.shouldReplaceParts() && this.getChild() instanceof HohlMultipart) {
                this.parts = new HohlMultipart[this.getSegments()];
                this.parts[0] = (HohlMultipart)this.getChild();
                this.f_19804_.m_135381_(CHILD_ID, (Object)this.parts[0].m_19879_());
                for (int i2 = 1; i2 < this.parts.length && this.parts[i2 - 1].getChild() instanceof HohlMultipart; ++i2) {
                    this.parts[i2] = (HohlMultipart)this.parts[i2 - 1].getChild();
                }
            }
            Vec3 prev = this.m_20182_();
            float xRot = this.m_146909_();
            for (i = 0; i < this.getSegments(); ++i) {
                if (this.parts[i] == null) continue;
                float yaw = this.getYawForPart(i);
                prev = this.parts[i].tickMultipartPosition(this.m_19879_(), prev, xRot, this.m_146908_(), yaw, true);
                xRot = this.parts[i].m_146909_();
            }
        }
        if (this.isUnderground()) {
            this.handleUnearthing();
        }
        if (this.f_19797_ % 20 == 0) {
            this.handleDigIn();
        }
        if (this.ticksUnder > 0) {
            --this.ticksUnder;
        }
        if (this.f_19797_ % 20 == 0 && this.isMoving() && this.isUnderground() && this.m_5448_() != null) {
            this.tryAndCrumbleBlocks();
        }
        if (this.f_19797_ % 80 == 0 && this.isUnderground() && this.isInWall((LivingEntity)this)) {
            this.m_216990_((SoundEvent)Ssounds.WORM_DIGGING.get());
        }
        if (this.f_19797_ % 10 == 0) {
            this.handleShooting();
        }
    }

    void handleShooting() {
        LivingEntity living = this.m_5448_();
        if (living != null && living.m_20280_((Entity)this) > 100.0 && this.hasSight((Entity)living)) {
            this.m_6504_(living, 0.0f);
        }
    }

    public boolean hasSight(Entity entity) {
        if (entity.m_9236_() != this.m_9236_()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public float getOres() {
        return ((Float)this.f_19804_.m_135370_(ORES)).floatValue();
    }

    public void tryAndCrumbleBlocks() {
        ServerLevel serverLevel;
        if (this.m_9236_().f_46443_) {
            return;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && !this.checkForNearbyPlayers(serverLevel = (ServerLevel)level)) {
            return;
        }
        boolean canGrief = ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this);
        if (!canGrief) {
            return;
        }
        AABB aabb = this.m_20191_().m_82400_(8.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            double speed;
            boolean canFall;
            BlockState state = this.m_9236_().m_8055_(blockpos);
            BlockState stateBelow = this.m_9236_().m_8055_(blockpos.m_7495_());
            boolean bl = canFall = stateBelow.m_60795_() || stateBelow.m_278721_();
            if (canFall && Math.random() < (double)0.01f && (speed = (double)state.m_60800_((BlockGetter)this.m_9236_(), blockpos)) > 0.0 && speed <= (double)((Integer)SConfig.SERVER.calamity_bd.get()).intValue()) {
                this.m_9236_().m_7471_(blockpos, false);
                FallingBlockEntity.m_201971_((Level)this.m_9236_(), (BlockPos)blockpos, (BlockState)state);
            }
            if ((state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50493_)) && Math.random() < 0.2) {
                this.m_9236_().m_7731_(blockpos, Math.random() < 0.5 ? Blocks.f_50493_.m_49966_() : Blocks.f_50546_.m_49966_(), 3);
            }
            if (!state.m_204336_(ORE_TAG) || !(Math.random() < (double)0.005f)) continue;
            this.f_19804_.m_135381_(ORES, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(ORES)).floatValue() + 1.0f));
            this.m_9236_().m_7731_(blockpos, blockpos.m_123342_() < 0 ? Blocks.f_152551_.m_49966_() : Blocks.f_50652_.m_49966_(), 3);
        }
    }

    private boolean checkForNearbyPlayers(ServerLevel serverLevel) {
        List playerList = serverLevel.m_8795_(p -> true);
        if (playerList.isEmpty()) {
            return false;
        }
        for (ServerPlayer player : playerList) {
            if (!(player.m_20270_((Entity)this) < 400.0f)) continue;
            return true;
        }
        return false;
    }

    public int analyzeBlock(BlockState state, BlockPos pos, Map<BlockState, Integer> cache) {
        return cache.computeIfAbsent(state, s -> {
            double hardness = s.m_60800_((BlockGetter)this.m_9236_(), pos);
            if (hardness == -1.0) {
                return 6;
            }
            boolean isMineable = s.m_60795_() || s.m_247087_() || s.m_204336_(BlockTags.f_144283_) || s.m_204336_(BlockTags.f_144282_) || !s.m_60804_((BlockGetter)this.m_9236_(), pos) || hardness == 0.0;
            boolean isHard = hardness > 3.0;
            boolean isWrong = !isMineable;
            int result = 0;
            if (isMineable) {
                result |= 1;
            }
            if (isHard) {
                result |= 2;
            }
            if (isWrong) {
                result |= 4;
            }
            return result;
        });
    }

    private boolean checkBlocksUnder() {
        AABB aabb = this.m_20191_().m_82386_(0.0, -0.6, 0.0);
        for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState state = this.m_9236_().m_8055_(pos);
            int result = this.analyzeBlock(state, pos, cache);
            if ((result & 2) != 0 || (result & 1) == 0) {
                return false;
            }
            BlockState aboveState = this.m_9236_().m_8055_(pos.m_7494_());
            int aboveResult = this.analyzeBlock(aboveState, pos.m_7494_(), cache);
            if ((aboveResult & 1) != 0 && (aboveResult & 2) == 0) continue;
            return false;
        }
        return true;
    }

    public void handleDigIn() {
        if (!this.isUnderground() && (Integer)this.f_19804_.m_135370_(VULNERABLE) <= 0) {
            boolean above;
            boolean tooDeep = (double)this.m_9236_().m_141937_() < this.m_20186_() - 5.0;
            boolean below = this.f_21342_.m_25001_() < this.m_20186_();
            boolean bl = above = this.f_21342_.m_25001_() > this.m_20186_() + 1.0;
            if ((below || above) && this.checkBlocksUnder() && tooDeep) {
                this.setUnderground(true);
            }
        }
    }

    public void handleUnearthing() {
        AABB aabb = this.m_20191_().m_82377_(1.0, 1.4, 1.0);
        int airAmount = 0;
        boolean meetsHardBlock = false;
        boolean meetsWrongBlock = false;
        for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState state = this.m_9236_().m_8055_(pos);
            int result = this.analyzeBlock(state, pos, cache);
            if (this.m_9236_().m_45527_(pos) && this.ticksUnder <= 0) {
                ++airAmount;
            }
            if ((result & 4) != 0) {
                meetsWrongBlock = true;
                break;
            }
            if ((result & 2) == 0) continue;
            meetsHardBlock = true;
            break;
        }
        if (airAmount >= 4 || meetsHardBlock || meetsWrongBlock) {
            this.setUnderground(false);
        }
    }

    private float getYawForPart(int i) {
        return this.getRingBuffer(4 + i * 2, 1.0f);
    }

    public float getRingBuffer(int bufferOffset, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - bufferOffset & 0x3F;
        int j = this.ringBufferIndex - bufferOffset - 1 & 0x3F;
        float d0 = this.ringBuffer[i];
        float d1 = this.ringBuffer[j] - d0;
        return Mth.m_14177_((float)(d0 + d1 * partialTicks));
    }

    public boolean isMoving() {
        return Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_) > 0.0;
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268671_);
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new HohlChargeGoal(this, 0.5, 300, 100.0f));
        this.f_21345_.m_25352_(5, (Goal)new HohlfresserMeleeAttack(this, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.f_21345_.m_25352_(6, (Goal)new CalamityInfectedCommand(this));
        this.f_21345_.m_25352_(7, (Goal)new SummonScentInCombat(this));
        this.f_21345_.m_25352_(8, (Goal)new SporeBurstSupport(this));
        super.m_8099_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    private boolean checkVectorForSeeing(Entity target) {
        Vec3 startVec = this.m_20182_();
        Vec3 endVec = target.m_20182_();
        Vec3 direction = endVec.m_82546_(startVec).m_82541_();
        double distance = startVec.m_82554_(endVec);
        for (double i = 0.0; i <= distance; i += 0.5) {
            Vec3 current = startVec.m_82549_(direction.m_82490_(i));
            BlockPos pos = BlockPos.m_274446_((Position)current);
            BlockState state = this.m_9236_().m_8055_(pos);
            int result = this.analyzeBlock(state, pos, cache);
            if ((result & 2) == 0 && (result & 1) != 0) continue;
            return false;
        }
        return true;
    }

    public boolean m_142582_(Entity entity) {
        if (this.getSearchArea() == BlockPos.f_121853_) {
            if (this.m_20069_()) {
                return true;
            }
            return this.checkVectorForSeeing(entity) || super.m_142582_(entity);
        }
        return super.m_142582_(entity);
    }

    public int getShootingAmount() {
        AttributeInstance instance = this.m_21051_((Attribute)SAttributes.BALLISTIC.get());
        if (instance != null && instance.m_22135_() > 0.0) {
            int value = (int)(instance.m_22135_() * 3.0);
            return this.f_19796_.m_188503_(value + 1);
        }
        return 1;
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        if (Math.random() < (double)0.1f) {
            for (int i = 0; i < this.getShootingAmount(); ++i) {
                this.shootTumor(livingEntity);
            }
        } else {
            float extraDamage = (float)((Double)SConfig.SERVER.hohl_r_damage.get() + (double)(this.getOres() * 0.2f));
            double maxDamage = (Double)SConfig.SERVER.hohl_damage.get() / 2.0;
            double damage = maxDamage <= (double)extraDamage ? maxDamage : (double)extraDamage;
            VomitHohlBall.shoot((LivingEntity)this, livingEntity, (float)damage, this.getOres() > 0.0f, this.getKills() > 0);
        }
    }

    void shootTumor(LivingEntity livingEntity) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        ThrownTumor tumor = new ThrownTumor(this.m_9236_(), (LivingEntity)this);
        double dx = livingEntity.m_20185_() - this.m_20185_();
        double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_();
        double dz = livingEntity.m_20189_() - this.m_20189_();
        tumor.setExplode(Level.ExplosionInteraction.MOB);
        tumor.m_6686_(dx, dy - tumor.m_20186_() + Math.hypot(dx, dz) * (double)0.05f, dz, 1.0f, 12.0f);
        this.m_9236_().m_7967_((Entity)tumor);
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.m_216990_((SoundEvent)Ssounds.SIEGER_BITE.get());
        return super.m_7327_(entity);
    }

    protected void m_142540_(MobEffectInstance instance, @Nullable Entity source) {
        super.m_142540_(instance, source);
        HohlMultipart[] parts = this.getHolfParts();
        if (parts == null) {
            return;
        }
        for (HohlMultipart part : parts) {
            if (part == null) {
                return;
            }
            MobEffectInstance existing = part.m_21124_(instance.m_19544_());
            if (existing != null && existing.m_19557_() >= instance.m_19557_() - 5) continue;
            part.m_7292_(new MobEffectInstance(instance));
        }
    }

    protected void m_7285_(MobEffectInstance instance) {
        super.m_7285_(instance);
        if (this.getHolfParts() == null) {
            return;
        }
        for (HohlMultipart hohlMultipart : this.getHolfParts()) {
            if (hohlMultipart == null) {
                return;
            }
            hohlMultipart.m_21195_(instance.m_19544_());
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.HOHL_AMBIENT.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12361_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>(this.innatePartList);
        if (this.getHolfParts() != null) {
            for (HohlMultipart multipart : this.getHolfParts()) {
                values.add(this.CalculateParts(multipart));
            }
        }
        return values;
    }

    @Override
    public void summonCorpsePart(int partCount, List<List<ItemStack>> distributedLoot, List<HitboxesForParts> partList) {
        AtomicInteger index = new AtomicInteger();
        for (int i = 0; i < partCount; ++i) {
            CorpseEntity partEntity = new CorpseEntity((EntityType)Sentities.CORPSE_PIECE.get(), this.m_9236_());
            for (ItemStack stack : distributedLoot.get(i)) {
                partEntity.addToInventory(stack);
            }
            partEntity.setColor(this.getMutationColor());
            partEntity.m_20219_(this.calculateSegmentsPosition(i - 2));
            partEntity.m_20256_(new Vec3((this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.9, this.f_19796_.m_188500_() * 0.6 + 0.3, (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.9));
            partEntity.setOwnerAda(this.getAdaptation());
            partEntity.setCorpseType(partList.get(i).getID());
            partEntity.setInflation(this.tryToFindInflation(index.get(), partList.get(i).getID(), index::getAndIncrement));
            this.m_9236_().m_7967_((Entity)partEntity);
        }
    }

    private Vec3 calculateSegmentsPosition(int value) {
        if (value < 0 || this.getHolfParts() == null || this.getHolfParts().length < value) {
            return this.m_20182_();
        }
        return this.getHolfParts()[value].m_20182_();
    }

    public float tryToFindInflation(int startPoint, int ID, Runnable runnable) {
        if (this.getHolfParts() == null) {
            return 1.0f;
        }
        int length = this.getHolfParts().length;
        if (length < startPoint) {
            return 1.0f;
        }
        if (this.tailHitboxes.contains((Object)HitboxesForParts.byId(ID))) {
            HohlMultipart multipart = this.getHolfParts()[startPoint];
            return multipart == null ? 1.0f : multipart.getSize();
        }
        runnable.run();
        return 1.0f;
    }

    private HitboxesForParts CalculateParts(HohlMultipart hohlMultipart) {
        if (hohlMultipart.isTail()) {
            return HitboxesForParts.HOHL_TAIL;
        }
        if (hohlMultipart.getSegmentVariant() == HohlMultipart.SegmentVariants.MELEE) {
            return HitboxesForParts.HOHL_SEG2;
        }
        if (hohlMultipart.getSegmentVariant() == HohlMultipart.SegmentVariants.ORGAN) {
            return HitboxesForParts.HOHL_SEG3;
        }
        return HitboxesForParts.HOHL_SEG1;
    }

    static class HohlChargeGoal
    extends Goal {
        private final Hohlfresser mob;
        private final double speed;
        private final int chargeDelay;
        private int chargeTimer = 0;
        private final float distance;

        HohlChargeGoal(Hohlfresser mob, double speed, int chargeDelay, float distance) {
            this.mob = mob;
            this.speed = speed;
            this.chargeDelay = chargeDelay;
            this.distance = distance;
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_()) {
                this.chargeTimer = 0;
                return false;
            }
            if (this.chargeTimer < this.chargeDelay) {
                ++this.chargeTimer;
                return false;
            }
            if (this.checkVectorForCharging((Entity)target)) {
                return true;
            }
            this.chargeTimer = 0;
            return false;
        }

        boolean jump(LivingEntity us, LivingEntity target) {
            return target.m_9236_().m_45527_(target.m_20097_()) && us.m_9236_().m_45527_(us.m_20097_());
        }

        public void m_8056_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null && target.m_20270_((Entity)this.mob) < this.distance) {
                this.mob.setUnderground(true);
                Vec3 direction = target.m_20182_().m_82546_(this.mob.m_20182_());
                if (direction.m_82556_() > 1.0E-7) {
                    direction.m_82541_();
                }
                if (this.jump((LivingEntity)this.mob, target)) {
                    direction.m_82549_(new Vec3(0.0, 0.3, 0.0));
                }
                this.mob.m_20256_(direction.m_82490_(this.speed));
            }
            this.chargeTimer = 0;
        }

        public boolean m_8045_() {
            return false;
        }

        private boolean checkVectorForCharging(Entity target) {
            HashMap<BlockState, Integer> cache = new HashMap<BlockState, Integer>();
            Vec3 startVec = this.mob.m_20182_();
            Vec3 endVec = target.m_20182_();
            Vec3 direction = endVec.m_82546_(startVec).m_82541_();
            double distance = startVec.m_82554_(endVec);
            for (double i = 0.0; i <= distance; i += 0.5) {
                Vec3 current = startVec.m_82549_(direction.m_82490_(i));
                BlockPos pos = BlockPos.m_274446_((Position)current);
                BlockState state = this.mob.m_9236_().m_8055_(pos);
                int result = this.mob.analyzeBlock(state, pos, cache);
                if ((result & 2) == 0 && (result & 1) != 0) continue;
                return false;
            }
            return true;
        }
    }

    static class HohlfresserMeleeAttack
    extends AOEMeleeAttackGoal {
        public HohlfresserMeleeAttack(Hohlfresser mob, Predicate<LivingEntity> targets) {
            super(mob, 1.5, false, 2.5, 6.0f, targets);
        }

        @Override
        protected double getAttackReachSqr(LivingEntity entity) {
            float f = this.mob.m_20205_();
            return f * 1.5f * f + entity.m_20205_();
        }
    }
}

