/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.Core.SAttributes;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.GazenWaterLeapGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.FallenMultipart.Licker;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.Projectile.BileProjectile;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.Sentities.WaterInfected;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fluids.FluidType;

public class Gazenbrecher
extends Calamity
implements WaterInfected,
RangedAttackMob,
TrueCalamity {
    public static final EntityDataAccessor<Integer> ADAPTATION = SynchedEntityData.m_135353_(Gazenbrecher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> TONGUE = SynchedEntityData.m_135353_(Gazenbrecher.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int radar;
    private final CalamityMultipart[] subEntities;
    public final CalamityMultipart lowerbody;
    public final CalamityMultipart head;
    public final CalamityMultipart tongue;
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.GAZEN_TAIL, HitboxesForParts.GAZEN_HEAD, HitboxesForParts.GAZEN_LEFT_LEG, HitboxesForParts.GAZEN_RIGHT_LEG);

    public Gazenbrecher(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.lowerbody = new CalamityMultipart(this, "lowerbody", 3.0f, 3.0f);
        this.tongue = new CalamityMultipart(this, "tongue", 2.0f, 2.0f);
        this.head = new CalamityMultipart(this, "head", 3.0f, 3.0f);
        this.subEntities = new CalamityMultipart[]{this.lowerbody, this.head, this.tongue};
        this.m_274367_(1.5f);
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.gazen_loot.get();
    }

    @Override
    public void m_7023_(Vec3 vec) {
        if (this.m_21515_() && this.isInFluidType()) {
            this.m_19920_(0.1f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.95));
        } else {
            super.m_7023_(vec);
        }
    }

    @Override
    public void ActivateAdaptation() {
        this.f_19804_.m_135381_(ADAPTATION, (Object)21);
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_20235_ + i + 1);
        }
    }

    @Override
    public double setInflation() {
        return 1.0;
    }

    @Override
    public void m_8119_() {
        BlockPos pos;
        super.m_8119_();
        if (this.f_19797_ % 1200 == 0 && this.getSearchArea() == BlockPos.f_121853_ && !this.isOcean(this.m_9236_().m_204166_(this.m_20097_())) && (pos = this.findOcean(this.m_9236_(), this.m_20097_())) != null) {
            this.setSearchArea(pos);
        }
        if (this.m_21223_() >= this.m_21233_() && this.getTongueHp() < this.getMaxTongueHp() && this.f_19797_ % 40 == 0) {
            this.setTongueHp(this.getTongueHp() + 1.0f);
        }
        if (this.isInFluidType()) {
            if (this.m_5448_() == null && this.radar >= 1200) {
                this.m_216990_((SoundEvent)Ssounds.SONAR.get());
                this.radar = 0;
                AABB boundingBox = this.m_20191_().m_82400_(64.0);
                List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
                for (Entity entity : entities) {
                    LivingEntity livingEntity;
                    if (!((List)SConfig.SERVER.whitelist.get()).contains(entity.m_20078_())) {
                        if (!(entity instanceof Player)) continue;
                        Player player = (Player)entity;
                        if (player.m_150110_().f_35937_) continue;
                    }
                    if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_6084_()) continue;
                    this.m_5496_((SoundEvent)Ssounds.SIGNAL.get(), 2.0f, 1.0f);
                    this.m_6710_(livingEntity);
                }
            } else {
                ++this.radar;
            }
        }
        if (!this.isAdaptedToFire() && this.f_19797_ % 40 == 0 && this.m_6060_()) {
            this.f_19804_.m_135381_(ADAPTATION, (Object)((Integer)this.f_19804_.m_135370_(ADAPTATION) + 1));
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TONGUE, (Object)Float.valueOf(this.getMaxTongueHp()));
        this.f_19804_.m_135372_(ADAPTATION, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("tongue_hp", ((Float)this.f_19804_.m_135370_(TONGUE)).floatValue());
        tag.m_128405_("adaptation", ((Integer)this.f_19804_.m_135370_(ADAPTATION)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(TONGUE, (Object)Float.valueOf(tag.m_128457_("tongue_hp")));
        this.f_19804_.m_135381_(ADAPTATION, (Object)tag.m_128451_("adaptation"));
    }

    public float getTongueHp() {
        return ((Float)this.f_19804_.m_135370_(TONGUE)).floatValue();
    }

    public void setTongueHp(float i) {
        this.f_19804_.m_135381_(TONGUE, (Object)Float.valueOf(i));
    }

    public float getMaxTongueHp() {
        return (float)((Double)SConfig.SERVER.gazen_hp.get() / 4.0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.gazen_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.gazen_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.gazen_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_((Attribute)SAttributes.TOXICITY.get(), 0.0).m_22268_((Attribute)SAttributes.REJUVENATION.get(), 0.0).m_22268_((Attribute)SAttributes.LOCALIZATION.get(), 0.0).m_22268_((Attribute)SAttributes.LACERATION.get(), 0.0).m_22268_((Attribute)SAttributes.CORROSIVES.get(), 0.0).m_22268_((Attribute)SAttributes.BALLISTIC.get(), 0.0).m_22268_((Attribute)SAttributes.GRINDING.get(), 0.0);
    }

    public void m_8107_() {
        float f14 = this.m_146908_() * ((float)Math.PI / 180);
        float f2 = Mth.m_14031_((float)f14);
        float f15 = Mth.m_14089_((float)f14);
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
        }
        this.tickPart(this.lowerbody, f2 * 2.5f, 0.0, -f15 * 2.5f);
        this.tickPart(this.head, f2 * -3.0f, 0.0, -f15 * -3.0f);
        this.tickPart(this.tongue, f2 * -5.0f, 0.3, -f15 * -5.0f);
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].f_19854_ = avec3[l].f_82479_;
            this.subEntities[l].f_19855_ = avec3[l].f_82480_;
            this.subEntities[l].f_19856_ = avec3[l].f_82481_;
            this.subEntities[l].f_19790_ = avec3[l].f_82479_;
            this.subEntities[l].f_19791_ = avec3[l].f_82480_;
            this.subEntities[l].f_19792_ = avec3[l].f_82481_;
        }
        super.m_8107_();
    }

    public CalamityMultipart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_141965_(ClientboundAddEntityPacket p_218825_) {
        super.m_141965_(p_218825_);
    }

    public boolean isAdaptedToFire() {
        return (Integer)this.f_19804_.m_135370_(ADAPTATION) > 20;
    }

    public int getAdaptationCount() {
        return (Integer)this.f_19804_.m_135370_(ADAPTATION);
    }

    public boolean m_5825_() {
        return this.isAdaptedToFire();
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.gazen_dpsr.get();
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new ScatterShotRangedGoal(this, 1.3, 60, 32.0f, 1, 3){

            @Override
            public boolean m_8036_() {
                if (Gazenbrecher.this.getTongueHp() <= 0.0f) {
                    return false;
                }
                return super.m_8036_() && (Gazenbrecher.this.calculateHeight() || Gazenbrecher.this.calculateDistance());
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new GazenWaterLeapGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new AOEMeleeAttackGoal(this, 1.5, false, 2.5, 6.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                float f = Gazenbrecher.this.m_20205_();
                return f * 2.0f * f * 2.0f + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(6, (Goal)new CalamityInfectedCommand(this));
        this.f_21345_.m_25352_(7, (Goal)new SummonScentInCombat(this));
        this.f_21345_.m_25352_(8, (Goal)new SporeBurstSupport(this));
        super.m_8099_();
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        if (calamityMultipart == this.tongue) {
            if (this.getTongueHp() > 0.0f && value > this.getTongueHp()) {
                if (this.getTongueHp() > 0.0f && value > this.getTongueHp()) {
                    this.m_216990_((SoundEvent)Ssounds.LIMB_SLASH.get());
                    this.SummonDetashedTongue();
                }
                this.m_216990_((SoundEvent)Ssounds.LIMB_SLASH.get());
            }
            this.m_6469_(source, value * 1.5f);
            this.setTongueHp(value > this.getTongueHp() ? 0.0f : this.getTongueHp() - value);
        } else {
            this.m_6469_(source, value);
        }
        return true;
    }

    @Override
    public int chemicalRange() {
        return 16;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.gazen_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.gazen_debuffs.get();
    }

    boolean calculateHeight() {
        return this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && Math.abs(Math.abs(this.m_5448_().m_20186_()) - Math.abs(this.m_20186_())) > 5.0;
    }

    boolean calculateDistance() {
        return this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) > 300.0;
    }

    public boolean m_142582_(Entity entity) {
        if (this.calculateDistance() || this.calculateHeight()) {
            return true;
        }
        return super.m_142582_(entity);
    }

    public void m_6504_(LivingEntity livingEntity, float p_33318_) {
        if (!this.m_9236_().f_46443_) {
            BileProjectile tumor = new BileProjectile(this.m_9236_(), (LivingEntity)this, this.TARGET_SELECTOR);
            Vec3 vec3 = new Vec3(3.0, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            double dx = livingEntity.m_20185_() - this.m_20185_();
            double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_();
            double dz = livingEntity.m_20189_() - this.m_20189_();
            if (this.isAdaptedToFire()) {
                tumor.m_20254_(10);
            }
            tumor.setDamage((float)((Double)SConfig.SERVER.gazen_ranged_damage.get() * 1.0));
            tumor.m_6027_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + 1.0, this.m_20189_() + vec3.f_82481_);
            tumor.m_6686_(dx, dy - tumor.m_20186_() + Math.hypot(dx, dz) * (double)0.001f, dz, 2.0f, 6.0f);
            this.m_9236_().m_7967_((Entity)tumor);
        }
    }

    private void SummonDetashedTongue() {
        Licker licker = new Licker((EntityType<? extends PathfinderMob>)((EntityType)Sentities.LICKER.get()), this.m_9236_());
        Vec3 vec3 = new Vec3(4.0, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        licker.setBurned(this.isAdaptedToFire());
        licker.m_6027_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + 1.6, this.m_20189_() + vec3.f_82481_);
        licker.m_5618_(this.m_146908_());
        this.m_9236_().m_7967_((Entity)licker);
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (this.isAdaptedToFire()) {
            entity.m_20254_(10);
        }
        this.m_216990_((SoundEvent)Ssounds.SIEGER_BITE.get());
        return super.m_7327_(entity);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        if (this.m_20096_()) {
            return SoundEvents.f_12361_;
        }
        return SoundEvents.f_11918_;
    }

    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) > 200.0) {
            return null;
        }
        return (SoundEvent)Ssounds.GAZEN_AMBIENT.get();
    }

    @Override
    public String getMutation() {
        if (this.isAdaptedToFire()) {
            return "spore.entity.variant.crispy";
        }
        return super.getMutation();
    }

    @Override
    public boolean getAdaptation() {
        return this.isAdaptedToFire();
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>();
        if (this.getTongueHp() > 0.0f) {
            values.add(HitboxesForParts.LICKER);
        }
        for (HitboxesForParts hitboxes : this.innatePartList) {
            HitboxesForParts part = this.calculateChance(hitboxes, 0.85f);
            if (part == null) continue;
            values.add(part);
        }
        return values;
    }
}

