/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities.IkUtil;

import com.Harbinger.Spore.Sentities.Calamities.Grakensenker;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class IkKrakenLeg {
    protected final RandomSource randomSource = RandomSource.m_216327_();
    protected final Grakensenker owner;
    protected final Vec3[] entities;
    protected int[] segmentVar;
    protected final Vec3 defaultBodyOffset;
    protected final Vec3 defaultLimbOffset;
    protected final Vec3 underwaterLimbOffset;
    protected final float maxDistance;
    protected final float[] wiggleTimers;
    protected final float[] wiggleSpeeds;
    protected final float[] wiggleAmplitudes;
    protected final float[] wiggleOffsets;
    protected Vec3 sitPosition = null;
    protected Vec3 lastSitPosition = null;
    protected int stepUpTicks = 0;

    public IkKrakenLeg(Grakensenker owner, int amount, Vec3 defaultBodyOffset, Vec3 defaultLimbOffset, Vec3 underWaterOffset, float maxDistance) {
        this.owner = owner;
        this.entities = new Vec3[amount];
        this.segmentVar = new int[amount];
        this.wiggleTimers = new float[amount];
        this.wiggleSpeeds = new float[amount];
        this.wiggleAmplitudes = new float[amount];
        this.wiggleOffsets = new float[amount];
        for (int i = 0; i < amount; ++i) {
            this.entities[i] = new Vec3(0.0, 0.0, 0.0);
            this.segmentVar[i] = this.randomSource.m_188503_(12);
            this.wiggleSpeeds[i] = 0.5f + this.randomSource.m_188501_() * this.getWiggleSpeed();
            this.wiggleAmplitudes[i] = 0.02f + this.randomSource.m_188501_() * this.getWiggleAmplitude();
            this.wiggleOffsets[i] = this.randomSource.m_188501_() * (float)Math.PI * 2.0f;
            this.wiggleTimers[i] = this.randomSource.m_188501_() * 100.0f;
        }
        this.defaultBodyOffset = defaultBodyOffset;
        this.defaultLimbOffset = defaultLimbOffset;
        this.underwaterLimbOffset = underWaterOffset;
        this.maxDistance = maxDistance;
    }

    public float getWiggleSpeed() {
        return 0.75f;
    }

    public float getWiggleAmplitude() {
        return 0.03f;
    }

    protected void updateWiggleTimers() {
        for (int i = 0; i < this.wiggleTimers.length; ++i) {
            int n = i;
            this.wiggleTimers[n] = this.wiggleTimers[n] + 0.05f * this.wiggleSpeeds[i];
            if (!(this.wiggleTimers[i] > 1000.0f)) continue;
            int n2 = i;
            this.wiggleTimers[n2] = this.wiggleTimers[n2] - 1000.0f;
        }
    }

    public Vec3 getSitPosition() {
        return this.sitPosition;
    }

    protected void applyIdleWiggle() {
        RandomSource rand = this.randomSource;
        for (int i = 1; i < this.entities.length - 1; ++i) {
            Vec3 current = this.entities[i];
            float time = this.wiggleTimers[i] + this.wiggleOffsets[i];
            float xWiggle = (float)Math.sin(time * 0.7f) * this.wiggleAmplitudes[i];
            float yWiggle = (float)Math.sin(time * 1.2f + 1.5f) * this.wiggleAmplitudes[i] * 0.8f;
            float zWiggle = (float)Math.sin(time * 0.9f + 2.0f) * this.wiggleAmplitudes[i] * 0.6f;
            if (rand.m_188501_() < 0.05f) {
                xWiggle += (rand.m_188501_() - 0.5f) * 0.02f;
                yWiggle += (rand.m_188501_() - 0.5f) * 0.01f;
                zWiggle += (rand.m_188501_() - 0.5f) * 0.02f;
            }
            this.entities[i] = current.m_82520_((double)xWiggle, (double)yWiggle, (double)zWiggle);
        }
    }

    public Vec3[] getEntities() {
        return this.entities;
    }

    public Vec3 getLastSitPosition() {
        return this.lastSitPosition;
    }

    public int[] getSegmentVar() {
        return this.segmentVar;
    }

    public void writeVariants(CompoundTag tag, int ikN) {
        tag.m_128385_("variants" + ikN, this.segmentVar);
    }

    public void readVariants(CompoundTag tag, int ikN) {
        this.segmentVar = tag.m_128465_("variants" + ikN);
    }

    public Vec3 applyYaw(Vec3 offset) {
        float yawRad = this.owner.m_146908_() * ((float)Math.PI / 180);
        float spinRad = (float)this.owner.getWaterTicks() * 0.05f;
        return offset.m_82524_(-yawRad - 1.5707964f + spinRad);
    }

    public Vec3 getLegBasePos() {
        Vec3 pivot = this.owner.m_20182_();
        return pivot.m_82549_(this.applyYaw(this.defaultLimbOffset));
    }

    public Vec3 getBodyOffset() {
        Vec3 pivot = this.owner.m_20182_().m_82520_(0.0, (double)this.owner.getExtendedHeight(), 0.0);
        return pivot.m_82549_(this.applyYaw(this.defaultBodyOffset));
    }

    public Vec3 getUnderwaterLegOffset() {
        Vec3 pivot = this.owner.m_20182_().m_82520_(0.0, (double)this.owner.getExtendedHeight(), 0.0);
        return pivot.m_82549_(this.applyYaw(this.underwaterLimbOffset));
    }

    protected void moveSegmentTowards(int index, Vec3 target, boolean far) {
        Vec3 currentPos = this.entities[index];
        Vec3 newPos = currentPos.m_165921_(target, this.owner.isInDeepWater() ? 0.5 : (double)0.35f);
        this.entities[index] = far ? target : newPos;
    }

    protected void moveTipTowards(Vec3 target) {
        int tip = this.entities.length - 1;
        Vec3 currentPos = this.entities[tip];
        if (this.owner.isInDeepWater()) {
            this.entities[tip] = currentPos.m_165921_(this.getUnderwaterLegOffset(), (double)0.35f);
            return;
        }
        float jumpVal = 3.5f;
        boolean val = this.stepUpTicks > 0 && this.isOwnerMoving();
        this.entities[tip] = currentPos.m_165921_(target.m_82520_(0.0, val ? (double)jumpVal : -1.0, 0.0), (double)0.15f);
        if (val) {
            for (int i = 1; i < this.entities.length - 1; ++i) {
                this.entities[tip] = currentPos.m_165921_(target.m_82520_(0.0, (double)jumpVal, 0.0), (double)0.05f);
            }
        }
    }

    protected boolean isOwnerMoving() {
        return this.owner.m_20184_().m_82556_() > 0.005;
    }

    public void applyIK() {
        Vec3 solvedPos;
        float segmentLength;
        Vec3 dir;
        int i;
        if (this.entities == null || this.entities.length == 0) {
            return;
        }
        Vec3 basePos = this.getBodyOffset();
        Vec3 defaultTipPos = this.sitPosition == null ? this.getLegBasePos() : this.sitPosition;
        boolean tooFar = this.entities[this.entities.length - 1].m_82557_(defaultTipPos) > 225.0;
        this.moveTipTowards(defaultTipPos);
        for (i = this.entities.length - 2; i >= 0; --i) {
            Vec3 nextPos = this.entities[i + 1];
            dir = this.entities[i].m_82546_(nextPos);
            segmentLength = 1.0f;
            dir = dir.m_82556_() > (double)1.0E-4f ? dir.m_82541_().m_82490_((double)segmentLength) : new Vec3((double)segmentLength, 0.0, 0.0);
            solvedPos = nextPos.m_82549_(dir);
            this.moveSegmentTowards(i, solvedPos, tooFar);
        }
        this.entities[0] = basePos;
        for (i = 1; i < this.entities.length; ++i) {
            Vec3 prevPos = this.entities[i - 1];
            dir = this.entities[i].m_82546_(prevPos);
            segmentLength = 1.0f;
            dir = dir.m_82556_() > (double)1.0E-4f ? dir.m_82541_().m_82490_((double)segmentLength) : new Vec3((double)segmentLength, 0.0, 0.0);
            solvedPos = prevPos.m_82549_(dir);
            this.moveSegmentTowards(i, solvedPos, tooFar);
        }
        this.applyIdleWiggle();
        this.updateWiggleTimers();
        if (this.stepUpTicks > 0) {
            --this.stepUpTicks;
        }
    }

    public void refreshLegStandingPoint() {
        if (this.owner.isInDeepWater()) {
            return;
        }
        if (this.lastSitPosition != null && this.getLegBasePos().m_82554_(this.lastSitPosition) < (double)this.maxDistance) {
            return;
        }
        this.sitPosition = this.findStableFooting();
        if (!this.sitPosition.equals((Object)this.lastSitPosition)) {
            this.stepUpTicks = 10;
            this.lastSitPosition = this.sitPosition;
        }
    }

    protected Vec3 findStableFooting() {
        Level level = this.owner.m_9236_();
        if (level.m_5776_()) {
            return this.getLegBasePos();
        }
        Vec3 worldBasePos = this.getLegBasePos();
        int searchRadius = 6;
        int maxSearchDown = 12;
        int maxSearchUp = 6;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int y = 0; y >= -maxSearchDown; --y) {
            checkPos.m_122169_(worldBasePos.f_82479_, worldBasePos.f_82480_ + (double)y, worldBasePos.f_82481_);
            if (!this.isSolidGround(level, (BlockPos)checkPos)) continue;
            return new Vec3((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() - 1.0, (double)checkPos.m_123343_() + 0.5);
        }
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                for (int y = maxSearchUp; y >= -maxSearchDown; --y) {
                    checkPos.m_122169_(worldBasePos.f_82479_ + (double)x, worldBasePos.f_82480_ + (double)y, worldBasePos.f_82481_ + (double)z);
                    if (!this.isSolidGround(level, (BlockPos)checkPos) || !level.m_46859_(checkPos.m_7494_())) continue;
                    return new Vec3((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() - 1.0, (double)checkPos.m_123343_() + 0.5);
                }
            }
        }
        return worldBasePos;
    }

    private boolean isSolidGround(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_280296_() || !level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_();
    }
}

