/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class SpecialEffects {
    private static Ring buildRing(Vec3 center, Vec3 direction, float radius, float rotationOffset) {
        Ring ring = new Ring();
        Vec3 up = Math.abs(direction.f_82480_) > 0.99 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 right = direction.m_82537_(up).m_82541_();
        Vec3 forward = right.m_82537_(direction).m_82541_();
        for (int i = 0; i < 8; ++i) {
            float angle = (float)i * ((float)Math.PI * 2) / 8.0f + rotationOffset;
            float x = Mth.m_14089_((float)angle);
            float y = Mth.m_14031_((float)angle);
            Vec3 offset = right.m_82490_((double)(x * radius)).m_82549_(forward.m_82490_((double)(y * radius)));
            ring.vertices[i] = new Vector3f((float)(center.f_82479_ + offset.f_82479_), (float)(center.f_82480_ + offset.f_82480_), (float)(center.f_82481_ + offset.f_82481_));
            ring.normals[i] = new Vector3f((float)offset.f_82479_, (float)offset.f_82480_, (float)offset.f_82481_).normalize();
            ring.uvs[i] = new Vector2f((float)i / 8.0f, 0.0f);
        }
        return ring;
    }

    public static void renderFunnel(Matrix4f matrix4f, Matrix3f matrix3f, int light, MultiBufferSource buffer, Vec3[] segments, float partial, int packedColor, float sizeA, ResourceLocation location) {
        if (segments == null || segments.length < 2) {
            return;
        }
        Ring previousRing = null;
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)location));
        for (int i = 1; i < segments.length; ++i) {
            Vec3 from = segments[i - 1];
            Vec3 to = segments[i];
            Vec3 dir = to.m_82546_(from).m_82541_();
            float size = SpecialEffects.calculateSize(i, segments.length, sizeA);
            float segmentProgress = (float)i / (float)segments.length;
            float rotation = partial + segmentProgress * 4.0f;
            Ring currentRing = SpecialEffects.buildRing(to, dir, size, rotation);
            if (previousRing != null) {
                SpecialEffects.stitchRings(previousRing, currentRing, consumer, matrix4f, matrix3f, packedColor, light, OverlayTexture.f_118083_);
            }
            previousRing = currentRing;
        }
    }

    private static void stitchRings(Ring a, Ring b, VertexConsumer consumer, Matrix4f matrix4f, Matrix3f matrix3f, int color, int light, int overlay) {
        for (int i = 0; i < 8; ++i) {
            int next = (i + 1) % 8;
            float vA = 0.0f;
            float vB = 1.0f;
            consumer.m_252986_(matrix4f, a.vertices[i].x, a.vertices[i].y, a.vertices[i].z).m_193479_(color).m_7421_(a.uvs[i].x, vA).m_86008_(overlay).m_85969_(light).m_252939_(matrix3f, a.normals[i].x(), a.normals[i].y(), a.normals[i].z()).m_5752_();
            consumer.m_252986_(matrix4f, a.vertices[next].x, a.vertices[next].y, a.vertices[next].z).m_193479_(color).m_7421_(a.uvs[next].x, vA).m_86008_(overlay).m_85969_(light).m_252939_(matrix3f, a.normals[next].x(), a.normals[next].y(), a.normals[next].z()).m_5752_();
            consumer.m_252986_(matrix4f, b.vertices[next].x, b.vertices[next].y, b.vertices[next].z).m_193479_(color).m_7421_(b.uvs[next].x, vB).m_86008_(overlay).m_85969_(light).m_252939_(matrix3f, b.normals[next].x(), b.normals[next].y(), b.normals[next].z()).m_5752_();
            consumer.m_252986_(matrix4f, b.vertices[i].x, b.vertices[i].y, b.vertices[i].z).m_193479_(color).m_7421_(b.uvs[i].x, vB).m_86008_(overlay).m_85969_(light).m_252939_(matrix3f, b.normals[i].x(), b.normals[i].y(), b.normals[i].z()).m_5752_();
        }
    }

    private static float calculateSize(int segmentIndex, int totalSegments, float inflation) {
        float progress = Mth.m_14036_((float)((float)segmentIndex / (float)(totalSegments - 1)), (float)0.0f, (float)1.0f);
        float startSize = 0.5f;
        float endSize = 3.0f;
        return (startSize + (endSize - startSize) * progress + 0.3f * Mth.m_14031_((float)(progress * (float)Math.PI))) * inflation;
    }

    public static class Ring {
        Vector3f[] vertices = new Vector3f[8];
        Vector3f[] normals = new Vector3f[8];
        Vector2f[] uvs = new Vector2f[8];
    }
}

