/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.VigilModel;
import com.Harbinger.Spore.Client.Models.VigilSignModel;
import com.Harbinger.Spore.Client.Renderers.OrganoidMobRenderer;
import com.Harbinger.Spore.Sentities.Organoids.Vigil;
import com.Harbinger.Spore.Sentities.Variants.VigilVariants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VigilRenderer<Type extends Vigil>
extends OrganoidMobRenderer<Type, EntityModel<Type>> {
    private final EntityModel<Type> defaultModel = this.m_7200_();
    private final EntityModel<Type> alterModel;
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/vigil.png");
    private static final ResourceLocation STALKER = new ResourceLocation("spore", "textures/entity/vigil_stalker.png");

    public VigilRenderer(EntityRendererProvider.Context context) {
        super(context, new VigilModel(context.m_174023_(VigilModel.LAYER_LOCATION)), 1.0f);
        this.alterModel = new VigilSignModel<Type>(context.m_174023_(VigilSignModel.LAYER_LOCATION));
        this.m_115326_(new SignModel(this, context.m_234598_()));
    }

    @Override
    public void render(Type type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int value3) {
        this.f_115290_ = ((Vigil)type).getVariant() == VigilVariants.TROLL ? this.alterModel : this.defaultModel;
        super.render(type, value1, value2, stack, bufferSource, value3);
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return ((Vigil)entity).isStalker() ? STALKER : TEXTURE;
    }

    protected void scale(Type type, PoseStack stack, float value) {
        if (((Vigil)type).isStalker()) {
            stack.m_85841_(1.2f, 1.2f, 1.2f);
        }
        super.m_7546_(type, stack, value);
    }

    private static class SignModel<T extends Vigil, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private final ItemInHandRenderer itemInHandRenderer;

        public SignModel(RenderLayerParent<T, M> renderLayerParent, ItemInHandRenderer itemInHandRenderer) {
            super(renderLayerParent);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            EntityModel entityModel;
            if (((Vigil)t).getVariant() == VigilVariants.TROLL && (entityModel = this.m_117386_()) instanceof VigilSignModel) {
                VigilSignModel signModel = (VigilSignModel)entityModel;
                ItemStack stack = new ItemStack((ItemLike)Items.f_42438_);
                poseStack.m_85836_();
                for (ModelPart part : signModel.getArms()) {
                    part.m_104299_(poseStack);
                }
                poseStack.m_252880_(0.3f, 0.1f, -0.4f);
                poseStack.m_85841_(2.25f, 2.25f, 2.25f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-180.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                this.itemInHandRenderer.m_269530_(t, stack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, true, poseStack, multiBufferSource, i);
                poseStack.m_85849_();
            }
        }
    }
}

