/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.VanguardArrowLayerModel;
import com.Harbinger.Spore.Client.Models.VanguardModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.Utility.Vanguard;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VanguardRenderer<Type extends Vanguard>
extends BaseInfectedRenderer<Type, VanguardModel<Type>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/vanguard.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/vanguard.png");

    public VanguardRenderer(EntityRendererProvider.Context context) {
        super(context, new VanguardModel(context.m_174023_(VanguardModel.LAYER_LOCATION)), 0.5f);
        this.m_115326_(new VanguardCrossbowHold(this, context.m_234598_()));
        this.m_115326_(new VanguardArrowLayer(this));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    private static class VanguardCrossbowHold<T extends Vanguard, M extends VanguardModel<T>>
    extends RenderLayer<T, M> {
        private final ItemInHandRenderer itemInHandRenderer;
        private static final ItemStack itemStack = new ItemStack((ItemLike)Items.f_42688_);
        private static final ItemStack FLINT = new ItemStack((ItemLike)Items.f_42409_);
        private static final ItemStack HORN = new ItemStack((ItemLike)Items.f_220219_);

        public VanguardCrossbowHold(RenderLayerParent<T, M> renderLayerParent, ItemInHandRenderer itemInHandRenderer) {
            super(renderLayerParent);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            if (t.m_20145_()) {
                return;
            }
            ItemStack stack = t.m_21120_(InteractionHand.MAIN_HAND);
            poseStack.m_85836_();
            for (ModelPart part : ((VanguardModel)this.m_117386_()).partList) {
                part.m_104299_(poseStack);
            }
            poseStack.m_252880_(-0.15f, 0.4f, 0.1f);
            poseStack.m_85841_(1.25f, 1.25f, 1.25f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-180.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            this.itemInHandRenderer.m_269530_(t, stack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, true, poseStack, multiBufferSource, i);
            poseStack.m_85849_();
            ItemStack leftStack = t.m_21120_(InteractionHand.OFF_HAND);
            poseStack.m_85836_();
            for (ModelPart part : ((VanguardModel)this.m_117386_()).partList) {
                part.m_104299_(poseStack);
            }
            poseStack.m_252880_(0.05f, 0.55f, 0.1f);
            poseStack.m_85841_(1.25f, 1.25f, 1.25f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            this.itemInHandRenderer.m_269530_(t, leftStack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, true, poseStack, multiBufferSource, i);
            poseStack.m_85849_();
            poseStack.m_85836_();
            for (ModelPart part : ((VanguardModel)this.m_117386_()).pouchPartList) {
                part.m_104299_(poseStack);
            }
            poseStack.m_85837_(-0.2, 0.35, 0.55);
            poseStack.m_85841_(1.25f, 1.25f, 1.25f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            this.itemInHandRenderer.m_269530_(t, itemStack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, true, poseStack, multiBufferSource, i);
            poseStack.m_85849_();
            poseStack.m_85836_();
            for (ModelPart part : ((VanguardModel)this.m_117386_()).torsoPartList) {
                part.m_104299_(poseStack);
            }
            poseStack.m_85841_(1.25f, 1.25f, 1.25f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -0.1, 0.25);
            this.itemInHandRenderer.m_269530_(t, FLINT, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, true, poseStack, multiBufferSource, i);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -0.1, -0.35);
            this.itemInHandRenderer.m_269530_(t, HORN, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, true, poseStack, multiBufferSource, i);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    private static class VanguardArrowLayer<T extends Vanguard, M extends VanguardModel<T>>
    extends RenderLayer<T, M> {
        private final VanguardArrowLayerModel<T> model = new VanguardArrowLayerModel();
        private static final ResourceLocation ARROW_LOCATION = new ResourceLocation("minecraft:textures/entity/projectiles/arrow.png");

        public VanguardArrowLayer(RenderLayerParent<T, M> renderer) {
            super(renderer);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            if (t.m_20145_()) {
                return;
            }
            VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)ARROW_LOCATION));
            this.model.m_7695_(poseStack, vertexconsumer, i, LivingEntityRenderer.m_115338_(t, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

