/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.NaiadModel;
import com.Harbinger.Spore.Client.Models.NaiadTritonModel;
import com.Harbinger.Spore.Client.Models.TridentNaiadCharge;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Naiad;
import com.Harbinger.Spore.Sentities.Variants.NaiadVariants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NaiadRenderer<Type extends Naiad>
extends BaseInfectedRenderer<Type, EntityModel<Type>> {
    private final EntityModel<Type> defaultModel = this.m_7200_();
    private final EntityModel<Type> triton;
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/naiad.png");
    private static final ResourceLocation NAIAD_TRITON = new ResourceLocation("spore", "textures/entity/naiad_triton.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/naiad.png");

    public NaiadRenderer(EntityRendererProvider.Context context) {
        super(context, new NaiadModel(context.m_174023_(NaiadModel.LAYER_LOCATION)), 1.0f);
        this.triton = new NaiadTritonModel<Type>(context.m_174023_(NaiadTritonModel.LAYER_LOCATION));
        this.m_115326_(new NaiadChargeRenderer(this));
    }

    protected void scale(Type type, PoseStack poseStack, float p_115316_) {
        float value = ((Naiad)type).getVariant() == NaiadVariants.TRITON ? 1.2f : 1.0f;
        poseStack.m_85841_(value, value, value);
        super.m_7546_(type, poseStack, p_115316_);
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return ((Naiad)entity).getVariant() == NaiadVariants.TRITON ? NAIAD_TRITON : TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    public void render(Type type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        this.f_115290_ = ((Naiad)type).getVariant() == NaiadVariants.TRITON ? this.triton : this.defaultModel;
        super.m_7392_(type, value1, value2, stack, bufferSource, light);
    }

    public class NaiadChargeRenderer<T extends Naiad>
    extends RenderLayer<T, EntityModel<T>> {
        private final TridentNaiadCharge<T> model;
        public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft:textures/entity/trident_riptide.png");

        public NaiadChargeRenderer(RenderLayerParent<T, EntityModel<T>> renderer) {
            super(renderer);
            this.model = new TridentNaiadCharge();
        }

        public void render(PoseStack stack, MultiBufferSource multiBufferSource, int value, T type, float v1, float v2, float v3, float v4, float v5, float v6) {
            if (((Naiad)type).isCharging() && ((Naiad)type).getVariant() == NaiadVariants.TRITON) {
                stack.m_85836_();
                stack.m_85837_(0.0, 0.5, 0.0);
                VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
                this.model.m_6839_((Entity)type, v1, v2, v3);
                this.model.setupAnim(type, v1, v2, v4, v5, v6);
                this.model.m_7695_(stack, vertexconsumer, value, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                stack.m_85849_();
            }
        }
    }
}

