/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Animations.VerwaAnimations;
import com.Harbinger.Spore.Sentities.Organoids.Verwa;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class verwahrungModel<T extends Verwa>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("spore", "verwahrung"), "main");
    private final ModelPart SporePod;
    private final ModelPart BaseTumor;
    private final ModelPart Petals;
    private final ModelPart TopJaw;
    private final ModelPart BottomJaw;

    public verwahrungModel(ModelPart root) {
        this.SporePod = root.m_171324_("SporePod");
        this.BaseTumor = this.SporePod.m_171324_("TumorBase");
        this.Petals = this.SporePod.m_171324_("Base").m_171324_("Petals");
        this.TopJaw = this.SporePod.m_171324_("Base").m_171324_("Jaw").m_171324_("TopJawJoint");
        this.BottomJaw = this.SporePod.m_171324_("Base").m_171324_("Jaw").m_171324_("BottomJawJoint");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition SporePod = partdefinition.m_171599_("SporePod", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.85f, (float)24.0f, (float)-3.0f));
        PartDefinition TumorBase = SporePod.m_171599_("TumorBase", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0062f, (float)-1.7921f, (float)4.1882f));
        PartDefinition Biomass_r1 = TumorBase.m_171599_("Biomass_r1", CubeListBuilder.m_171558_().m_171514_(2, 1).m_171488_(-5.5f, -5.5f, -5.5f, 11.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.8989f, (float)-0.1307f, (float)0.8938f, (float)0.2392f, (float)-0.0133f, (float)-0.3783f));
        PartDefinition Biomass_r2 = TumorBase.m_171599_("Biomass_r2", CubeListBuilder.m_171558_().m_171514_(4, 2).m_171488_(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.7817f, (float)0.206f, (float)8.7818f, (float)1.361f, (float)0.0565f, (float)-1.1111f));
        PartDefinition Biomass_r3 = TumorBase.m_171599_("Biomass_r3", CubeListBuilder.m_171558_().m_171514_(8, 4).m_171488_(3.0f, -3.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.6765f, (float)1.6273f, (float)-4.3262f, (float)0.4094f, (float)0.4032f, (float)-0.6728f));
        PartDefinition Biomass_r4 = TumorBase.m_171599_("Biomass_r4", CubeListBuilder.m_171558_().m_171514_(6, 3).m_171488_(-8.0f, -5.0f, 7.0f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5928f, (float)-3.8534f, (float)-6.2058f, (float)-0.5151f, (float)0.3039f, (float)0.5625f));
        PartDefinition Biomass_r5 = TumorBase.m_171599_("Biomass_r5", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -6.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0887f, (float)0.7284f, (float)-4.7513f, (float)-0.329f, (float)-1.0983f, (float)1.1961f));
        PartDefinition Base = SporePod.m_171599_("Base", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Petals = Base.m_171599_("Petals", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.85f, (float)-5.0f, (float)3.0f));
        PartDefinition Petal1 = Petals.m_171599_("Petal1", CubeListBuilder.m_171558_().m_171514_(8, 114).m_171488_(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.15f, (float)0.0f, (float)-5.5f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r1 = Petal1.m_171599_("Membrane_r1", CubeListBuilder.m_171558_().m_171514_(95, 92).m_171488_(1.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r2 = Petal1.m_171599_("Membrane_r2", CubeListBuilder.m_171558_().m_171514_(98, 7).m_171488_(-7.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal1Middle = Petal1.m_171599_("Petal1Middle", CubeListBuilder.m_171558_().m_171514_(0, 113).m_171488_(-0.99f, -11.75f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.0347f, (float)0.0245f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r3 = Petal1Middle.m_171599_("Membrane_r3", CubeListBuilder.m_171558_().m_171514_(100, 105).m_171488_(-7.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.9653f, (float)-0.0245f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Membrane_r4 = Petal1Middle.m_171599_("Membrane_r4", CubeListBuilder.m_171558_().m_171514_(14, 90).m_171488_(1.0f, -11.0f, 0.0f, 7.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.9653f, (float)-0.0245f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Petal1Top = Petal1Middle.m_171599_("Petal1Top", CubeListBuilder.m_171558_().m_171514_(32, 117).m_171488_(-1.0f, -11.5f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.7413f, (float)0.0578f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r5 = Petal1Top.m_171599_("Membrane_r5", CubeListBuilder.m_171558_().m_171514_(110, 0).m_171488_(1.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.224f, (float)-0.0823f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r6 = Petal1Top.m_171599_("Membrane_r6", CubeListBuilder.m_171558_().m_171514_(111, 31).m_171488_(-7.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.224f, (float)-0.0823f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition PetalTumor1 = Petal1Top.m_171599_("PetalTumor1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-12.0f, (float)1.0f));
        PartDefinition Tumors_r1 = PetalTumor1.m_171599_("Tumors_r1", CubeListBuilder.m_171558_().m_171514_(12, 12).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1237f, (float)0.6269f, (float)0.543f));
        PartDefinition Petal2 = Petals.m_171599_("Petal2", CubeListBuilder.m_171558_().m_171514_(8, 114).m_171488_(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.8563f, (float)0.0f, (float)-0.8541f, (float)0.48f, (float)-1.2566f, (float)0.0f));
        PartDefinition Membrane_r7 = Petal2.m_171599_("Membrane_r7", CubeListBuilder.m_171558_().m_171514_(95, 92).m_171488_(1.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0437f, (float)0.0f, (float)-0.1459f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r8 = Petal2.m_171599_("Membrane_r8", CubeListBuilder.m_171558_().m_171514_(98, 7).m_171488_(-7.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0437f, (float)0.0f, (float)-0.1459f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal2Middle = Petal2.m_171599_("Petal2Middle", CubeListBuilder.m_171558_().m_171514_(0, 113).m_171488_(-0.99f, -11.75f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.0347f, (float)0.0245f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r9 = Petal2Middle.m_171599_("Membrane_r9", CubeListBuilder.m_171558_().m_171514_(14, 90).m_171488_(1.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0437f, (float)-0.9653f, (float)-0.1704f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r10 = Petal2Middle.m_171599_("Membrane_r10", CubeListBuilder.m_171558_().m_171514_(99, 105).m_171488_(-8.0f, -11.0f, 0.0f, 7.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0437f, (float)-0.9653f, (float)-0.1704f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal2Top = Petal2Middle.m_171599_("Petal2Top", CubeListBuilder.m_171558_().m_171514_(32, 117).m_171488_(-1.0f, -11.5f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.7413f, (float)0.0578f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r11 = Petal2Top.m_171599_("Membrane_r11", CubeListBuilder.m_171558_().m_171514_(110, 0).m_171488_(1.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0437f, (float)-1.224f, (float)-0.2282f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r12 = Petal2Top.m_171599_("Membrane_r12", CubeListBuilder.m_171558_().m_171514_(111, 31).m_171488_(-7.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0437f, (float)-1.224f, (float)-0.2282f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition PetalTumor2 = Petal2Top.m_171599_("PetalTumor2", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.7063f, (float)-12.0f, (float)0.3541f, (float)0.3054f, (float)-0.48f, (float)0.0f));
        PartDefinition Tumors_r2 = PetalTumor2.m_171599_("Tumors_r2", CubeListBuilder.m_171558_().m_171514_(12, 12).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.102f, (float)0.1932f, (float)0.4899f));
        PartDefinition Petal2TopFungus = Petal2Top.m_171599_("Petal2TopFungus", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0843f, (float)-5.0632f, (float)0.4243f));
        PartDefinition Fungus_r1 = Petal2TopFungus.m_171599_("Fungus_r1", CubeListBuilder.m_171558_().m_171514_(-7, 31).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.6907f, (float)-2.2108f, (float)-1.6025f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r2 = Petal2TopFungus.m_171599_("Fungus_r2", CubeListBuilder.m_171558_().m_171514_(-7, 24).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.1907f, (float)-0.2108f, (float)-0.6025f, (float)-0.1797f, (float)-0.4891f, (float)0.195f));
        PartDefinition Fungus_r3 = Petal2TopFungus.m_171599_("Fungus_r3", CubeListBuilder.m_171558_().m_171514_(-7, 38).m_171488_(-4.25f, -1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4407f, (float)2.0392f, (float)-1.1025f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        PartDefinition Fungus_r4 = Petal2TopFungus.m_171599_("Fungus_r4", CubeListBuilder.m_171558_().m_171514_(-7, 38).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4407f, (float)3.0392f, (float)-1.1025f, (float)0.1783f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition Petal3 = Petals.m_171599_("Petal3", CubeListBuilder.m_171558_().m_171514_(8, 114).m_171488_(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.6767f, (float)0.0f, (float)5.8541f, (float)-2.6616f, (float)-0.6283f, (float)3.1416f));
        PartDefinition Membrane_r13 = Petal3.m_171599_("Membrane_r13", CubeListBuilder.m_171558_().m_171514_(95, 92).m_171488_(1.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0267f, (float)0.0f, (float)-0.3541f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r14 = Petal3.m_171599_("Membrane_r14", CubeListBuilder.m_171558_().m_171514_(98, 7).m_171488_(-7.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0267f, (float)0.0f, (float)-0.3541f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal3Middle = Petal3.m_171599_("Petal3Middle", CubeListBuilder.m_171558_().m_171514_(0, 113).m_171488_(-0.99f, -11.75f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.0347f, (float)0.0245f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r15 = Petal3Middle.m_171599_("Membrane_r15", CubeListBuilder.m_171558_().m_171514_(100, 105).m_171488_(-7.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.1233f, (float)-0.9653f, (float)-0.3786f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Membrane_r16 = Petal3Middle.m_171599_("Membrane_r16", CubeListBuilder.m_171558_().m_171514_(14, 90).m_171488_(1.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.1233f, (float)-0.9653f, (float)-0.3786f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Petal3Top = Petal3Middle.m_171599_("Petal3Top", CubeListBuilder.m_171558_().m_171514_(32, 114).m_171488_(-1.0f, -11.5f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.7413f, (float)0.0578f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r17 = Petal3Top.m_171599_("Membrane_r17", CubeListBuilder.m_171558_().m_171514_(110, 0).m_171488_(1.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0267f, (float)-1.224f, (float)-0.9364f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r18 = Petal3Top.m_171599_("Membrane_r18", CubeListBuilder.m_171558_().m_171514_(111, 31).m_171488_(-7.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0267f, (float)-1.224f, (float)-0.9364f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition PetalTumor3 = Petal3Top.m_171599_("PetalTumor3", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.703f, (float)-11.1962f, (float)0.4198f, (float)0.4638f, (float)-0.3305f, (float)-0.3961f));
        PartDefinition Tumors_r3 = PetalTumor3.m_171599_("Tumors_r3", CubeListBuilder.m_171558_().m_171514_(12, 12).m_171488_(-2.0f, -2.0f, -3.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0994f, (float)-0.6744f, (float)0.5342f, (float)0.102f, (float)0.1932f, (float)0.4899f));
        PartDefinition Petal4 = Petals.m_171599_("Petal4", CubeListBuilder.m_171558_().m_171514_(8, 114).m_171488_(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.3767f, (float)0.0f, (float)5.8541f, (float)-2.6616f, (float)0.6283f, (float)3.1416f));
        PartDefinition Membrane_r19 = Petal4.m_171599_("Membrane_r19", CubeListBuilder.m_171558_().m_171514_(95, 92).m_171488_(1.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0267f, (float)0.0f, (float)-0.3541f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r20 = Petal4.m_171599_("Membrane_r20", CubeListBuilder.m_171558_().m_171514_(98, 7).m_171488_(-7.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0267f, (float)0.0f, (float)-0.3541f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal4Middle = Petal4.m_171599_("Petal4Middle", CubeListBuilder.m_171558_().m_171514_(0, 113).m_171488_(-0.99f, -11.75f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.0347f, (float)0.0245f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r21 = Petal4Middle.m_171599_("Membrane_r21", CubeListBuilder.m_171558_().m_171514_(100, 105).m_171488_(-7.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0267f, (float)-0.9653f, (float)-0.6286f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Membrane_r22 = Petal4Middle.m_171599_("Membrane_r22", CubeListBuilder.m_171558_().m_171514_(14, 90).m_171488_(1.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0267f, (float)-0.9653f, (float)-0.6286f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Petal4Top = Petal4Middle.m_171599_("Petal4Top", CubeListBuilder.m_171558_().m_171514_(32, 115).m_171488_(-1.0f, -11.5f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.7413f, (float)0.0578f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r23 = Petal4Top.m_171599_("Membrane_r23", CubeListBuilder.m_171558_().m_171514_(110, 0).m_171488_(1.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0267f, (float)-0.974f, (float)-0.9364f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r24 = Petal4Top.m_171599_("Membrane_r24", CubeListBuilder.m_171558_().m_171514_(111, 31).m_171488_(-7.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0267f, (float)-0.974f, (float)-0.9364f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition PetalTumor4Sub1 = Petal4Top.m_171599_("PetalTumor4Sub1", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.7565f, (float)-11.1962f, (float)0.4198f, (float)0.562f, (float)-0.0231f, (float)-0.935f));
        PartDefinition Tumors_r4 = PetalTumor4Sub1.m_171599_("Tumors_r4", CubeListBuilder.m_171558_().m_171514_(12, 12).m_171488_(-1.0f, -1.0f, -3.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0994f, (float)-0.6744f, (float)0.5342f, (float)0.102f, (float)0.1932f, (float)0.4899f));
        PartDefinition PetalTumor4Sub2 = Petal4Top.m_171599_("PetalTumor4Sub2", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.7467f, (float)-11.3437f, (float)0.2392f, (float)0.7093f, (float)0.1835f, (float)-1.2706f));
        PartDefinition Tumors_r5 = PetalTumor4Sub2.m_171599_("Tumors_r5", CubeListBuilder.m_171558_().m_171514_(12, 12).m_171488_(0.0f, 0.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.2981f, (float)-2.0231f, (float)1.6025f, (float)0.102f, (float)0.1932f, (float)0.4899f));
        PartDefinition Petal4BaseFungus = Petal4.m_171599_("Petal4BaseFungus", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.8174f, (float)-6.8392f, (float)0.7984f));
        PartDefinition Fungus_r5 = Petal4BaseFungus.m_171599_("Fungus_r5", CubeListBuilder.m_171558_().m_171514_(-7, 38).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.6907f, (float)-2.2108f, (float)-1.6025f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r6 = Petal4BaseFungus.m_171599_("Fungus_r6", CubeListBuilder.m_171558_().m_171514_(-7, 24).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.1907f, (float)-0.2108f, (float)-0.6025f, (float)-0.1797f, (float)-0.4891f, (float)0.195f));
        PartDefinition Fungus_r7 = Petal4BaseFungus.m_171599_("Fungus_r7", CubeListBuilder.m_171558_().m_171514_(-7, 31).m_171488_(-4.25f, -1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4407f, (float)2.0392f, (float)-1.1025f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        PartDefinition Fungus_r8 = Petal4BaseFungus.m_171599_("Fungus_r8", CubeListBuilder.m_171558_().m_171514_(-7, 31).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4407f, (float)3.0392f, (float)-1.1025f, (float)0.1783f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition Petal5 = Petals.m_171599_("Petal5", CubeListBuilder.m_171558_().m_171514_(8, 114).m_171488_(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5231f, (float)0.0f, (float)-0.9534f, (float)0.48f, (float)1.2392f, (float)0.0f));
        PartDefinition Membrane_r25 = Petal5.m_171599_("Membrane_r25", CubeListBuilder.m_171558_().m_171514_(98, 7).m_171488_(-7.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.1731f, (float)0.0f, (float)-0.5466f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Membrane_r26 = Petal5.m_171599_("Membrane_r26", CubeListBuilder.m_171558_().m_171514_(95, 92).m_171488_(1.0f, -11.0f, 0.0f, 6.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.1731f, (float)0.0f, (float)-0.5466f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Petal5Middle = Petal5.m_171599_("Petal5Middle", CubeListBuilder.m_171558_().m_171514_(0, 113).m_171488_(-0.99f, -11.75f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.0347f, (float)0.0245f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r27 = Petal5Middle.m_171599_("Membrane_r27", CubeListBuilder.m_171558_().m_171514_(14, 90).m_171488_(1.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0769f, (float)-0.9653f, (float)-0.8211f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r28 = Petal5Middle.m_171599_("Membrane_r28", CubeListBuilder.m_171558_().m_171514_(100, 105).m_171488_(-7.0f, -11.0f, 0.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0769f, (float)-0.9653f, (float)-0.8211f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Petal5Top = Petal5Middle.m_171599_("Petal5Top", CubeListBuilder.m_171558_().m_171514_(32, 117).m_171488_(-1.0f, -11.5f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.7413f, (float)0.0578f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Membrane_r29 = Petal5Top.m_171599_("Membrane_r29", CubeListBuilder.m_171558_().m_171514_(110, 0).m_171488_(1.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0269f, (float)-0.974f, (float)-1.1289f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Membrane_r30 = Petal5Top.m_171599_("Membrane_r30", CubeListBuilder.m_171558_().m_171514_(111, 31).m_171488_(-7.0f, -10.0f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0269f, (float)-0.974f, (float)-1.1289f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition PetalTumor5 = Petal5Top.m_171599_("PetalTumor5", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.9029f, (float)-13.1962f, (float)2.2273f));
        PartDefinition Tumors_r6 = PetalTumor5.m_171599_("Tumors_r6", CubeListBuilder.m_171558_().m_171514_(12, 12).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)-1.0994f, (float)0.3256f, (float)-0.4658f, (float)0.2451f, (float)0.6705f, (float)0.231f));
        PartDefinition Petal5MiddleFungus = Petal5Middle.m_171599_("Petal5MiddleFungus", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.4638f, (float)-5.8045f, (float)0.5814f));
        PartDefinition Fungus_r9 = Petal5MiddleFungus.m_171599_("Fungus_r9", CubeListBuilder.m_171558_().m_171514_(-7, 31).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.3093f, (float)-4.2108f, (float)-1.6025f, (float)0.3325f, (float)0.5154f, (float)0.0523f));
        PartDefinition Fungus_r10 = Petal5MiddleFungus.m_171599_("Fungus_r10", CubeListBuilder.m_171558_().m_171514_(-7, 24).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.1907f, (float)-1.2108f, (float)-0.6025f, (float)-0.1797f, (float)-0.4891f, (float)0.195f));
        PartDefinition Fungus_r11 = Petal5MiddleFungus.m_171599_("Fungus_r11", CubeListBuilder.m_171558_().m_171514_(-7, 31).m_171488_(-4.25f, -1.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4407f, (float)2.0392f, (float)-1.1025f, (float)0.0333f, (float)0.6219f, (float)0.3593f));
        PartDefinition Fungus_r12 = Petal5MiddleFungus.m_171599_("Fungus_r12", CubeListBuilder.m_171558_().m_171514_(-7, 38).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4407f, (float)3.0392f, (float)-1.1025f, (float)0.1783f, (float)-0.2977f, (float)-0.0909f));
        PartDefinition Jaw = Base.m_171599_("Jaw", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)4.8576f, (float)-5.1743f, (float)5.0f, (float)1.5708f, (float)-1.4835f, (float)-3.1416f));
        PartDefinition TopJawJoint = Jaw.m_171599_("TopJawJoint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)3.0f));
        PartDefinition TopJaw = TopJawJoint.m_171599_("TopJaw", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.3838f, (float)1.1721f, (float)0.8621f, (float)-0.829f, (float)0.0f, (float)0.0f));
        PartDefinition HeadLeftTeeth_r1 = TopJaw.m_171599_("HeadLeftTeeth_r1", CubeListBuilder.m_171558_().m_171514_(71, 85).m_171480_().m_171488_(-2.75f, 3.35f, -4.0f, 8.0f, 2.0f, 3.0f, new CubeDeformation(-0.2f)).m_171555_(false).m_171514_(56, 56).m_171488_(-2.75f, -3.25f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)5.5847f, (float)0.1825f, (float)-6.2745f, (float)-0.1372f, (float)-0.0042f, (float)0.4948f));
        PartDefinition HeadCenter_r1 = TopJaw.m_171599_("HeadCenter_r1", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171488_(-5.5f, -3.0f, -4.5f, 8.0f, 6.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)1.7894f, (float)-1.0826f, (float)-5.7788f, (float)0.1309f, (float)0.0f, (float)0.0436f));
        PartDefinition HeadRightTeeth_r1 = TopJaw.m_171599_("HeadRightTeeth_r1", CubeListBuilder.m_171558_().m_171514_(71, 85).m_171488_(-4.0f, 0.6f, -2.75f, 8.0f, 2.0f, 3.0f, new CubeDeformation(-0.2f)).m_171514_(24, 71).m_171488_(-4.0f, -5.0f, -2.75f, 8.0f, 6.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)-5.597f, (float)1.5661f, (float)-7.0181f, (float)0.1309f, (float)0.0f, (float)-0.3491f));
        PartDefinition BottomJawJoint = Jaw.m_171599_("BottomJawJoint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.6315f, (float)1.8279f, (float)2.8621f));
        PartDefinition BottomJaw = BottomJawJoint.m_171599_("BottomJaw", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6906f, (float)-0.1119f, (float)0.1343f));
        PartDefinition HeadLeft_r1 = BottomJaw.m_171599_("HeadLeft_r1", CubeListBuilder.m_171558_().m_171514_(24, 56).m_171488_(-2.75f, -3.75f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)5.5847f, (float)-0.1825f, (float)-6.2745f, (float)-0.0555f, (float)-0.1071f, (float)-0.484f));
        PartDefinition HeadCenter_r2 = BottomJaw.m_171599_("HeadCenter_r2", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-5.5f, -2.75f, -4.5f, 8.0f, 7.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)1.7894f, (float)1.0826f, (float)-5.7788f, (float)-0.1309f, (float)0.0f, (float)-0.0436f));
        PartDefinition HeadRightTeeth_r2 = BottomJaw.m_171599_("HeadRightTeeth_r2", CubeListBuilder.m_171558_().m_171514_(71, 85).m_171488_(-4.0f, -1.0f, -1.5f, 8.0f, 2.0f, 3.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)-5.5951f, (float)-1.5804f, (float)-8.277f, (float)0.1309f, (float)0.0f, (float)-3.0107f));
        PartDefinition HeadRight_r1 = BottomJaw.m_171599_("HeadRight_r1", CubeListBuilder.m_171558_().m_171514_(67, 25).m_171488_(-4.0f, 0.75f, -2.75f, 8.0f, 6.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)-5.597f, (float)-1.5661f, (float)-7.0181f, (float)-0.1309f, (float)0.0f, (float)0.1309f));
        PartDefinition InternalDetails = Base.m_171599_("InternalDetails", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-5.0f, (float)4.0f));
        PartDefinition Plane_r1 = InternalDetails.m_171599_("Plane_r1", CubeListBuilder.m_171558_().m_171514_(0, 131).m_171488_(-10.0f, -9.0f, 0.0f, 20.0f, 18.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.15f, (float)-8.0f, (float)0.0f, (float)-3.0107f, (float)-1.0472f, (float)3.1416f));
        PartDefinition Plane_r2 = InternalDetails.m_171599_("Plane_r2", CubeListBuilder.m_171558_().m_171514_(0, 131).m_171480_().m_171488_(-10.0f, -9.0f, 0.0f, 20.0f, 18.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.15f, (float)-8.0f, (float)0.0f, (float)-0.0873f, (float)-0.9599f, (float)0.0f));
        PartDefinition Plane_r3 = InternalDetails.m_171599_("Plane_r3", CubeListBuilder.m_171558_().m_171514_(0, 131).m_171488_(-10.0f, -9.0f, 0.0f, 20.0f, 18.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.15f, (float)-8.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)-0.0873f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    private void animateTumor(ModelPart part, float value) {
        part.f_233553_ = 1.0f + Mth.m_14089_((float)(value / 7.0f)) / 7.0f;
        part.f_233554_ = 1.0f + Mth.m_14089_((float)(value / 7.0f)) / 7.0f;
        part.f_233555_ = 1.0f + Mth.m_14089_((float)(value / 7.0f)) / 7.0f;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.ScaleModel(entity, this.SporePod);
        this.m_233385_(((Verwa)((Object)entity)).burst, VerwaAnimations.BURST, ageInTicks, 1.0f);
        this.animateTumor(this.BaseTumor, ageInTicks);
        this.Petals.f_104203_ = Mth.m_14089_((float)(ageInTicks / 10.0f)) / 10.0f;
        this.Petals.f_104205_ = Mth.m_14089_((float)(ageInTicks / 10.0f)) / 10.0f;
        this.TopJaw.f_104203_ = Mth.m_14089_((float)(ageInTicks / 7.0f)) / 7.0f;
        this.BottomJaw.f_104203_ = -this.TopJaw.f_104203_;
    }

    private void ScaleModel(T type, ModelPart part) {
        Entity entity = ((Verwa)((Object)type)).getStoredEntity();
        if (entity.m_20205_() > type.m_20205_()) {
            float w = entity.m_20205_();
            part.f_233553_ = w - 0.3f;
            part.f_233555_ = w - 0.3f;
        }
        if (entity.m_20206_() > type.m_20206_()) {
            float h = entity.m_20206_();
            part.f_233554_ = h - 1.0f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.SporePod.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.SporePod;
    }
}

