/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.ArmorParts;

import com.Harbinger.Spore.Client.ArmorParts.ComplexHandModelItem;
import com.Harbinger.Spore.Client.Models.SyringeGunModel;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Sitems.SyringeGun;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SyringeGunPart
extends ComplexHandModelItem {
    private final SyringeGunModel<LivingEntity> parentModel;
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore:textures/item/syringe_gun_juice.png");
    private static final ResourceLocation TEXTURES = new ResourceLocation("spore:textures/item/syringe_gun_syringe.png");

    public SyringeGunPart(InteractionHand slot, SyringeGunModel<LivingEntity> model, ModelPart part, float x, float y, float z, float expand, float xspin, float yspin, float zspin) {
        super(slot, (Item)Sitems.SYRINGE_GUN.get(), model, part, x, y, z, expand, xspin, yspin, zspin);
        this.parentModel = model;
    }

    @Override
    public RenderType type(ResourceLocation location) {
        return RenderType.m_110473_((ResourceLocation)location);
    }

    @Override
    public void renderCustomHand(LivingEntity livingEntity, ItemStack stack, float partialTicks, int light, MultiBufferSource bufferSource, PoseStack poseStack, ResourceLocation location) {
        super.renderCustomHand(livingEntity, stack, partialTicks, light, bufferSource, poseStack, location);
        Item item = stack.m_41720_();
        if (item instanceof SyringeGun) {
            SyringeGun syringeGun = (SyringeGun)item;
            NonNullList<Integer> clipColors = syringeGun.getClip(stack);
            SyringeGunPart.applyTransformEx(poseStack, this.x, this.y, this.z, this.expand, this.Xspin, this.Yspin, this.Zspin, () -> {
                this.handleColorRendering(this.parentModel.syringe, (Integer)clipColors.get(0), poseStack, bufferSource, light);
                this.handleColorRendering(this.parentModel.syringe2, (Integer)clipColors.get(1), poseStack, bufferSource, light);
                this.handleColorRendering(this.parentModel.syringe3, (Integer)clipColors.get(2), poseStack, bufferSource, light);
                this.handleColorRendering(this.parentModel.syringe4, (Integer)clipColors.get(3), poseStack, bufferSource, light);
            });
        }
    }

    public void handleColorRendering(ModelPart syringe, int color, PoseStack stack, MultiBufferSource source, int light) {
        if (color == 0) {
            return;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        VertexConsumer consumer = source.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        VertexConsumer consumerS = source.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURES));
        stack.m_85836_();
        this.parentModel.syringeGun.m_104299_(stack);
        this.parentModel.magazine.m_104299_(stack);
        if (color != -1) {
            syringe.m_104306_(stack, consumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
        }
        syringe.m_104301_(stack, consumerS, light, OverlayTexture.f_118083_);
        stack.m_85849_();
    }
}

