/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.AnimationTrackers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SGReloadAnimationTracker {
    private static final Map<UUID, MagazineRotationState> rotationStates = new HashMap<UUID, MagazineRotationState>();

    public static void triggerRotationToChamber(Player player, int chamberIndex, int duration) {
        UUID playerId = player.m_20148_();
        MagazineRotationState prevState = rotationStates.get(playerId);
        float startRot = prevState != null ? prevState.currentRotation : 0.0f;
        float targetRot = (float)chamberIndex * 90.0f;
        MagazineRotationState newState = new MagazineRotationState(startRot, targetRot, duration);
        rotationStates.put(playerId, newState);
    }

    public static float getCurrentRotation(Player player, float partialTicks) {
        MagazineRotationState state = rotationStates.get(player.m_20148_());
        if (state == null) {
            return 0.0f;
        }
        if (state.animationTicks <= 0) {
            return state.currentRotation;
        }
        float progress = 1.0f - ((float)state.animationTicks - partialTicks) / (float)state.maxAnimationTicks;
        progress = SGReloadAnimationTracker.easeInOutCubic(progress);
        float delta = SGReloadAnimationTracker.shortestAngleDelta(state.startRotation, state.targetRotation);
        return SGReloadAnimationTracker.normalizeAngle(state.startRotation + delta * progress);
    }

    public static void tickAll() {
        rotationStates.forEach((id, state) -> {
            if (state.animationTicks > 0) {
                --state.animationTicks;
                if (state.animationTicks <= 0) {
                    state.startRotation = state.currentRotation = SGReloadAnimationTracker.normalizeAngle(state.targetRotation);
                    state.targetRotation = state.currentRotation;
                }
            }
        });
    }

    private static float shortestAngleDelta(float from, float to) {
        float delta = SGReloadAnimationTracker.normalizeAngle(to) - SGReloadAnimationTracker.normalizeAngle(from);
        if (delta > 180.0f) {
            delta -= 360.0f;
        }
        if (delta < -180.0f) {
            delta += 360.0f;
        }
        return delta;
    }

    private static float normalizeAngle(float angle) {
        return (angle % 360.0f + 360.0f) % 360.0f;
    }

    private static float easeInOutCubic(float x) {
        return x < 0.5f ? 4.0f * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0f;
    }

    public static class MagazineRotationState {
        public float startRotation;
        public float currentRotation;
        public float targetRotation;
        public int animationTicks;
        public int maxAnimationTicks;

        public MagazineRotationState(float startRot, float targetRot, int duration) {
            this.currentRotation = this.startRotation = SGReloadAnimationTracker.normalizeAngle(startRot);
            this.targetRotation = SGReloadAnimationTracker.normalizeAngle(targetRot);
            this.maxAnimationTicks = duration;
            this.animationTicks = duration;
        }
    }
}

