/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class FlintBlock
extends Block
implements IPistonMotionReact {
    private static final Long2ObjectMap<Direction> BY_NORMAL = (Long2ObjectMap)Arrays.stream(Direction.values()).collect(Collectors.toMap(direction -> new BlockPos(direction.m_122436_()).m_121878_(), direction -> direction, (direction, direction2) -> {
        throw new IllegalArgumentException("Duplicate keys");
    }, Long2ObjectOpenHashMap::new));

    public FlintBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onMoved(Level level, BlockPos pos, BlockState movedState, Direction direction, boolean extending) {
        BlockPos firePos;
        if (!extending && !level.f_46443_ && level.m_8055_(firePos = pos.m_121945_(direction)).m_60795_()) {
            for (Direction ironDir : Direction.values()) {
                BlockPos ironPos;
                BlockState facingState;
                if (ironDir.m_122434_() == direction.m_122434_() || !FlintBlock.canBlockCreateSpark(facingState = level.m_8055_(ironPos = firePos.m_121945_(ironDir)), level, ironPos, ironDir.m_122424_())) continue;
                this.ignitePosition(level, firePos, false);
                return;
            }
        }
    }

    private void ignitePosition(Level level, BlockPos firePos, boolean isIronMoving) {
        ModNetwork.CHANNEL.sendToAllClientPlayersInParticleRange(level, firePos, (Message)new ClientBoundParticlePacket(Vec3.m_82512_((Vec3i)firePos), ClientBoundParticlePacket.Type.FLINT_BLOCK_IGNITE, isIronMoving ? 1 : 0));
        for (Direction dir : Direction.values()) {
            if (!BaseFireBlock.m_49255_((Level)level, (BlockPos)firePos, (Direction)dir)) continue;
            level.m_46597_(firePos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)firePos));
            level.m_142346_(null, GameEvent.f_157797_, firePos);
            break;
        }
        this.playSound(level, firePos);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity le;
        if (!level.f_46443_ && entity instanceof LivingEntity && !(le = (LivingEntity)entity).m_20161_() && le.m_20142_() && le.f_19797_ % 2 == 0 && le.m_6844_(EquipmentSlot.FEET).m_204117_(ModTags.IGNITE_FLINT_BLOCKS) && level.m_8055_(pos.m_7494_()).m_60795_()) {
            this.ignitePosition(level, pos.m_7494_(), true);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public static boolean canBlockCreateSpark(BlockState state, Level level, BlockPos pos, Direction face) {
        return state.m_204336_(ModTags.FLINT_METALS) && state.m_60783_((BlockGetter)level, pos, face);
    }

    private void playSound(Level level, BlockPos pos) {
        RandomSource randomSource = level.m_213780_();
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, (randomSource.m_188501_() - randomSource.m_188501_()) * 0.2f + 1.0f);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block oldBlock, BlockPos targetPos, boolean isMoving) {
        super.m_6861_(state, level, pos, oldBlock, targetPos, isMoving);
        BlockState newState = level.m_8055_(targetPos);
        if (!newState.m_60795_() || !oldBlock.m_204297_().m_203656_(ModTags.FLINT_METALS)) {
            return;
        }
        Direction dir = (Direction)BY_NORMAL.get(pos.m_121996_((Vec3i)targetPos).m_121878_());
        for (Direction pistonDir : Direction.values()) {
            BlockState magnetState;
            if (dir.m_122434_() == pistonDir.m_122434_()) continue;
            BlockPos tilePos = targetPos.m_121945_(pistonDir);
            BlockEntity be = level.m_7702_(tilePos);
            if (be instanceof PistonMovingBlockEntity) {
                PistonMovingBlockEntity piston = (PistonMovingBlockEntity)be;
                if (piston.m_60392_() != pistonDir.m_122424_() || !piston.m_60400_().m_60713_(oldBlock) || !FlintBlock.canBlockCreateSpark(piston.m_60400_(), level, tilePos, dir)) continue;
                this.ignitePosition(level, targetPos, true);
                continue;
            }
            if (be == null || !CompatHandler.QUARK || (magnetState = QuarkCompat.getMagnetStateForFlintBlock(be, pistonDir)) == null || !magnetState.m_60713_(oldBlock) || !FlintBlock.canBlockCreateSpark(magnetState, level, tilePos, dir)) continue;
            this.ignitePosition(level, targetPos, true);
        }
    }
}

