/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.entities.SpectatorVision;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SpectatorVisionRenderer
extends EntityRenderer<SpectatorVision> {
    private static final Function<Integer, ResourceLocation> FUNCTION = integer -> Galosphere.id("textures/entity/spectator_vision/spectator_vision_" + integer + ".png");

    public SpectatorVisionRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SpectatorVision entity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        float sin = Mth.m_14031_((float)((float)entity.f_19797_ / 4.0f)) / 16.0f;
        poseStack.m_252880_(0.0f, sin, 0.0f);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity)));
        SpectatorVisionRenderer.vertex(vertexConsumer, matrix4f, matrix3f, i, 0.0f, 0, 0, 1);
        SpectatorVisionRenderer.vertex(vertexConsumer, matrix4f, matrix3f, i, 1.0f, 0, 1, 1);
        SpectatorVisionRenderer.vertex(vertexConsumer, matrix4f, matrix3f, i, 1.0f, 1, 1, 0);
        SpectatorVisionRenderer.vertex(vertexConsumer, matrix4f, matrix3f, i, 0.0f, 1, 0, 0);
        poseStack.m_85849_();
    }

    protected int getBlockLightLevel(SpectatorVision entity, BlockPos blockPos) {
        return entity.getPhase();
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, int i, float f, int j, int k, int l) {
        vertexConsumer.m_252986_(matrix4f, f - 0.5f, (float)j - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)k, (float)l).m_86008_(OverlayTexture.f_118083_).m_85969_(i).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(SpectatorVision entity) {
        return FUNCTION.apply(entity.getPhase() + 1);
    }
}

