/*
 * Decompiled with CFR 0.152.
 */
package lain.lib;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lain.lib.Retries;
import lain.lib.SharedPool;

public final class SimpleDownloader {
    private SimpleDownloader() {
        throw new Error("NoInstance");
    }

    private static Optional<URLConnection> connect(URL url, Proxy proxy, Consumer<URLConnection> preConnect, Consumer<Throwable> onException) {
        try {
            URLConnection conn;
            URLConnection uRLConnection = conn = proxy == null ? url.openConnection() : url.openConnection(proxy);
            if (preConnect != null) {
                preConnect.accept(conn);
            }
            conn.connect();
            return Optional.of(conn);
        }
        catch (Throwable e) {
            if (onException != null) {
                onException.accept(e);
            }
            return Optional.empty();
        }
    }

    private static boolean deleteIfExists(Path path, Consumer<Throwable> onException) {
        try {
            return Files.deleteIfExists(path);
        }
        catch (Throwable e) {
            if (onException != null) {
                onException.accept(e);
            }
            return false;
        }
    }

    private static <T extends Throwable> Consumer<T> deleteOnExceptionDecor(Path path, Consumer<T> onException) {
        Consumer<Throwable> deleteOnException = e -> SimpleDownloader.deleteIfExists(path, SimpleDownloader::rethrowIfNonIOException);
        return onException == null ? deleteOnException : deleteOnException.andThen(onException);
    }

    private static <T> Predicate<T> deleteOnFalseDecor(Path path, Predicate<T> predicate) {
        if (predicate == null) {
            return null;
        }
        return t -> {
            if (predicate.test(t)) {
                return true;
            }
            SimpleDownloader.deleteIfExists(path, SimpleDownloader::rethrowIfNonIOException);
            return false;
        };
    }

    private static Optional<Path> download(Path local, URLConnection conn, MessageDigest digest, Predicate<URLConnection> shouldTransfer, Consumer<Throwable> onException) {
        Optional<Path> optional;
        block11: {
            if (shouldTransfer != null && !shouldTransfer.test(conn)) {
                return Optional.empty();
            }
            FileChannel channel = FileChannel.open(local, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            try {
                channel.transferFrom(Channels.newChannel(digest == null ? conn.getInputStream() : new DigestInputStream(conn.getInputStream(), digest)), 0L, Long.MAX_VALUE);
                optional = Optional.of(local);
                if (channel == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (digest != null) {
                        digest.reset();
                    }
                    if (onException != null) {
                        onException.accept(e);
                    }
                    return Optional.empty();
                }
            }
            channel.close();
        }
        return optional;
    }

    private static Optional<URL> resource(String resource, Consumer<Throwable> onException) {
        try {
            return Optional.of(new URL(resource));
        }
        catch (Throwable e) {
            if (onException != null) {
                onException.accept(e);
            }
            return Optional.empty();
        }
    }

    private static void rethrowIfNonIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return;
        }
        Retries.rethrow(throwable);
    }

    private static void runAsync(Runnable runnable, Executor executor) {
        if (executor == null) {
            CompletableFuture.runAsync(runnable);
        } else {
            CompletableFuture.runAsync(runnable, executor);
        }
    }

    private static boolean sleep(long millis, Consumer<Throwable> onException) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (Throwable e) {
            if (onException != null) {
                onException.accept(e);
            }
            return false;
        }
    }

    public static CompletableFuture<Optional<Path>> start(String resource) {
        return SimpleDownloader.start(resource, null, null, 2, null, SharedPool::execute, null, null, null);
    }

    public static CompletableFuture<Optional<Path>> start(String resource, Path tempDir, Proxy proxy, int maxRetries, MessageDigest digest, Executor executor, Consumer<Thread> preExecute, Consumer<URLConnection> preConnect, Predicate<URLConnection> shouldTransfer) {
        Objects.requireNonNull(resource);
        CompletableFuture<Optional<Path>> future = new CompletableFuture<Optional<Path>>();
        SimpleDownloader.runAsync(() -> {
            try {
                if (!future.isDone()) {
                    if (preExecute != null) {
                        preExecute.accept(Thread.currentThread());
                    }
                    SimpleDownloader.resource(resource, future::completeExceptionally).ifPresent(remote -> Retries.retrying(() -> {
                        if (!future.isDone()) {
                            SimpleDownloader.connect(remote, proxy, preConnect, Retries::rethrow).ifPresent(conn -> SimpleDownloader.tempFile(tempDir, future::completeExceptionally).ifPresent(local -> SimpleDownloader.download(local, conn, digest, SimpleDownloader.deleteOnFalseDecor(local, shouldTransfer), SimpleDownloader.deleteOnExceptionDecor(local, Retries::rethrow)).ifPresent(result -> future.complete(Optional.of(result)))));
                        }
                    }, IOException.class::isInstance, retries -> SimpleDownloader.sleep(1000L, Retries::rethrow), maxRetries).toRunnable(future::completeExceptionally).run());
                }
            }
            finally {
                if (!future.isDone()) {
                    future.complete(Optional.empty());
                }
            }
        }, executor);
        return future;
    }

    private static Optional<Path> tempFile(Path tempDir, Consumer<Throwable> onException) {
        try {
            return Optional.of(tempDir == null ? Files.createTempFile(null, null, new FileAttribute[0]) : Files.createTempFile(tempDir, null, null, new FileAttribute[0]));
        }
        catch (Throwable e) {
            if (onException != null) {
                onException.accept(e);
            }
            return Optional.empty();
        }
    }
}

