/*
 * Decompiled with CFR 0.152.
 */
package com.kingcontaria.fastquit.mixin;

import com.kingcontaria.fastquit.FastQuit;
import com.kingcontaria.fastquit.FastQuitConfig;
import com.kingcontaria.fastquit.TextHelper;
import com.kingcontaria.fastquit.WorldInfo;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    @Final
    private static Logger f_129750_;

    @Inject(method={"onServerExit"}, at={@At(value="RETURN")})
    private void fastquit$finishSaving(CallbackInfo ci) {
        MinecraftServerMixin minecraftServerMixin = this;
        if (minecraftServerMixin instanceof IntegratedServer) {
            IntegratedServer server = (IntegratedServer)minecraftServerMixin;
            WorldInfo info = FastQuit.savingWorlds.remove(server);
            if (info == null) {
                FastQuit.warn("\"" + server.m_129910_().m_5462_() + "\" was not registered in currently saving worlds!");
                return;
            }
            MutableComponent description = TextHelper.translatable("fastquit.toast." + (info.deleted ? "deleted" : "description"), server.m_129910_().m_5462_());
            if (FastQuit.CONFIG.showSavingTime != FastQuitConfig.ShowSavingTime.FALSE && !info.deleted) {
                description.m_130946_(" (" + info.getTimeSaving() + ")");
            }
            if (FastQuit.CONFIG.showToasts) {
                Minecraft.m_91087_().m_18707_(() -> Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.WORLD_BACKUP, (Component)TextHelper.translatable("fastquit.toast.title", new Object[0]), (Component)description)));
            }
            FastQuit.log(description.getString());
        }
    }

    @WrapWithCondition(method={"stopServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;saveAll()V")})
    private boolean fastquit$cancelPlayerSavingIfDeleted(PlayerList playerManager) {
        if (this.isDeleted()) {
            f_129750_.info("Cancelled saving players because level was deleted");
            return false;
        }
        return true;
    }

    @Inject(method={"saveAllChunks"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;next()Ljava/lang/Object;"), @At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;saveDataTag(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/world/level/storage/WorldData;Lnet/minecraft/nbt/CompoundTag;)V")}, cancellable=true)
    private void fastquit$cancelSavingIfDeleted(CallbackInfoReturnable<Boolean> cir) {
        if (this.isDeleted()) {
            f_129750_.info("Cancelled saving worlds because level was deleted");
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean isDeleted() {
        WorldInfo info = FastQuit.savingWorlds.get(this);
        return info != null && info.deleted;
    }
}

