/*
 * Decompiled with CFR 0.152.
 */
package com.kingcontaria.fastquit.mixin;

import com.kingcontaria.fastquit.FastQuit;
import com.kingcontaria.fastquit.mixin.LevelInfoAccessor;
import com.kingcontaria.fastquit.mixin.LevelPropertiesAccessor;
import com.kingcontaria.fastquit.plugin.Synchronized;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.DirectoryLock;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.WorldData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelStorageSource.LevelStorageAccess.class})
public abstract class LevelStorageSessionMixin {
    @Shadow
    @Final
    private String f_78272_;

    @Shadow
    @Synchronized
    public abstract PlayerDataStorage m_78301_();

    @Shadow
    @Synchronized
    @Nullable
    public abstract LevelSummary m_78308_();

    @Shadow
    @Synchronized
    @Nullable
    public abstract Pair<WorldData, WorldDimensions.Complete> m_246049_(DynamicOps<Tag> var1, WorldDataConfiguration var2, Registry<LevelStem> var3, Lifecycle var4);

    @Shadow
    @Synchronized
    @Nullable
    public abstract WorldDataConfiguration m_247706_();

    @Shadow
    @Synchronized
    public abstract void m_78290_(RegistryAccess var1, WorldData var2, @Nullable CompoundTag var3);

    @Shadow
    @Synchronized
    public abstract void m_78311_() throws IOException;

    @Shadow
    @Synchronized
    public abstract void m_78297_(String var1) throws IOException;

    @Shadow
    @Synchronized
    public abstract void close() throws IOException;

    @Inject(method={"makeWorldBackup"}, at={@At(value="HEAD")})
    private void fastquit$waitForSaveOnBackup(CallbackInfoReturnable<Long> cir) {
        FastQuit.getSavingWorld((LevelStorageSource.LevelStorageAccess)this).ifPresent(FastQuit::wait);
    }

    @Inject(method={"renameLevel"}, at={@At(value="TAIL")})
    private void fastquit$editSavingWorldName(String name, CallbackInfo ci) {
        FastQuit.getSavingWorld((LevelStorageSource.LevelStorageAccess)this).ifPresent(server -> ((LevelInfoAccessor)((LevelPropertiesAccessor)server.m_129910_()).fastquit$getLevelInfo()).fastquit$setName(name));
    }

    @Inject(method={"deleteLevel"}, at={@At(value="TAIL")})
    private void fastquit$deleteSavingWorld(CallbackInfo ci) {
        FastQuit.getSavingWorld((LevelStorageSource.LevelStorageAccess)this).map(FastQuit.savingWorlds::get).ifPresent(info -> {
            info.deleted = true;
        });
    }

    @WrapWithCondition(method={"close"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/DirectoryLock;close()V")})
    private boolean fastquit$checkSessionClose(DirectoryLock lock) {
        return !FastQuit.occupiedSessions.remove((LevelStorageSource.LevelStorageAccess)this);
    }

    @Inject(method={"checkLock"}, at={@At(value="HEAD")})
    private void fastquit$warnIfUnSynchronizedSessionAccess(CallbackInfo ci) {
        if (!Thread.holdsLock(this)) {
            FastQuit.getSavingWorld((LevelStorageSource.LevelStorageAccess)this).ifPresent(server -> {
                FastQuit.warn("Un-synchronized access to \"" + this.f_78272_ + "\" session!");
                if (!server.m_18695_()) {
                    FastQuit.wait(server);
                }
            });
        }
    }
}

