/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client;

import com.mojang.blaze3d.vertex.PoseStack;
import giselle.jei_mekanism_multiblocks.client.gui.TextAlignment;
import giselle.jei_mekanism_multiblocks.common.JEI_MekanismMultiblocks;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GuiHelper {
    public static final ResourceLocation WIDGETS_LOCATION = JEI_MekanismMultiblocks.rl("textures/gui/widgets.png");

    public static void renderComponentTooltip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, Component ... tooltip) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ != null && tooltip.length > 0) {
            pGuiGraphics.m_280666_(minecraft.f_91062_, Arrays.asList(tooltip), pMouseX, pMouseY);
        }
    }

    public static void renderComponentTooltip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, List<Component> tooltip) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ != null && tooltip.size() > 0) {
            pGuiGraphics.m_280666_(minecraft.f_91062_, tooltip, pMouseX, pMouseY);
        }
    }

    public static void fillRectagleBlack(GuiGraphics pGuiGraphics, int x, int y, int width, int height) {
        pGuiGraphics.m_280509_(x, y, x + width, y + height, -16777216);
    }

    public static void fillRectagle(GuiGraphics pGuiGraphics, int x, int y, int width, int height, float r, float g, float b, float a) {
        int color = Mth.m_14159_((float)r, (float)g, (float)b) | Mth.m_14143_((float)(255.0f * a)) << 24;
        pGuiGraphics.m_280509_(x, y, x + width, y + height, color);
    }

    public static void drawScaledText(GuiGraphics pGuiGraphics, Component text, float x, float y, float width, int color, boolean shadow) {
        GuiHelper.drawScaledText(pGuiGraphics, text, x, y, width, color, shadow, TextAlignment.LEFT);
    }

    public static void drawScaledText(GuiGraphics pGuiGraphics, Component text, float x, float y, float width, int color, boolean shadow, TextAlignment alignment) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int textWidth = font.m_92852_((FormattedText)text);
        float scale = Math.min(width / (float)textWidth, 1.0f);
        PoseStack pose = pGuiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        float scaledX = (x + (float)alignment.align(width, (float)textWidth * scale)) / scale;
        float f = y / scale;
        Objects.requireNonNull(font);
        float scaledY = f + (1.0f - scale) * 9.0f;
        pGuiGraphics.m_280614_(font, text, (int)scaledX, (int)scaledY, color, shadow);
        pose.m_85849_();
    }

    public static void blitButton(GuiGraphics pGuiGraphics, int x, int y, int width, int height, boolean active, boolean hovered) {
        int i = active ? (hovered ? 2 : 1) : 0;
        GuiHelper.blit9Patch(pGuiGraphics, WIDGETS_LOCATION, x, y, width, height, i * 20, 52, 20, 20, 2, 2, 2, 2);
    }

    public static void blit9Patch(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int uL, int vT, int uR, int vB) {
        GuiHelper.blit9Patch(pGuiGraphics, pAtlasLocation, x, y, width, height, textureX, textureY, textureW, textureH, uL, vT, uR, vB, 256, 256);
    }

    public static void blit9Patch(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int uL, int vT, int uR, int vB, int textureWidth, int textureHeight) {
        uL = Math.min(uL, width / 2);
        uR = Math.min(uR, width / 2);
        vT = Math.min(vT, height / 2);
        vB = Math.min(vB, height / 2);
        int inL = x + uL;
        int inR = x + width - uR;
        int inT = y + vT;
        int inB = y + height - vB;
        int inW = width - uL - uR;
        int inH = height - vT - vB;
        int textureInL = textureX + uL;
        int textureInR = textureX + textureW - uR;
        int textureInT = textureY + vT;
        int textureInB = textureY + textureH - vB;
        int textureInW = textureInR - textureInL;
        int textureInH = textureInB - textureInT;
        pGuiGraphics.m_280411_(pAtlasLocation, x, y, uL, vT, (float)textureX, (float)textureY, uL, vT, textureWidth, textureHeight);
        pGuiGraphics.m_280411_(pAtlasLocation, inR, y, uR, vT, (float)textureInR, (float)textureY, uR, vT, textureWidth, textureHeight);
        pGuiGraphics.m_280411_(pAtlasLocation, x, inB, uL, vB, (float)textureX, (float)textureInB, uL, vB, textureWidth, textureHeight);
        pGuiGraphics.m_280411_(pAtlasLocation, inR, inB, uR, vB, (float)textureInR, (float)textureInB, uR, vB, textureWidth, textureHeight);
        pGuiGraphics.m_280411_(pAtlasLocation, inL, y, inW, vT, (float)textureInL, (float)textureY, textureInW, vT, textureWidth, textureHeight);
        pGuiGraphics.m_280411_(pAtlasLocation, inR, inT, uR, inH, (float)textureInR, (float)textureInT, uR, textureInH, textureWidth, textureHeight);
        pGuiGraphics.m_280411_(pAtlasLocation, inL, inB, inW, vT, (float)textureInL, (float)textureInB, textureInW, vB, textureWidth, textureHeight);
        pGuiGraphics.m_280411_(pAtlasLocation, x, inT, uL, inH, (float)textureX, (float)textureInT, uL, textureInH, textureWidth, textureHeight);
        pGuiGraphics.m_280411_(pAtlasLocation, inL, inT, inW, inH, (float)textureInL, (float)textureInT, textureInW, textureInH, textureWidth, textureHeight);
    }

    private GuiHelper() {
    }
}

