/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.init.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import java.io.BufferedWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import lain.mods.skins.api.SkinProviderAPI;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.impl.ConfigOptions;
import lain.mods.skins.impl.PlayerProfile;
import lain.mods.skins.impl.fabric.CustomSkinTexture;
import lain.mods.skins.impl.fabric.ImageUtils;
import lain.mods.skins.providers.MojangCapeProvider;
import lain.mods.skins.providers.MojangSkinProvider;
import lain.mods.skins.providers.UserManagedCapeProvider;
import lain.mods.skins.providers.UserManagedSkinProvider;
import lain.mods.skins.providers.VanilaCapeProvider;
import lain.mods.skins.providers.VanilaSkinProvider;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1044;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class FabricOfflineSkins
implements ClientModInitializer {
    public static boolean PLAYERHEADS = true;
    private static final Map<ByteBuffer, CustomSkinTexture> textures = new WeakHashMap<ByteBuffer, CustomSkinTexture>();

    private static class_2960 generateRandomLocation() {
        return class_2960.method_60655((String)"offlineskins", (String)String.format("textures/generated/%s", UUID.randomUUID()));
    }

    public static class_2960 getLocationCape(GameProfile profile, class_2960 result) {
        ByteBuffer data;
        ISkin skin = SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(profile));
        if (skin != null && skin.isDataReady() && (data = skin.getData()) != null) {
            return FabricOfflineSkins.getOrCreateTexture(data, skin).getLocation();
        }
        return null;
    }

    public static class_2960 getLocationSkin(GameProfile profile, class_2960 result) {
        ByteBuffer data;
        ISkin skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(profile));
        if (skin != null && skin.isDataReady() && (data = skin.getData()) != null) {
            return FabricOfflineSkins.getOrCreateTexture(data, skin).getLocation();
        }
        return null;
    }

    private static CustomSkinTexture getOrCreateTexture(ByteBuffer data, ISkin skin) {
        if (!textures.containsKey(data)) {
            CustomSkinTexture texture = new CustomSkinTexture(FabricOfflineSkins.generateRandomLocation(), data);
            class_310.method_1551().method_1531().method_4616(texture.getLocation(), (class_1044)texture);
            textures.put(data, texture);
            if (skin != null) {
                skin.setRemovalListener(s -> {
                    if (data == s.getData()) {
                        class_310.method_1551().execute(() -> {
                            class_310.method_1551().method_1531().method_4615(texture.getLocation());
                            textures.remove(data);
                        });
                    }
                });
            }
        }
        return textures.get(data);
    }

    public static String getSkinType(GameProfile profile, String result) {
        ByteBuffer data;
        ISkin skin;
        class_2960 location = FabricOfflineSkins.getLocationSkin(profile, null);
        if (location != null && (skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(profile))) != null && skin.isDataReady() && (data = skin.getData()) != null) {
            return skin.getSkinType();
        }
        return null;
    }

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(mc -> {
            if (mc.field_1687 != null) {
                for (class_1657 player : mc.field_1687.method_18456()) {
                    SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(player.method_7334()));
                    SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(player.method_7334()));
                }
            }
        });
        this.reloadConfig();
    }

    public void reloadConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path pathToConfig = Paths.get(".", "config", "offlineskins.json");
        pathToConfig.toFile().getParentFile().mkdirs();
        if (!pathToConfig.toFile().exists()) {
            try (BufferedWriter w = Files.newBufferedWriter(pathToConfig, StandardCharsets.UTF_8, new OpenOption[0]);){
                gson.toJson((Object)new ConfigOptions().defaultOptions(), (Appendable)w);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.err.println("[OfflineSkins] Failed to write default config file.");
            }
        }
        ConfigOptions config = null;
        try {
            config = (ConfigOptions)gson.fromJson(Files.lines(pathToConfig, StandardCharsets.UTF_8).collect(Collectors.joining(System.getProperty("line.separator"))), ConfigOptions.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("[OfflineSkins] Failed to read config file.");
            config = new ConfigOptions();
        }
        SkinProviderAPI.SKIN.clearProviders();
        SkinProviderAPI.SKIN.registerProvider(new UserManagedSkinProvider(Paths.get(".", "cachedImages")).withFilter(ImageUtils::legacyFilter));
        SkinProviderAPI.SKIN.registerProvider(new VanilaSkinProvider().withFilter(ImageUtils::legacyFilter));
        if (config.useMojang) {
            SkinProviderAPI.SKIN.registerProvider(new MojangSkinProvider().withFilter(ImageUtils::legacyFilter));
        }
        SkinProviderAPI.CAPE.clearProviders();
        SkinProviderAPI.CAPE.registerProvider(new UserManagedCapeProvider(Paths.get(".", "cachedImages")));
        SkinProviderAPI.CAPE.registerProvider(new VanilaCapeProvider());
        if (config.useMojang) {
            SkinProviderAPI.CAPE.registerProvider(new MojangCapeProvider());
        }
        PLAYERHEADS = !config.disablePlayerHeads;
    }
}

