/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.api;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lain.lib.SharedPool;
import lain.mods.skins.api.SkinBundle;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.api.interfaces.ISkinProvider;
import lain.mods.skins.api.interfaces.ISkinProviderService;

public class SkinProviderAPI {
    public static final ISkin DUMMY = new ISkin(){

        @Override
        public ByteBuffer getData() {
            return null;
        }

        @Override
        public String getSkinType() {
            return null;
        }

        @Override
        public boolean isDataReady() {
            return false;
        }

        @Override
        public void onRemoval() {
        }

        @Override
        public boolean setRemovalListener(Consumer<ISkin> listener) {
            return false;
        }

        @Override
        public boolean setSkinFilter(Function<ByteBuffer, ByteBuffer> filter) {
            return false;
        }
    };
    public static final ISkinProviderService SKIN = SkinProviderAPI.create();
    public static final ISkinProviderService CAPE = SkinProviderAPI.create();

    public static ISkinProviderService create() {
        return new ISkinProviderService(){
            private final LoadingCache<SkinBundle, AtomicReference<Object>> reloading = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<SkinBundle, AtomicReference<Object>>(this){

                public AtomicReference<Object> load(SkinBundle key) throws Exception {
                    return new AtomicReference<Object>();
                }
            });
            private final LoadingCache<IPlayerProfile, SkinBundle> cache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<IPlayerProfile, SkinBundle>(this){

                public void onRemoval(RemovalNotification<IPlayerProfile, SkinBundle> notification) {
                    SkinBundle skin = (SkinBundle)notification.getValue();
                    if (skin != null) {
                        skin.onRemoval();
                    }
                }
            }).build((CacheLoader)new CacheLoader<IPlayerProfile, SkinBundle>(){

                public SkinBundle load(IPlayerProfile key) throws Exception {
                    key.setUpdateListener(profileChangeListener);
                    return new SkinBundle().set(providers.stream().map(provider -> provider.getSkin(key)).filter(skin -> skin != null).collect(Collectors.toCollection(ArrayList::new)));
                }

                public ListenableFuture<SkinBundle> reload(IPlayerProfile key, SkinBundle oldValue) throws Exception {
                    Collection skins = providers.stream().map(provider -> provider.getSkin(key)).filter(skin -> skin != null).collect(Collectors.toCollection(ArrayList::new));
                    Object token = new Object();
                    ((AtomicReference)reloading.getUnchecked((Object)oldValue)).set(token);
                    long deadline = System.currentTimeMillis() + 10000L;
                    final Supplier<Boolean> ready = () -> System.currentTimeMillis() - deadline > 0L || ((AtomicReference)reloading.getUnchecked((Object)oldValue)).get() != token || skins.stream().filter(ISkin::isDataReady).findAny().isPresent();
                    Runnable update = () -> {
                        if (((AtomicReference)reloading.getUnchecked((Object)oldValue)).compareAndSet(token, null)) {
                            oldValue.set(skins);
                        }
                    };
                    if (skins.isEmpty()) {
                        update.run();
                    } else {
                        ForkJoinPool.ManagedBlocker blocker = new ForkJoinPool.ManagedBlocker(){

                            @Override
                            public boolean block() throws InterruptedException {
                                Thread.sleep(1000L);
                                return (Boolean)ready.get();
                            }

                            @Override
                            public boolean isReleasable() {
                                return (Boolean)ready.get();
                            }
                        };
                        SharedPool.execute(() -> {
                            try {
                                ForkJoinPool.managedBlock(blocker);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            finally {
                                update.run();
                            }
                        });
                    }
                    return Futures.immediateFuture((Object)oldValue);
                }
            });
            private final List<ISkinProvider> providers = new CopyOnWriteArrayList<ISkinProvider>();
            private final Consumer<IPlayerProfile> profileChangeListener = profile -> {
                if (this.cache.getIfPresent(profile) != null) {
                    this.cache.refresh(profile);
                }
            };

            @Override
            public void clearProviders() {
                this.providers.clear();
                this.cache.invalidateAll();
            }

            @Override
            public ISkin getSkin(IPlayerProfile profile) {
                if (profile == null) {
                    return DUMMY;
                }
                return (ISkin)this.cache.getUnchecked((Object)profile);
            }

            @Override
            public boolean registerProvider(ISkinProvider provider) {
                if (provider == null || provider == this) {
                    return false;
                }
                return this.providers.add(provider);
            }
        };
    }
}

