/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.dynamic;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.imb11.sounds.api.SoundDefinition;
import dev.imb11.sounds.api.config.TagPair;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import dev.imb11.sounds.dynamic.TagPairHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundsReloadListener
extends SimplePreparableReloadListener<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundsReloadListener.class);
    private static final Gson GSON = new Gson();

    public void reload(ResourceManager manager) {
        SoundsReloadListener.handleDynamicSounds(manager);
        TagPairHelper.LOADED_TAG_PAIRS.clear();
        for (ResourceLocation id : manager.m_214159_("sounds/blocks", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                Resource resource = (Resource)manager.m_213713_(id).orElseThrow();
                InputStream inputStream = resource.m_215507_();
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream));
                TagPair.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson(reader, JsonObject.class))).result().ifPresent(tagPair -> TagPairHelper.LOADED_TAG_PAIRS.put(id, (TagPair)tagPair.getFirst()));
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource json: " + id.toString(), (Throwable)e);
            }
        }
        TagPairHelper.buildCache();
    }

    private static void handleDynamicSounds(ResourceManager manager) {
        DynamicSoundHelper.clearDefinitions();
        DynamicSoundHelper.loadDirectories.forEach((directory, codec) -> {
            ArrayList<?> resultList = DynamicSoundHelper.loadedDefinitions.get(directory);
            for (ResourceLocation id : manager.m_214159_("sounds/" + directory, path -> path.m_135815_().endsWith(".json")).keySet()) {
                try {
                    Resource resource = (Resource)manager.m_213713_(id).orElseThrow();
                    InputStream inputStream = resource.m_215507_();
                    JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream));
                    SoundDefinition result = (SoundDefinition)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson(reader, JsonObject.class))).getOrThrow(false, s -> {
                        throw new RuntimeException((String)s);
                    });
                    resultList.add(result);
                    inputStream.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while loading resource json: " + id.toString(), (Throwable)e);
                }
            }
            DynamicSoundHelper.loadedDefinitions.put((String)directory, resultList);
        });
        ArrayList items = new ArrayList();
        BuiltInRegistries.f_257033_.m_203611_().forEach(item -> items.add((Item)item.m_203334_()));
        ArrayList itemsWithLoadedDefinitions = new ArrayList();
        DynamicSoundHelper.loadedDefinitions.get("items").forEach(definition -> {
            SoundDefinition definitionCast = (SoundDefinition)definition;
            for (Either registryKeyTagKeyEither : definitionCast.getKeys().getInternalList()) {
                if (registryKeyTagKeyEither.left().isPresent()) {
                    ResourceKey key = (ResourceKey)registryKeyTagKeyEither.left().get();
                    Item entry = (Item)BuiltInRegistries.f_257033_.m_7745_(key.m_135782_());
                    itemsWithLoadedDefinitions.add(entry);
                    continue;
                }
                if (!registryKeyTagKeyEither.right().isPresent()) continue;
                TagKey tagKey = (TagKey)registryKeyTagKeyEither.right().get();
                HolderSet.Named entries = BuiltInRegistries.f_257033_.m_203561_(tagKey);
                for (Holder key : entries) {
                    Item entry = (Item)BuiltInRegistries.f_257033_.m_6246_((ResourceKey)key.m_203543_().get());
                    itemsWithLoadedDefinitions.add(entry);
                }
            }
        });
    }

    protected Void prepare(ResourceManager manager, ProfilerFiller profiler) {
        profiler.m_6180_("SoundsReloadListener");
        this.reload(manager);
        profiler.m_7238_();
        return null;
    }

    protected void apply(Void prepared, ResourceManager manager, ProfilerFiller profiler) {
    }
}

