/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.lexiconfig;

import com.codinglitch.lexiconfig.LexiconEvent;
import com.codinglitch.lexiconfig.Library;
import com.codinglitch.lexiconfig.classes.LexiconData;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LexiconfigApi {
    protected static final List<LexiconData> SHELVED_LEXICONS = new ArrayList<LexiconData>();
    protected static final Map<Consumer<LexiconEvent>, EventType> LISTENERS = new HashMap<Consumer<LexiconEvent>, EventType>();
    public static final List<Library> LIBRARIES = new ArrayList<Library>();
    public static LexiconfigApi INSTANCE;
    private static Logger LOGGER;

    public LexiconfigApi() {
        INSTANCE = this;
    }

    public static void info(Object object, Object ... substitutions) {
        LOGGER.info(String.valueOf(object), substitutions);
    }

    public static void debug(Object object, Object ... substitutions) {
        LOGGER.debug(String.valueOf(object), substitutions);
    }

    public static void warn(Object object, Object ... substitutions) {
        LOGGER.warn(String.valueOf(object), substitutions);
    }

    public static void error(Object object, Object ... substitutions) {
        LOGGER.error(String.valueOf(object), substitutions);
    }

    public static void shelveLexicon(Library library, LexiconData lexicon) {
        library.shelve(lexicon);
        SHELVED_LEXICONS.add(lexicon);
        LexiconfigApi.info("Shelved lexicon {}!", lexicon);
    }

    public static Optional<Library> findLibrary(String id) {
        for (Library library : LIBRARIES) {
            if (!id.equals(library.getName())) continue;
            return Optional.of(library);
        }
        return Optional.empty();
    }

    public static <E extends LexiconEvent> void registerListener(EventType eventType, Consumer<E> listener) {
        LISTENERS.put(listener, eventType);
    }

    protected void callEvent(EventType eventType, LexiconEvent event) {
        LISTENERS.forEach((runnable, type) -> {
            if (type == eventType) {
                runnable.accept(event);
            }
        });
    }

    public abstract Path getConfigPath(Location var1);

    static {
        LOGGER = LogManager.getLogger((String)"Lexiconfig");
    }

    public static enum EventType {
        PRE_CATALOG,
        POST_CATALOG,
        PRE_REVISION,
        POST_REVISION,
        PRE_LEXICON_REVISION,
        POST_LEXICON_REVISION;

    }

    public static enum Extension {
        TOML(".toml");

        public final String file;

        private Extension(String file) {
            this.file = file;
        }
    }

    public static enum Location {
        COMMON,
        CLIENT,
        SERVER,
        WORLD;

    }
}

