/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.mixin.defaults.types.item;

import dev.tomwmth.citreforged.CITReforged;
import dev.tomwmth.citreforged.cit.CIT;
import dev.tomwmth.citreforged.defaults.cit.types.TypeItem;
import dev.tomwmth.citreforged.defaults.common.ResewnItemModelIdentifier;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @Shadow
    @Final
    private Map<ResourceLocation, UnbakedModel> f_119214_;
    @Shadow
    @Final
    private Map<ResourceLocation, UnbakedModel> f_119212_;
    @Shadow
    @Final
    private Map<ResourceLocation, BakedModel> f_119215_;
    @Unique
    private final ResourceManager citresewn$resourceManager = Minecraft.m_91087_().m_91098_();

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", ordinal=0))
    public void citresewn$addTypeItemModels(ProfilerFiller instance, String s) {
        instance.m_6182_("citresewn:type_item_models");
        if (TypeItem.CONTAINER.active()) {
            CITReforged.LOGGER.info("Loading item CIT models...");
            for (CIT<TypeItem> cit : TypeItem.CONTAINER.loaded) {
                try {
                    ((TypeItem)cit.type).loadUnbakedAssets(this.citresewn$resourceManager);
                    for (BlockModel unbakedModel : ((TypeItem)cit.type).unbakedAssets.values()) {
                        ResourceLocation id = ResewnItemModelIdentifier.pack(new ResourceLocation(unbakedModel.f_111416_));
                        this.f_119212_.put(id, (UnbakedModel)unbakedModel);
                        this.f_119214_.put(id, (UnbakedModel)unbakedModel);
                    }
                }
                catch (Exception ex) {
                    CITReforged.logError("Errored loading model in {} from {}", cit.propertiesIdentifier, cit.packName, ex);
                }
            }
            TypeItem.GENERATED_SUB_CITS_SEEN.clear();
        }
        instance.m_6182_(s);
    }

    @Inject(method={"bakeModels"}, at={@At(value="RETURN")})
    public void citresewn$linkTypeItemModels(BiFunction<ResourceLocation, Material, TextureAtlasSprite> spriteLoader, CallbackInfo ci) {
        if (!TypeItem.CONTAINER.active()) {
            return;
        }
        CITReforged.LOGGER.info("Linking baked models to item CITs...");
        for (CIT<TypeItem> cit : TypeItem.CONTAINER.loaded) {
            for (Map.Entry<List<ItemOverride.Predicate>, BlockModel> citModelEntry : ((TypeItem)cit.type).unbakedAssets.entrySet()) {
                if (citModelEntry.getKey() == null) {
                    ((TypeItem)cit.type).bakedModel = this.f_119215_.get(ResewnItemModelIdentifier.pack(new ResourceLocation(citModelEntry.getValue().f_111416_)));
                    continue;
                }
                BakedModel bakedModel = this.f_119215_.get(ResewnItemModelIdentifier.pack(new ResourceLocation(citModelEntry.getValue().f_111416_)));
                if (bakedModel == null) {
                    CITReforged.logWarning("Skipping sub CIT: Failed loading model for \"{}\" in {} from {}", citModelEntry.getValue().f_111416_, cit.propertiesIdentifier, cit.packName);
                    continue;
                }
                ((TypeItem)cit.type).bakedSubModels.override(citModelEntry.getKey(), bakedModel);
            }
            ((TypeItem)cit.type).unbakedAssets = null;
        }
    }

    @ModifyArg(method={"loadBlockModel"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    public Object citresewn$fixDuplicatePrefixSuffix(Object key) {
        ResourceLocation original = (ResourceLocation)key;
        if (TypeItem.CONTAINER.active() && original.m_135815_().startsWith("models/models/") && original.m_135815_().endsWith(".json.json") && original.m_135815_().contains("cit")) {
            return new ResourceLocation(original.m_135827_(), original.m_135815_().substring(7, original.m_135815_().length() - 5));
        }
        return original;
    }
}

