/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.defaults.cit.types;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import dev.tomwmth.citreforged.CITReforged;
import dev.tomwmth.citreforged.api.CITTypeContainer;
import dev.tomwmth.citreforged.cit.CIT;
import dev.tomwmth.citreforged.cit.CITCache;
import dev.tomwmth.citreforged.cit.CITCondition;
import dev.tomwmth.citreforged.cit.CITContext;
import dev.tomwmth.citreforged.cit.CITParsingException;
import dev.tomwmth.citreforged.cit.CITType;
import dev.tomwmth.citreforged.defaults.cit.conditions.ConditionItems;
import dev.tomwmth.citreforged.defaults.common.ResewnItemModelIdentifier;
import dev.tomwmth.citreforged.mixin.defaults.types.item.BlockModelAccessor;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyKey;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.apache.commons.io.IOUtils;

public class TypeItem
extends CITType {
    public static final Container CONTAINER = new Container();
    private static final String GENERATED_SUB_CITS_PREFIX = "sub_cititem_generated_";
    public static final Set<ResourceLocation> GENERATED_SUB_CITS_SEEN = new HashSet<ResourceLocation>();
    private final List<Item> items = new ArrayList<Item>();
    public Map<ResourceLocation, ResourceLocation> assetIdentifiers = new LinkedHashMap<ResourceLocation, ResourceLocation>();
    public Map<List<ItemOverride.Predicate>, BlockModel> unbakedAssets = new LinkedHashMap<List<ItemOverride.Predicate>, BlockModel>();
    private Map<String, Either<Material, String>> textureOverrideMap = new HashMap<String, Either<Material, String>>();
    private boolean isTexture = false;
    public BakedModel bakedModel = null;
    public CITOverrideList bakedSubModels = new CITOverrideList();

    @Override
    public Set<PropertyKey> typeProperties() {
        return Set.of(PropertyKey.of("model"), PropertyKey.of("texture"), PropertyKey.of("tile"));
    }

    @Override
    public void load(List<CITCondition> conditions, PropertyGroup properties, ResourceManager resourceManager) throws CITParsingException {
        ResourceLocation assetIdentifier;
        PropertyValue modelProp;
        boolean containsTexture;
        for (CITCondition condition : conditions) {
            if (!(condition instanceof ConditionItems)) continue;
            ConditionItems conditionItems = (ConditionItems)condition;
            this.items.addAll(Arrays.asList(conditionItems.items));
        }
        if (this.items.isEmpty()) {
            try {
                ResourceLocation propertiesName = ResourceLocation.m_135820_((String)properties.stripName());
                if (!BuiltInRegistries.f_257033_.m_7804_(propertiesName)) {
                    throw new Exception();
                }
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(propertiesName);
                conditions.add(new ConditionItems(item));
                this.items.add(item);
            }
            catch (Exception ignored) {
                throw new CITParsingException("Not targeting any item type", properties, -1);
            }
        }
        boolean bl = containsTexture = (modelProp = properties.getLastWithoutMetadata("citresewn", "model")) == null && !properties.get("citresewn", "texture", "tile").isEmpty();
        if (!containsTexture) {
            assetIdentifier = TypeItem.resolveAsset(properties.identifier, modelProp, "models", ".json", resourceManager);
            if (assetIdentifier != null) {
                this.assetIdentifiers.put(null, assetIdentifier);
            } else if (modelProp != null && (assetIdentifier = TypeItem.resolveAsset(properties.identifier, modelProp, "models", ".json", resourceManager)) != null) {
                this.assetIdentifiers.put(null, assetIdentifier);
            }
        }
        for (PropertyValue property : properties.get("citresewn", "model")) {
            ResourceLocation subIdentifier = TypeItem.resolveAsset(properties.identifier, property, "models", ".json", resourceManager);
            if (subIdentifier == null) {
                throw new CITParsingException("Cannot resolve path", properties, property.position());
            }
            String subItem = property.keyMetadata();
            ResourceLocation subItemIdentifier = this.fixDeprecatedSubItem(subItem, properties, property.position());
            this.assetIdentifiers.put(subItemIdentifier == null ? new ResourceLocation("minecraft", "item/" + subItem) : subItemIdentifier, subIdentifier);
        }
        if (this.assetIdentifiers.isEmpty()) {
            this.isTexture = true;
            textureProp = properties.getLastWithoutMetadata("citresewn", "texture", "tile");
            assetIdentifier = TypeItem.resolveAsset(properties.identifier, textureProp, "textures", ".png", resourceManager);
            if (assetIdentifier != null) {
                this.assetIdentifiers.put(null, assetIdentifier);
            }
            for (PropertyValue property : properties.get("citresewn", "texture", "tile")) {
                if (property.keyMetadata() == null) continue;
                subIdentifier = TypeItem.resolveAsset(properties.identifier, property, "textures", ".png", resourceManager);
                if (subIdentifier == null) {
                    throw new CITParsingException("Cannot resolve path", properties, property.position());
                }
                String subItem = property.keyMetadata();
                ResourceLocation subItemIdentifier = this.fixDeprecatedSubItem(subItem, properties, property.position());
                this.assetIdentifiers.put(subItemIdentifier == null ? new ResourceLocation("minecraft", "item/" + subItem) : subItemIdentifier, subIdentifier);
            }
        } else {
            textureProp = properties.getLastWithoutMetadata("citresewn", "texture", "tile");
            if (textureProp != null) {
                assetIdentifier = TypeItem.resolveAsset(properties.identifier, textureProp, "textures", ".png", resourceManager);
                if (assetIdentifier != null) {
                    this.textureOverrideMap.put(null, (Either<Material, String>)Either.left((Object)new Material(TextureAtlas.f_118259_, assetIdentifier)));
                } else {
                    throw new CITParsingException("Cannot resolve path", properties, textureProp.position());
                }
            }
            for (PropertyValue property : properties.get("citresewn", "texture", "tile")) {
                textureProp = property;
                subIdentifier = TypeItem.resolveAsset(properties.identifier, textureProp, "textures", ".png", resourceManager);
                if (subIdentifier == null) {
                    throw new CITParsingException("Cannot resolve path", properties, property.position());
                }
                this.textureOverrideMap.put(property.keyMetadata(), (Either<Material, String>)Either.left((Object)new Material(TextureAtlas.f_118259_, subIdentifier)));
            }
        }
        if (this.assetIdentifiers.size() == 0) {
            throw new CITParsingException("Could not resolve a replacement model/texture", properties, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUnbakedAssets(ResourceManager resourceManager) throws Exception {
        try {
            if (this.isTexture) {
                ResourceLocation baseIdentifier;
                BlockModel itemJson = this.getModelForFirstItemType(resourceManager);
                if (((BlockModelAccessor)itemJson).getTextureMap().size() > 1) {
                    this.textureOverrideMap = ((BlockModelAccessor)itemJson).getTextureMap();
                    ResourceLocation defaultAsset = this.assetIdentifiers.get(null);
                    this.textureOverrideMap.replaceAll((layerName, originalTextureEither) -> {
                        ResourceLocation textureIdentifier = this.assetIdentifiers.remove(originalTextureEither.map(Material::m_119203_, ResourceLocation::m_135820_));
                        if (textureIdentifier != null) {
                            return Either.left((Object)new Material(TextureAtlas.f_118259_, textureIdentifier));
                        }
                        if (defaultAsset != null) {
                            return Either.left((Object)new Material(TextureAtlas.f_118259_, defaultAsset));
                        }
                        return null;
                    });
                    if (this.assetIdentifiers.size() == 0 || this.assetIdentifiers.size() == 1 && this.assetIdentifiers.containsKey(null)) {
                        this.unbakedAssets.put(null, itemJson);
                        return;
                    }
                }
                if ((baseIdentifier = this.assetIdentifiers.remove(null)) != null) {
                    this.unbakedAssets.put(null, this.loadUnbakedAsset(resourceManager, baseIdentifier, null));
                }
                if (!this.assetIdentifiers.isEmpty()) {
                    LinkedHashMap overrideConditions = new LinkedHashMap();
                    for (Item item : this.items) {
                        ResourceLocation itemIdentifier = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                        overrideConditions.put(new ResourceLocation(itemIdentifier.m_135827_(), "item/" + itemIdentifier.m_135815_()), Collections.emptyList());
                        ResourceLocation itemModelIdentifier = new ResourceLocation(itemIdentifier.m_135827_(), "models/item/" + itemIdentifier.m_135815_() + ".json");
                        try (InputStreamReader resourceReader = new InputStreamReader(((Resource)resourceManager.m_213713_(itemModelIdentifier).orElseThrow()).m_215507_());){
                            BlockModel itemModelJson = BlockModel.m_111461_((Reader)resourceReader);
                            if (itemModelJson.m_111484_() == null || itemModelJson.m_111484_().isEmpty()) continue;
                            for (ItemOverride override : itemModelJson.m_111484_()) {
                                overrideConditions.put(override.m_111718_(), override.m_173449_().toList());
                            }
                        }
                    }
                    ArrayList overrideModels = new ArrayList(overrideConditions.keySet());
                    Collections.reverse(overrideModels);
                    for (ResourceLocation overrideModel : overrideModels) {
                        ResourceLocation replacement = this.assetIdentifiers.remove(overrideModel);
                        if (replacement == null) continue;
                        List conditions = (List)overrideConditions.get(overrideModel);
                        if (overrideModel != null) {
                            GENERATED_SUB_CITS_SEEN.add(replacement);
                            replacement = new ResourceLocation(replacement.m_135827_(), GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + replacement.m_135815_());
                        }
                        this.unbakedAssets.put(conditions, this.loadUnbakedAsset(resourceManager, replacement, overrideModel));
                    }
                }
            } else {
                ResourceLocation baseIdentifier = this.assetIdentifiers.remove(null);
                if (baseIdentifier != null) {
                    if (!GENERATED_SUB_CITS_SEEN.add(baseIdentifier)) {
                        baseIdentifier = new ResourceLocation(baseIdentifier.m_135827_(), GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + baseIdentifier.m_135815_());
                    }
                    GENERATED_SUB_CITS_SEEN.add(baseIdentifier);
                    BlockModel model = this.loadUnbakedAsset(resourceManager, baseIdentifier, null);
                    this.unbakedAssets.put(null, model);
                    if (!model.m_111484_().isEmpty() && !this.textureOverrideMap.isEmpty()) {
                        LinkedHashMap overrideConditions = new LinkedHashMap();
                        for (ItemOverride itemOverride : model.m_111484_()) {
                            overrideConditions.put(itemOverride.m_111718_(), itemOverride.m_173449_().toList());
                        }
                        ArrayList overrideModels = new ArrayList(overrideConditions.keySet());
                        Collections.reverse(overrideModels);
                        Iterator iterator = overrideModels.iterator();
                        while (iterator.hasNext()) {
                            ResourceLocation overrideModel = (ResourceLocation)iterator.next();
                            ResourceLocation replacement = TypeItem.resolveAsset(baseIdentifier, overrideModel.toString(), "models", ".json", resourceManager);
                            if (replacement == null) continue;
                            String subTexturePath = replacement.toString().substring(0, replacement.toString().lastIndexOf(46));
                            String subTextureName = subTexturePath.substring(subTexturePath.lastIndexOf(47) + 1);
                            replacement = baseIdentifier;
                            if (!GENERATED_SUB_CITS_SEEN.add(replacement)) {
                                replacement = new ResourceLocation(replacement.m_135827_(), GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + replacement.m_135815_());
                            }
                            GENERATED_SUB_CITS_SEEN.add(replacement);
                            BlockModel jsonModel = this.loadUnbakedAsset(resourceManager, replacement, null);
                            jsonModel.m_111484_().clear();
                            ((BlockModelAccessor)jsonModel).getTextureMap().replaceAll((layerName, texture) -> {
                                if (layerName != null) {
                                    try {
                                        for (String subTexture : this.textureOverrideMap.keySet()) {
                                            if (!subTextureName.equals(subTexture)) continue;
                                            return this.textureOverrideMap.get(subTexture);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                return texture;
                            });
                            this.unbakedAssets.put((List)overrideConditions.get(overrideModel), jsonModel);
                        }
                    }
                }
                if (!this.assetIdentifiers.isEmpty()) {
                    LinkedHashMap overrideConditions = new LinkedHashMap();
                    for (Item item : this.items) {
                        ResourceLocation resourceLocation = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                        overrideConditions.put(new ResourceLocation(resourceLocation.m_135827_(), "item/" + resourceLocation.m_135815_()), Collections.emptyList());
                        ResourceLocation itemModelIdentifier = new ResourceLocation(resourceLocation.m_135827_(), "models/item/" + resourceLocation.m_135815_() + ".json");
                        try (InputStreamReader resourceReader = new InputStreamReader(((Resource)resourceManager.m_213713_(itemModelIdentifier).orElseThrow()).m_215507_());){
                            BlockModel itemModelJson = BlockModel.m_111461_((Reader)resourceReader);
                            if (itemModelJson.m_111484_() == null || itemModelJson.m_111484_().isEmpty()) continue;
                            for (ItemOverride override : itemModelJson.m_111484_()) {
                                overrideConditions.put(override.m_111718_(), override.m_173449_().toList());
                            }
                        }
                    }
                    ArrayList overrideModels = new ArrayList(overrideConditions.keySet());
                    Collections.reverse(overrideModels);
                    for (ResourceLocation resourceLocation : overrideModels) {
                        ResourceLocation replacement = this.assetIdentifiers.remove(resourceLocation);
                        if (replacement == null) continue;
                        if (!GENERATED_SUB_CITS_SEEN.add(replacement)) {
                            replacement = new ResourceLocation(replacement.m_135827_(), GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + replacement.m_135815_());
                        }
                        GENERATED_SUB_CITS_SEEN.add(replacement);
                        List conditions = (List)overrideConditions.get(resourceLocation);
                        this.unbakedAssets.put(conditions, this.loadUnbakedAsset(resourceManager, replacement, null));
                    }
                }
            }
        }
        finally {
            this.assetIdentifiers = null;
            this.textureOverrideMap = null;
        }
    }

    private BlockModel loadUnbakedAsset(ResourceManager resourceManager, ResourceLocation assetIdentifier, ResourceLocation overrideModel) throws Exception {
        BlockModel json;
        ResourceLocation possibleIdentifier = assetIdentifier;
        while (possibleIdentifier.m_135815_().startsWith(GENERATED_SUB_CITS_PREFIX)) {
            possibleIdentifier = new ResourceLocation(possibleIdentifier.m_135827_(), possibleIdentifier.m_135815_().substring(possibleIdentifier.m_135815_().substring(GENERATED_SUB_CITS_PREFIX.length()).indexOf(95) + GENERATED_SUB_CITS_PREFIX.length() + 1));
        }
        ResourceLocation identifier = possibleIdentifier;
        if (identifier.m_135815_().endsWith(".json")) {
            try (InputStream is = ((Resource)resourceManager.m_213713_(identifier).orElseThrow()).m_215507_();){
                ResourceLocation parentId;
                json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                json.f_111416_ = assetIdentifier.toString();
                json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 5);
                ((BlockModelAccessor)json).getTextureMap().replaceAll((layer, original) -> {
                    ResourceLocation resolvedIdentifier;
                    Optional left = original.left();
                    if (left.isPresent() && (resolvedIdentifier = TypeItem.resolveAsset(identifier, ((Material)left.get()).m_119193_().m_135815_(), "textures", ".png", resourceManager)) != null) {
                        return Either.left((Object)new Material(((Material)left.get()).m_119193_(), resolvedIdentifier));
                    }
                    return original;
                });
                if (!this.textureOverrideMap.isEmpty()) {
                    Either<Material, String> defaultTextureOverride;
                    Map<String, Either<Material, String>> jsonTextureMap = ((BlockModelAccessor)json).getTextureMap();
                    if (jsonTextureMap.isEmpty()) {
                        jsonTextureMap.put("layer0", null);
                    }
                    if ((defaultTextureOverride = this.textureOverrideMap.get(null)) != null) {
                        jsonTextureMap.replaceAll((layerName, spriteIdentifierStringEither) -> defaultTextureOverride);
                    }
                    jsonTextureMap.replaceAll((layerName, texture) -> {
                        if (layerName != null) {
                            try {
                                String[] split = ((String)texture.map(id -> id.m_119193_().m_135815_(), s -> s)).split("/");
                                String textureName = split[split.length - 1];
                                if (textureName.endsWith(".png")) {
                                    textureName = textureName.substring(0, textureName.length() - 4);
                                }
                                return Objects.requireNonNull(this.textureOverrideMap.get(textureName));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return texture;
                    });
                    jsonTextureMap.values().removeIf(Objects::isNull);
                }
                if ((parentId = ((BlockModelAccessor)json).getParentLocation()) != null) {
                    String[] parentIdPathSplit = parentId.m_135815_().split("/");
                    if ((parentId.m_135815_().startsWith("./") || parentIdPathSplit.length > 2 && parentIdPathSplit[1].equals("cit")) && (parentId = TypeItem.resolveAsset(identifier, parentId.m_135815_(), "models", ".json", resourceManager)) != null) {
                        ((BlockModelAccessor)json).setParentLocation(ResewnItemModelIdentifier.pack(parentId));
                    }
                }
                json.m_111484_().replaceAll(override -> {
                    ResourceLocation resolvedOverridePath;
                    String[] modelIdPathSplit = override.m_111718_().m_135815_().split("/");
                    if ((override.m_111718_().m_135815_().startsWith("./") || modelIdPathSplit.length > 2 && modelIdPathSplit[1].equals("cit")) && (resolvedOverridePath = TypeItem.resolveAsset(identifier, override.m_111718_().m_135815_(), "models", ".json", resourceManager)) != null) {
                        return new ItemOverride(ResewnItemModelIdentifier.pack(resolvedOverridePath), override.m_173449_().collect(Collectors.toList()));
                    }
                    return override;
                });
                BlockModel blockModel = json;
                return blockModel;
            }
        }
        if (identifier.m_135815_().endsWith(".png")) {
            BlockModel blockModel = json = overrideModel == null ? this.getModelForFirstItemType(resourceManager) : this.getModelFromOverrideModel(resourceManager, overrideModel);
            if (json == null) {
                json = new BlockModel(new ResourceLocation("minecraft", "item/generated"), new ArrayList(), (Map)ImmutableMap.of((Object)"layer0", (Object)Either.left((Object)new Material(TextureAtlas.f_118259_, identifier))), Boolean.valueOf(true), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
            }
            json.m_111484_().clear();
            json.f_111416_ = assetIdentifier.toString();
            json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 4);
            ((BlockModelAccessor)json).getTextureMap().replaceAll((layerName, originalTextureEither) -> {
                if (!this.textureOverrideMap.isEmpty()) {
                    Either<Material, String> textureOverride = this.textureOverrideMap.get(layerName);
                    if (textureOverride == null) {
                        textureOverride = this.textureOverrideMap.get(null);
                    }
                    return textureOverride == null ? originalTextureEither : textureOverride;
                }
                return Either.left((Object)new Material(TextureAtlas.f_118259_, identifier));
            });
            return json;
        }
        throw new Exception("Unknown asset type");
    }

    public ResourceLocation fixDeprecatedSubItem(String subItem, PropertyGroup properties, int position) {
        String replacement;
        if (subItem == null) {
            return null;
        }
        switch (subItem) {
            case "bow_standby": {
                String string = "bow";
                break;
            }
            case "crossbow_standby": {
                String string = "crossbow";
                break;
            }
            case "potion_bottle_drinkable": {
                String string = "potion";
                break;
            }
            case "potion_bottle_splash": {
                String string = "splash_potion";
                break;
            }
            case "potion_bottle_lingering": {
                String string = "lingering_potion";
                break;
            }
            default: {
                String string = replacement = null;
            }
        }
        if (replacement != null) {
            CITReforged.logWarning(properties.messageWithDescriptorOf("Warning: Using deprecated sub item id \"" + subItem + "\" instead of \"" + replacement + "\"", position), new Object[0]);
            return new ResourceLocation("minecraft", "item/" + replacement);
        }
        return null;
    }

    private BlockModel getModelForFirstItemType(ResourceManager resourceManager) {
        BlockModel blockModel;
        block17: {
            ResourceLocation firstItemIdentifier = BuiltInRegistries.f_257033_.m_7981_((Object)this.items.iterator().next());
            ResourceLocation firstItemModelIdentifier = new ResourceLocation(firstItemIdentifier.m_135827_(), "models/item/" + firstItemIdentifier.m_135815_() + ".json");
            InputStream is = ((Resource)resourceManager.m_213713_(firstItemModelIdentifier).orElseThrow()).m_215507_();
            try {
                BlockModel json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                if (((BlockModelAccessor)json).getParentLocation().equals((Object)new ResourceLocation("minecraft", "item/template_spawn_egg"))) {
                    try (InputStream parentInputStream = ((Resource)resourceManager.m_213713_(new ResourceLocation("minecraft", "models/item/template_spawn_egg.json")).orElseThrow()).m_215507_();){
                        json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)parentInputStream, (Charset)StandardCharsets.UTF_8));
                        ((BlockModelAccessor)json).getTextureMap().remove("layer1");
                    }
                }
                if (!GENERATED_SUB_CITS_SEEN.add(firstItemModelIdentifier)) {
                    firstItemModelIdentifier = new ResourceLocation(firstItemModelIdentifier.m_135827_(), GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + firstItemModelIdentifier.m_135815_());
                }
                GENERATED_SUB_CITS_SEEN.add(firstItemModelIdentifier);
                json.f_111416_ = firstItemModelIdentifier.toString();
                json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 5);
                blockModel = json;
                if (is == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            is.close();
        }
        return blockModel;
    }

    private BlockModel getModelFromOverrideModel(ResourceManager resourceManager, ResourceLocation overrideModel) {
        BlockModel blockModel;
        block9: {
            ResourceLocation modelIdentifier = new ResourceLocation(overrideModel.m_135827_(), "models/" + overrideModel.m_135815_() + ".json");
            InputStream is = ((Resource)resourceManager.m_213713_(modelIdentifier).orElseThrow()).m_215507_();
            try {
                BlockModel json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                if (!GENERATED_SUB_CITS_SEEN.add(modelIdentifier)) {
                    modelIdentifier = new ResourceLocation(modelIdentifier.m_135827_(), GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + modelIdentifier.m_135815_());
                }
                GENERATED_SUB_CITS_SEEN.add(modelIdentifier);
                json.f_111416_ = modelIdentifier.toString();
                json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 5);
                blockModel = json;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            is.close();
        }
        return blockModel;
    }

    public BakedModel getItemModel(CITContext context, int seed) {
        ClientLevel clientWorld;
        Level level = context.world;
        ClientLevel world = level instanceof ClientLevel ? (clientWorld = (ClientLevel)level) : null;
        BakedModel bakedModel = this.bakedSubModels.m_173464_(this.bakedModel, context.stack, world, context.entity, seed);
        if (bakedModel != null && bakedModel.m_7343_() != null) {
            bakedModel = bakedModel.m_7343_().m_173464_(bakedModel, context.stack, world, context.entity, seed);
        }
        return bakedModel;
    }

    public static class CITOverrideList
    extends ItemOverrides {
        public void override(List<ItemOverride.Predicate> key, BakedModel bakedModel) {
            LinkedHashSet<ResourceLocation> conditionTypes = new LinkedHashSet<ResourceLocation>(Arrays.asList(this.f_173461_));
            for (ItemOverride.Predicate condition : key) {
                conditionTypes.add(condition.m_173459_());
            }
            this.f_173461_ = conditionTypes.toArray(new ResourceLocation[0]);
            this.f_111735_ = Arrays.copyOf(this.f_111735_, this.f_111735_.length + 1);
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            for (int i = 0; i < this.f_173461_.length; ++i) {
                object2IntMap.put((Object)this.f_173461_[i], i);
            }
            this.f_111735_[this.f_111735_.length - 1] = new ItemOverrides.BakedOverride((ItemOverrides.PropertyMatcher[])key.stream().map(arg_0 -> CITOverrideList.lambda$override$0((Object2IntMap)object2IntMap, arg_0)).toArray(ItemOverrides.PropertyMatcher[]::new), bakedModel);
        }

        private static /* synthetic */ ItemOverrides.PropertyMatcher lambda$override$0(Object2IntMap object2IntMap, ItemOverride.Predicate condition) {
            return new ItemOverrides.PropertyMatcher(object2IntMap.getInt((Object)condition.m_173459_()), condition.m_173460_());
        }
    }

    public static class Container
    extends CITTypeContainer<TypeItem> {
        public Set<CIT<TypeItem>> loaded = new HashSet<CIT<TypeItem>>();
        public Map<Item, Set<CIT<TypeItem>>> loadedTyped = new IdentityHashMap<Item, Set<CIT<TypeItem>>>();

        public Container() {
            super(TypeItem.class, TypeItem::new, "item");
        }

        @Override
        public void load(List<CIT<TypeItem>> parsedCITs) {
            this.loaded.addAll(parsedCITs);
            for (CIT<TypeItem> cit : parsedCITs) {
                for (CITCondition condition : cit.conditions) {
                    if (!(condition instanceof ConditionItems)) continue;
                    ConditionItems items = (ConditionItems)condition;
                    for (Item item : items.items) {
                        if (item == null) continue;
                        this.loadedTyped.computeIfAbsent(item, i -> new LinkedHashSet()).add(cit);
                    }
                }
            }
        }

        @Override
        public void dispose() {
            this.loaded.clear();
            this.loadedTyped.clear();
        }

        public CIT<TypeItem> getCIT(CITContext context, int seed) {
            return (CIT)((CITCacheItem)context.stack).citresewn$getCacheTypeItem().get(context).get();
        }

        public CIT<TypeItem> getRealTimeCIT(CITContext context) {
            Set<CIT<TypeItem>> loadedForItemType = this.loadedTyped.get(context.stack.m_41720_());
            if (loadedForItemType != null) {
                for (CIT<TypeItem> cit : loadedForItemType) {
                    if (!cit.test(context)) continue;
                    return cit;
                }
            }
            return null;
        }
    }

    public static interface BakedModelManagerMixinAccess {
        public void citresewn$forceMojankModel(BakedModel var1);
    }

    public static interface CITCacheItem {
        public CITCache.Single<TypeItem> citresewn$getCacheTypeItem();
    }
}

