/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.defaults.cit.types;

import dev.tomwmth.citreforged.api.CITTypeContainer;
import dev.tomwmth.citreforged.cit.CIT;
import dev.tomwmth.citreforged.cit.CITCache;
import dev.tomwmth.citreforged.cit.CITCondition;
import dev.tomwmth.citreforged.cit.CITContext;
import dev.tomwmth.citreforged.cit.CITParsingException;
import dev.tomwmth.citreforged.cit.CITType;
import dev.tomwmth.citreforged.defaults.cit.conditions.ConditionItems;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyKey;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TypeArmor
extends CITType {
    public static final Container CONTAINER = new Container();
    public final Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();

    @Override
    public Set<PropertyKey> typeProperties() {
        return Set.of(PropertyKey.of("texture"));
    }

    @Override
    public void load(List<CITCondition> conditions, PropertyGroup properties, ResourceManager resourceManager) throws CITParsingException {
        boolean itemsConditionPresent = false;
        for (CITCondition condition : conditions) {
            if (!(condition instanceof ConditionItems)) continue;
            ConditionItems conditionItems = (ConditionItems)condition;
            for (Item item : conditionItems.items) {
                if (!(item instanceof ArmorItem)) {
                    throw new CITParsingException("This type only accepts armor items for the items condition", properties, -1);
                }
                itemsConditionPresent = true;
            }
        }
        if (!itemsConditionPresent) {
            try {
                ResourceLocation propertiesName = ResourceLocation.m_135820_((String)properties.stripName());
                if (!BuiltInRegistries.f_257033_.m_7804_(propertiesName)) {
                    throw new Exception();
                }
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(propertiesName);
                if (!(item instanceof ArmorItem)) {
                    throw new Exception();
                }
                conditions.add(new ConditionItems(item));
            }
            catch (Exception ignored) {
                throw new CITParsingException("Not targeting any item type", properties, -1);
            }
        }
        for (PropertyValue propertyValue : properties.get("citresewn", "texture")) {
            ResourceLocation identifier = TypeArmor.resolveAsset(properties.identifier, propertyValue, "textures", ".png", resourceManager);
            if (identifier == null) {
                throw new CITParsingException("Could not resolve texture", properties, propertyValue.position());
            }
            this.textures.put(propertyValue.keyMetadata(), identifier);
        }
        if (this.textures.isEmpty()) {
            throw new CITParsingException("Texture not specified", properties, -1);
        }
    }

    public static class Container
    extends CITTypeContainer<TypeArmor> {
        public final List<BiFunction<LivingEntity, EquipmentSlot, ItemStack>> getItemInSlotCompatRedirects = new ArrayList<BiFunction<LivingEntity, EquipmentSlot, ItemStack>>();
        public Set<CIT<TypeArmor>> loaded = new HashSet<CIT<TypeArmor>>();
        public Map<ArmorItem, Set<CIT<TypeArmor>>> loadedTyped = new IdentityHashMap<ArmorItem, Set<CIT<TypeArmor>>>();

        public Container() {
            super(TypeArmor.class, TypeArmor::new, "armor");
        }

        @Override
        public void load(List<CIT<TypeArmor>> parsedCITs) {
            this.loaded.addAll(parsedCITs);
            for (CIT<TypeArmor> cit : parsedCITs) {
                for (CITCondition condition : cit.conditions) {
                    if (!(condition instanceof ConditionItems)) continue;
                    ConditionItems items = (ConditionItems)condition;
                    for (Item item : items.items) {
                        if (!(item instanceof ArmorItem)) continue;
                        ArmorItem armorItem = (ArmorItem)item;
                        this.loadedTyped.computeIfAbsent(armorItem, i -> new LinkedHashSet()).add(cit);
                    }
                }
            }
        }

        @Override
        public void dispose() {
            this.loaded.clear();
            this.loadedTyped.clear();
        }

        public CIT<TypeArmor> getCIT(CITContext context) {
            return (CIT)((CITCacheArmor)context.stack).citresewn$getCacheTypeArmor().get(context).get();
        }

        public CIT<TypeArmor> getRealTimeCIT(CITContext context) {
            if (!(context.stack.m_41720_() instanceof ArmorItem)) {
                return null;
            }
            Set<CIT<TypeArmor>> loadedForItemType = this.loadedTyped.get(context.stack.m_41720_());
            if (loadedForItemType != null) {
                for (CIT<TypeArmor> cit : loadedForItemType) {
                    if (!cit.test(context)) continue;
                    return cit;
                }
            }
            return null;
        }

        public ItemStack getVisualItemInSlot(LivingEntity entity, EquipmentSlot slot) {
            for (BiFunction<LivingEntity, EquipmentSlot, ItemStack> redirect : this.getItemInSlotCompatRedirects) {
                ItemStack stack = redirect.apply(entity, slot);
                if (stack == null) continue;
                return stack;
            }
            return entity.m_6844_(slot);
        }
    }

    public static interface CITCacheArmor {
        public CITCache.Single<TypeArmor> citresewn$getCacheTypeArmor();
    }
}

