/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.cit.builtin.conditions.core;

import dev.tomwmth.citreforged.api.CITConditionContainer;
import dev.tomwmth.citreforged.cit.CIT;
import dev.tomwmth.citreforged.cit.builtin.conditions.IntegerCondition;
import java.util.Comparator;
import java.util.List;

public class WeightCondition
extends IntegerCondition {
    public static final CITConditionContainer<WeightCondition> CONTAINER = new CITConditionContainer<WeightCondition>(WeightCondition.class, WeightCondition::new, "weight", "cit_weight", "citWeight");

    public WeightCondition() {
        super(false, true, false);
        this.min = 0;
    }

    public int getWeight() {
        return this.min;
    }

    public void setWeight(int weight) {
        this.min = weight;
    }

    public static void apply(List<CIT<?>> cits) {
        cits.sort(Comparator.comparingInt(cit -> cit.weight).reversed().thenComparing(cit -> cit.propertiesIdentifier.toString() + cit.packName));
    }
}

