/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.cit.builtin.conditions;

import dev.tomwmth.citreforged.cit.CITCondition;
import dev.tomwmth.citreforged.cit.CITContext;
import dev.tomwmth.citreforged.cit.CITParsingException;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import java.util.function.Supplier;

public abstract class EnumCondition<T extends Enum<? extends Aliased>>
extends CITCondition {
    protected final Supplier<T[]> values;
    protected final boolean ignoreCase;
    protected T value;

    protected T getValue(CITContext context) {
        throw new AssertionError((Object)"Not implemented by this condition");
    }

    protected EnumCondition(Supplier<T[]> values, boolean ignoreCase) {
        this.values = values;
        this.ignoreCase = ignoreCase;
    }

    protected EnumCondition(Supplier<T[]> values) {
        this(values, true);
    }

    @Override
    public void load(PropertyValue value, PropertyGroup properties) throws CITParsingException {
        for (Enum enumConstant : (Enum[])this.values.get()) {
            for (String alias : ((Aliased)((Object)enumConstant)).getAliases()) {
                if (!(this.ignoreCase ? alias.equalsIgnoreCase(value.value()) : alias.equals(value.value()))) continue;
                this.value = enumConstant;
                return;
            }
        }
        throw new CITParsingException("Unrecognized value", properties, value.position());
    }

    @Override
    public boolean test(CITContext context) {
        return this.getValue(context) == this.value;
    }

    public static interface Aliased {
        default public String[] getAliases() {
            return new String[]{((Enum)((Object)this)).name()};
        }
    }
}

