/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.cit;

import dev.tomwmth.citreforged.CITReforged;
import dev.tomwmth.citreforged.CITRegistrarImpl;
import dev.tomwmth.citreforged.api.CITConditionContainer;
import dev.tomwmth.citreforged.api.CITTypeContainer;
import dev.tomwmth.citreforged.cit.CITCondition;
import dev.tomwmth.citreforged.cit.CITParsingException;
import dev.tomwmth.citreforged.cit.CITType;
import dev.tomwmth.citreforged.cit.UnknownCITTypeException;
import dev.tomwmth.citreforged.cit.builtin.conditions.ConstantCondition;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyKey;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public final class CITRegistry {
    public static final Map<ResourceLocation, CITTypeContainer<? extends CITType>> TYPES = new HashMap<ResourceLocation, CITTypeContainer<? extends CITType>>();
    public static final Map<PropertyKey, CITConditionContainer<? extends CITCondition>> CONDITIONS = new HashMap<PropertyKey, CITConditionContainer<? extends CITCondition>>();
    private static final Map<Class<? extends CITType>, ResourceLocation> TYPE_TO_ID = new IdentityHashMap<Class<? extends CITType>, ResourceLocation>();
    private static final Map<Class<? extends CITCondition>, PropertyKey> CONDITION_TO_ID = new IdentityHashMap<Class<? extends CITCondition>, PropertyKey>();

    private CITRegistry() {
    }

    public static void registerAll() {
        CITReforged.LOGGER.info("Registering CIT conditions...");
        CITRegistrarImpl.getConditions().forEach((namespace, conditions) -> conditions.forEach(condition -> {
            for (String alias : condition.aliases) {
                PropertyKey key = new PropertyKey((String)namespace, alias);
                CONDITIONS.put(key, (CITConditionContainer<? extends CITCondition>)condition);
                CONDITION_TO_ID.putIfAbsent(((CITCondition)condition.createCondition.get()).getClass(), key);
            }
        }));
        CITReforged.LOGGER.info("Registering CIT types...");
        CITRegistrarImpl.getTypes().forEach((identifier, types) -> types.forEach(type -> {
            TYPES.put((ResourceLocation)identifier, (CITTypeContainer<? extends CITType>)type);
            TYPE_TO_ID.putIfAbsent((Class<? extends CITType>)((CITType)type.createType.get()).getClass(), (ResourceLocation)identifier);
        }));
    }

    public static CITCondition parseCondition(PropertyKey key, PropertyValue value, PropertyGroup properties) throws CITParsingException {
        CITConditionContainer<? extends CITCondition> conditionContainer = CONDITIONS.get(key);
        if (conditionContainer == null) {
            CITReforged.logWarning(properties.messageWithDescriptorOf("Unknown condition type \"" + key.toString() + "\"", value.position()), new Object[0]);
            return ConstantCondition.FALSE;
        }
        CITCondition condition = (CITCondition)conditionContainer.createCondition.get();
        condition.load(value, properties);
        return condition;
    }

    public static CITType parseType(PropertyGroup properties) throws UnknownCITTypeException {
        CITTypeContainer<? extends CITType> typeContainer;
        ResourceLocation type = new ResourceLocation("citresewn", "item");
        PropertyValue propertiesType = properties.getLastWithoutMetadata("citresewn", "type");
        if (propertiesType != null) {
            Object value = propertiesType.value();
            if (!((String)value).contains(":")) {
                value = "citresewn:" + (String)value;
            }
            type = ResourceLocation.m_135820_((String)value);
        }
        if ((typeContainer = TYPES.get(type)) == null) {
            throw new UnknownCITTypeException(properties, propertiesType == null ? -1 : propertiesType.position());
        }
        return (CITType)typeContainer.createType.get();
    }

    public static ResourceLocation idOfType(Class<? extends CITType> clazz) {
        return TYPE_TO_ID.get(clazz);
    }

    public static PropertyKey idOfCondition(Class<? extends CITCondition> clazz) {
        return CONDITION_TO_ID.get(clazz);
    }
}

