/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.cit;

import dev.tomwmth.citreforged.cit.CIT;
import dev.tomwmth.citreforged.cit.CITContext;
import dev.tomwmth.citreforged.cit.CITType;
import dev.tomwmth.citreforged.config.CITResewnConfig;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public abstract class CITCache<T extends CITType> {
    private static byte offset = 0;
    public long lastCachedStamp = 0L;

    public static class MultiList<T extends CITType>
    extends CITCache<T> {
        protected List<WeakReference<CIT<T>>> cit = null;
        protected final Function<CITContext, List<CIT<T>>> realtime;

        public MultiList(Function<CITContext, List<CIT<T>>> realtime) {
            this.realtime = realtime;
        }

        public List<WeakReference<CIT<T>>> get(CITContext context) {
            if (this.cit == null) {
                offset = (byte)(offset + 4);
                this.lastCachedStamp = System.currentTimeMillis() + (long)CITResewnConfig.INSTANCE.cache_ms + (long)offset;
            }
            if (this.cit == null || System.currentTimeMillis() - this.lastCachedStamp >= (long)CITResewnConfig.INSTANCE.cache_ms) {
                this.cit = new ArrayList<WeakReference<CIT<T>>>();
                for (CIT<T> realtimeCIT : this.realtime.apply(context)) {
                    this.cit.add(new WeakReference<CIT<T>>(realtimeCIT));
                }
                this.lastCachedStamp = System.currentTimeMillis();
            }
            return this.cit;
        }
    }

    public static class Single<T extends CITType>
    extends CITCache<T> {
        protected WeakReference<CIT<T>> cit = null;
        protected final Function<CITContext, CIT<T>> realtime;

        public Single(Function<CITContext, CIT<T>> realtime) {
            this.realtime = realtime;
        }

        public WeakReference<CIT<T>> get(CITContext context) {
            if (this.cit == null) {
                offset = (byte)(offset + 4);
                this.lastCachedStamp = System.currentTimeMillis() + (long)CITResewnConfig.INSTANCE.cache_ms + (long)offset;
            }
            if (this.cit == null || System.currentTimeMillis() - this.lastCachedStamp >= (long)CITResewnConfig.INSTANCE.cache_ms) {
                this.cit = new WeakReference<CIT<CIT<T>>>(this.realtime.apply(context));
                this.lastCachedStamp = System.currentTimeMillis();
            }
            return this.cit;
        }
    }
}

