/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.registry;

import com.happysg.radar.CreateRadar;
import com.happysg.radar.block.controller.pitch.PitchLinkBehavior;
import com.happysg.radar.block.controller.track.TrackLinkBehavior;
import com.happysg.radar.block.controller.yaw.YawLinkBehavior;
import com.happysg.radar.block.datalink.DataController;
import com.happysg.radar.block.datalink.DataLinkBehavior;
import com.happysg.radar.block.datalink.DataPeripheral;
import com.happysg.radar.block.monitor.MonitorRadarBehavior;
import com.happysg.radar.block.radar.behavior.RadarScannerLinkBehavior;
import com.happysg.radar.registry.ModBlockEntityTypes;
import com.simibubi.create.api.registry.SimpleRegistry;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AllDataBehaviors {
    public static final Map<ResourceLocation, DataLinkBehavior> GATHERER_BEHAVIOURS = new HashMap<ResourceLocation, DataLinkBehavior>();
    public static final SimpleRegistry<ResourceLocation, DataPeripheral> PERIPHERAL_REGISTRY = SimpleRegistry.create();
    public static final SimpleRegistry<ResourceLocation, DataController> CONTROLLER_REGISTRY = SimpleRegistry.create();
    private static final Map<Block, DataPeripheral> SOURCES_BY_BLOCK = new HashMap<Block, DataPeripheral>();
    private static final Map<BlockEntityType<?>, DataPeripheral> SOURCES_BY_BLOCK_ENTITY = new HashMap();
    private static final Map<Block, DataController> TARGETS_BY_BLOCK = new HashMap<Block, DataController>();
    private static final Map<BlockEntityType<?>, DataController> TARGETS_BY_BLOCK_ENTITY = new HashMap();

    public static void registerDefaults() {
        AllDataBehaviors.assignBlockEntity(AllDataBehaviors.register(CreateRadar.asResource("monitor"), new MonitorRadarBehavior()), (BlockEntityType)ModBlockEntityTypes.MONITOR.get());
        AllDataBehaviors.assignBlockEntity(AllDataBehaviors.register(CreateRadar.asResource("radar"), new RadarScannerLinkBehavior()), (BlockEntityType)ModBlockEntityTypes.RADAR_BEARING.get());
        AllDataBehaviors.assignBlockEntity(AllDataBehaviors.register(CreateRadar.asResource("pitch"), new PitchLinkBehavior()), (BlockEntityType)ModBlockEntityTypes.AUTO_PITCH_CONTROLLER.get());
        AllDataBehaviors.assignBlockEntity(AllDataBehaviors.register(CreateRadar.asResource("yaw"), new YawLinkBehavior()), (BlockEntityType)ModBlockEntityTypes.AUTO_YAW_CONTROLLER.get());
        AllDataBehaviors.assignBlockEntity(AllDataBehaviors.register(CreateRadar.asResource("track"), new TrackLinkBehavior()), (BlockEntityType)ModBlockEntityTypes.TRACK_CONTROLLER.get());
        AllDataBehaviors.assignBlockEntity(AllDataBehaviors.register(CreateRadar.asResource("plane_radar"), new RadarScannerLinkBehavior()), (BlockEntityType)ModBlockEntityTypes.PLANE_RADAR.get());
    }

    public static DataLinkBehavior register(ResourceLocation id, DataLinkBehavior behaviour) {
        behaviour.id = id;
        GATHERER_BEHAVIOURS.put(id, behaviour);
        if (behaviour instanceof DataPeripheral) {
            DataPeripheral dp = (DataPeripheral)behaviour;
            PERIPHERAL_REGISTRY.register((Object)id, (Object)dp);
        }
        if (behaviour instanceof DataController) {
            DataController dc = (DataController)behaviour;
            CONTROLLER_REGISTRY.register((Object)id, (Object)dc);
        }
        return behaviour;
    }

    public static void assignBlock(DataLinkBehavior behaviour, Block block) {
        if (behaviour instanceof DataPeripheral) {
            DataPeripheral source = (DataPeripheral)behaviour;
            SOURCES_BY_BLOCK.put(block, source);
        }
        if (behaviour instanceof DataController) {
            DataController target = (DataController)behaviour;
            TARGETS_BY_BLOCK.put(block, target);
        }
    }

    public static void assignBlockEntity(DataLinkBehavior behaviour, BlockEntityType<?> beType) {
        if (behaviour instanceof DataPeripheral) {
            DataPeripheral source = (DataPeripheral)behaviour;
            SOURCES_BY_BLOCK_ENTITY.put(beType, source);
        }
        if (behaviour instanceof DataController) {
            DataController target = (DataController)behaviour;
            TARGETS_BY_BLOCK_ENTITY.put(beType, target);
        }
    }

    public static <B extends Block> NonNullConsumer<? super B> assignDataBehaviour(DataLinkBehavior behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            ResourceLocation registryName = BuiltInRegistries.f_256975_.m_7981_(b);
            Object object = idSuffix = behaviour instanceof DataPeripheral ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDataBehaviors.assignBlock(AllDataBehaviors.register(new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + (String)idSuffix), behaviour), b);
        };
    }

    public static <B extends BlockEntityType<?>> NonNullConsumer<? super B> assignDataBehaviourBE(DataLinkBehavior behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            ResourceLocation registryName = BuiltInRegistries.f_257049_.m_7981_(b);
            Object object = idSuffix = behaviour instanceof DataPeripheral ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDataBehaviors.assignBlockEntity(AllDataBehaviors.register(new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + (String)idSuffix), behaviour), b);
        };
    }

    @Nullable
    public static DataPeripheral getSource(ResourceLocation id) {
        DataPeripheral source;
        DataLinkBehavior available = GATHERER_BEHAVIOURS.get(id);
        return available instanceof DataPeripheral ? (source = (DataPeripheral)available) : null;
    }

    @Nullable
    public static DataController getTarget(ResourceLocation id) {
        DataController target;
        DataLinkBehavior available = GATHERER_BEHAVIOURS.get(id);
        return available instanceof DataController ? (target = (DataController)available) : null;
    }

    public static DataPeripheral sourcesOf(Block block) {
        return SOURCES_BY_BLOCK.get(block);
    }

    public static DataPeripheral sourcesOf(BlockState state) {
        return AllDataBehaviors.sourcesOf(state.m_60734_());
    }

    public static DataPeripheral sourcesOf(BlockEntityType<?> type) {
        return SOURCES_BY_BLOCK_ENTITY.get(type);
    }

    public static DataPeripheral sourcesOf(BlockEntity entity) {
        return AllDataBehaviors.sourcesOf(entity.m_58903_());
    }

    @Nullable
    public static DataController targetOf(Block block) {
        return TARGETS_BY_BLOCK.get(block);
    }

    @Nullable
    public static DataController targetOf(BlockState state) {
        return AllDataBehaviors.targetOf(state.m_60734_());
    }

    @Nullable
    public static DataController targetOf(BlockEntityType<?> type) {
        return TARGETS_BY_BLOCK_ENTITY.get(type);
    }

    @Nullable
    public static DataController targetOf(BlockEntity entity) {
        return AllDataBehaviors.targetOf(entity.m_58903_());
    }

    public static DataPeripheral sourcesOf(LevelAccessor level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        BlockEntity entity = level.m_7702_(pos);
        DataPeripheral fromBlock = AllDataBehaviors.sourcesOf(state);
        DataPeripheral fromEntity = entity != null ? AllDataBehaviors.sourcesOf(entity) : null;
        return fromEntity != null ? fromEntity : fromBlock;
    }

    @Nullable
    public static DataController targetOf(LevelAccessor level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        BlockEntity entity = level.m_7702_(pos);
        DataController fromBlock = AllDataBehaviors.targetOf(state);
        DataController fromEntity = entity != null ? AllDataBehaviors.targetOf(entity) : null;
        return fromEntity != null ? fromEntity : fromBlock;
    }
}

