/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.math3.ode.nonstiff;

import com.happysg.radar.math3.Field;
import com.happysg.radar.math3.RealFieldElement;
import com.happysg.radar.math3.ode.FieldEquationsMapper;
import com.happysg.radar.math3.ode.FieldODEStateAndDerivative;
import com.happysg.radar.math3.ode.nonstiff.EulerFieldStepInterpolator;
import com.happysg.radar.math3.ode.nonstiff.RungeKuttaFieldIntegrator;
import com.happysg.radar.math3.util.MathArrays;

public class EulerFieldIntegrator<T extends RealFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public EulerFieldIntegrator(Field<T> field, T step) {
        super(field, "Euler", step);
    }

    @Override
    public T[] getC() {
        return (RealFieldElement[])MathArrays.buildArray(this.getField(), 0);
    }

    @Override
    public T[][] getA() {
        return (RealFieldElement[][])MathArrays.buildArray(this.getField(), 0, 0);
    }

    @Override
    public T[] getB() {
        RealFieldElement[] b = (RealFieldElement[])MathArrays.buildArray(this.getField(), 1);
        b[0] = (RealFieldElement)this.getField().getOne();
        return b;
    }

    @Override
    protected EulerFieldStepInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new EulerFieldStepInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

