/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.math3.ml.clustering;

import com.happysg.radar.math3.exception.ConvergenceException;
import com.happysg.radar.math3.exception.MathIllegalArgumentException;
import com.happysg.radar.math3.ml.clustering.Cluster;
import com.happysg.radar.math3.ml.clustering.Clusterable;
import com.happysg.radar.math3.ml.distance.DistanceMeasure;
import java.util.Collection;
import java.util.List;

public abstract class Clusterer<T extends Clusterable> {
    private DistanceMeasure measure;

    protected Clusterer(DistanceMeasure measure) {
        this.measure = measure;
    }

    public abstract List<? extends Cluster<T>> cluster(Collection<T> var1) throws MathIllegalArgumentException, ConvergenceException;

    public DistanceMeasure getDistanceMeasure() {
        return this.measure;
    }

    protected double distance(Clusterable p1, Clusterable p2) {
        return this.measure.compute(p1.getPoint(), p2.getPoint());
    }
}

