/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.math3.genetics;

import com.happysg.radar.math3.exception.util.LocalizedFormats;
import com.happysg.radar.math3.genetics.AbstractListChromosome;
import com.happysg.radar.math3.genetics.Chromosome;
import com.happysg.radar.math3.genetics.GeneticAlgorithm;
import com.happysg.radar.math3.genetics.InvalidRepresentationException;
import java.util.ArrayList;
import java.util.List;

public abstract class BinaryChromosome
extends AbstractListChromosome<Integer> {
    public BinaryChromosome(List<Integer> representation) throws InvalidRepresentationException {
        super(representation);
    }

    public BinaryChromosome(Integer[] representation) throws InvalidRepresentationException {
        super(representation);
    }

    @Override
    protected void checkValidity(List<Integer> chromosomeRepresentation) throws InvalidRepresentationException {
        for (int i : chromosomeRepresentation) {
            if (i >= 0 && i <= 1) continue;
            throw new InvalidRepresentationException(LocalizedFormats.INVALID_BINARY_DIGIT, i);
        }
    }

    public static List<Integer> randomBinaryRepresentation(int length) {
        ArrayList<Integer> rList = new ArrayList<Integer>(length);
        for (int j = 0; j < length; ++j) {
            rList.add(GeneticAlgorithm.getRandomGenerator().nextInt(2));
        }
        return rList;
    }

    @Override
    protected boolean isSame(Chromosome another) {
        if (!(another instanceof BinaryChromosome)) {
            return false;
        }
        BinaryChromosome anotherBc = (BinaryChromosome)another;
        if (this.getLength() != anotherBc.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getRepresentation().size(); ++i) {
            if (((Integer)this.getRepresentation().get(i)).equals(anotherBc.getRepresentation().get(i))) continue;
            return false;
        }
        return true;
    }
}

