/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.compat.cbc;

import com.happysg.radar.compat.cbc.CannonUtil;
import com.happysg.radar.compat.vs2.PhysicsHandler;
import com.happysg.radar.math3.analysis.UnivariateFunction;
import com.happysg.radar.math3.analysis.solvers.BrentSolver;
import com.mojang.logging.LogUtils;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;

public class CannonTargeting {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static double calculateProjectileYatX(double speed, double dX, double thetaRad, double drag, double g) {
        double log = Math.log(1.0 - drag * dX / (speed * Math.cos(thetaRad)));
        if (Double.isInfinite(log)) {
            log = Double.NaN;
        }
        return dX * Math.tan(thetaRad) + dX * g / (drag * speed * Math.cos(thetaRad)) + g * log / (drag * drag);
    }

    public static List<Double> calculatePitch(CannonMountBlockEntity mount, Vec3 targetPos, ServerLevel level) {
        Contraption contraption;
        LOGGER.debug("calculatePitch start: mount={}, targetPos={}", (Object)mount.m_58899_(), (Object)targetPos);
        if (targetPos == null) {
            return null;
        }
        PitchOrientedContraptionEntity contraption2 = mount.getContraption();
        if (contraption2 == null || !((contraption = contraption2.getContraption()) instanceof AbstractMountedCannonContraption)) {
            LOGGER.debug(" \u2192 aborting: no contraption or wrong type");
            return null;
        }
        AbstractMountedCannonContraption cannonContraption = (AbstractMountedCannonContraption)contraption;
        float speed = CannonUtil.getInitialVelocity(cannonContraption, level);
        LOGGER.debug(" \u2192 speed={}", (Object)Float.valueOf(speed));
        Vec3 originPos = PhysicsHandler.getWorldVec((Level)level, mount.m_58899_().m_6630_(2).m_252807_());
        int barrelLength = CannonUtil.getBarrelLength(cannonContraption);
        double drag = CannonUtil.getProjectileDrag(cannonContraption, level);
        double gravity = CannonUtil.getProjectileGravity(cannonContraption, level);
        LOGGER.debug(" \u2192 origin={}, barrelLength={}, drag={}, gravity={}", new Object[]{originPos, barrelLength, drag, gravity});
        if (speed == 0.0f) {
            LOGGER.debug(" \u2192 aborting: speed=0");
            return null;
        }
        double d1 = targetPos.f_82479_ - originPos.f_82479_;
        double d2 = targetPos.f_82481_ - originPos.f_82481_;
        double distance = Math.abs(Math.sqrt(d1 * d1 + d2 * d2));
        double d3 = targetPos.f_82480_ - originPos.f_82480_;
        LOGGER.debug(" \u2192 horizontalDist={}, verticalDist={}", (Object)distance, (Object)d3);
        double g = Math.abs(gravity);
        UnivariateFunction diffFunction = theta -> {
            double thetaRad = Math.toRadians(theta);
            double dX = distance - Math.cos(thetaRad) * (double)barrelLength;
            double dY = d3 - Math.sin(thetaRad) * (double)barrelLength;
            double y = CannonTargeting.calculateProjectileYatX(speed, dX, thetaRad, drag, g);
            return y - dY;
        };
        BrentSolver solver = new BrentSolver(1.0E-32);
        double start = -90.0;
        double end = 90.0;
        double step = 1.0;
        ArrayList<Double> roots = new ArrayList<Double>();
        double prevValue = diffFunction.value(start);
        double prevTheta = start;
        for (double theta2 = start + step; theta2 <= end; theta2 += step) {
            double currValue = diffFunction.value(theta2);
            if (prevValue * currValue < 0.0) {
                try {
                    double root = solver.solve(1000, diffFunction, prevTheta, theta2);
                    LOGGER.debug("   \u2022 found root {} between {} and {}", new Object[]{root, prevTheta, theta2});
                    roots.add(root);
                }
                catch (Exception e) {
                    LOGGER.debug("   \u2022 solver threw {}, aborting", (Object)e.toString());
                    return null;
                }
            }
            prevTheta = Double.isNaN(currValue) ? prevTheta : theta2;
            prevValue = Double.isNaN(currValue) ? prevValue : currValue;
        }
        if (roots.isEmpty()) {
            LOGGER.debug(" \u2192 aborting: no roots found");
            return null;
        }
        LOGGER.debug(" \u2192 returning roots {}", roots);
        return roots;
    }
}

