/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.monitor;

import com.happysg.radar.block.monitor.MonitorBlock;
import com.happysg.radar.block.monitor.MonitorBlockEntity;
import com.happysg.radar.block.radar.track.RadarTrack;
import com.happysg.radar.compat.vs2.PhysicsHandler;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class MonitorInputHandler {
    static Vec3 adjustRelativeVectorForFacing(Vec3 relative, Direction monitorFacing) {
        return switch (monitorFacing) {
            case Direction.NORTH -> new Vec3(relative.m_7096_(), 0.0, relative.m_7098_());
            case Direction.SOUTH -> new Vec3(relative.m_7096_(), 0.0, -relative.m_7098_());
            case Direction.WEST -> new Vec3(relative.m_7098_(), 0.0, relative.m_7094_());
            case Direction.EAST -> new Vec3(-relative.m_7098_(), 0.0, relative.m_7094_());
            default -> relative;
        };
    }

    public static RadarTrack findTrack(Level level, Vec3 hit, MonitorBlockEntity controller) {
        float sizeadj;
        if (controller.getRadarCenterPos() == null) {
            return null;
        }
        Direction facing = ((Direction)level.m_8055_(controller.getControllerPos()).m_61143_((Property)MonitorBlock.f_54117_)).m_122427_();
        Direction monitorFacing = (Direction)level.m_8055_(controller.getControllerPos()).m_61143_((Property)MonitorBlock.f_54117_);
        int size = controller.getSize();
        Vec3 center = Vec3.m_82512_((Vec3i)controller.getControllerPos()).m_82520_((double)(facing.m_122429_() * (size - 1)) / 2.0, (double)(size - 1) / 2.0, (double)(facing.m_122431_() * (size - 1)) / 2.0);
        Vec3 relative = hit.m_82546_(center);
        relative = MonitorInputHandler.adjustRelativeVectorForFacing(relative, monitorFacing);
        Vec3 RadarPos = controller.getRadarCenterPos();
        float range = controller.getRange();
        float f = sizeadj = size == 1 ? 0.5f : (float)(size - 1) / 2.0f;
        if (size == 2) {
            sizeadj = 0.75f;
        }
        Vec3 selected = RadarPos.m_82549_(relative.m_82490_((double)(range / sizeadj)));
        double bestDistance = 0.1f * range;
        RadarTrack bestTrack = null;
        for (RadarTrack track : controller.cachedTracks) {
            double distance = track.position().m_82554_(selected);
            if (!(distance < bestDistance)) continue;
            bestDistance = distance;
            bestTrack = track;
        }
        return bestTrack;
    }

    public static void monitorPlayerHovering(TickEvent.PlayerTickEvent event) {
        MonitorBlockEntity be;
        BlockHitResult result;
        BlockEntity blockEntity;
        Player player = event.player;
        Level level = event.player.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        Vec3 hit = player.m_19907_(5.0, 0.0f, false).m_82450_();
        HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
        if (hitResult instanceof BlockHitResult && (blockEntity = level.m_7702_((result = (BlockHitResult)hitResult).m_82425_())) instanceof MonitorBlockEntity && (blockEntity = level.m_7702_((be = (MonitorBlockEntity)blockEntity).getControllerPos())) instanceof MonitorBlockEntity) {
            String newHovered;
            MonitorBlockEntity monitor = (MonitorBlockEntity)blockEntity;
            hit = PhysicsHandler.getShipVec(hit, (BlockEntity)be);
            RadarTrack track = MonitorInputHandler.findTrack(level, hit, monitor);
            String oldHovered = monitor.hoveredEntity;
            String string = newHovered = track != null ? track.id() : null;
            if (oldHovered == null && newHovered != null || oldHovered != null && !oldHovered.equals(newHovered)) {
                monitor.hoveredEntity = newHovered;
                monitor.notifyUpdate();
            }
        }
    }

    public static InteractionResult onUse(MonitorBlockEntity be, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, Direction facing) {
        if (pPlayer.m_6144_()) {
            be.selectedEntity = null;
            be.notifyUpdate();
        } else {
            RadarTrack track = MonitorInputHandler.findTrack(be.m_58904_(), pHit.m_82450_(), be.getController());
            if (track != null) {
                be.selectedEntity = track.id();
                be.notifyUpdate();
            }
        }
        return InteractionResult.SUCCESS;
    }
}

